package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.util.Map;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PolicyRuleFluentImpl<A extends PolicyRuleFluent<A>> extends BaseFluent<A> implements PolicyRuleFluent<A>{
  public PolicyRuleFluentImpl() {
  }
  public PolicyRuleFluentImpl(PolicyRule instance) {
    if (instance != null) {
      this.withApiGroups(instance.getApiGroups());
      this.withAttributeRestrictions(instance.getAttributeRestrictions());
      this.withNonResourceURLs(instance.getNonResourceURLs());
      this.withResourceNames(instance.getResourceNames());
      this.withResources(instance.getResources());
      this.withVerbs(instance.getVerbs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> apiGroups = new ArrayList<String>();
  private VisitableBuilder<? extends KubernetesResource,?> attributeRestrictions;
  private List<String> nonResourceURLs = new ArrayList<String>();
  private List<String> resourceNames = new ArrayList<String>();
  private List<String> resources = new ArrayList<String>();
  private List<String> verbs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToApiGroups(int index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.add(index, item);
    return (A)this;
  }
  public A setToApiGroups(int index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.set(index, item); return (A)this;
  }
  public A addToApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A addAllToApiGroups(Collection<String> items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A removeFromApiGroups(java.lang.String... items) {
    for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromApiGroups(Collection<String> items) {
    for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public List<String> getApiGroups() {
    return this.apiGroups;
  }
  public String getApiGroup(int index) {
    return this.apiGroups.get(index);
  }
  public String getFirstApiGroup() {
    return this.apiGroups.get(0);
  }
  public String getLastApiGroup() {
    return this.apiGroups.get(apiGroups.size() - 1);
  }
  public String getMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiGroups(List<String> apiGroups) {
    if (apiGroups != null) {this.apiGroups = new ArrayList(); for (String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
  }
  public A withApiGroups(java.lang.String... apiGroups) {
    if (this.apiGroups != null) {this.apiGroups.clear(); _visitables.remove("apiGroups"); }
    if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
  }
  public Boolean hasApiGroups() {
    return apiGroups != null && !apiGroups.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildAttributeRestrictions instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getAttributeRestrictions() {
    return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
  }
  public KubernetesResource buildAttributeRestrictions() {
    return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
  }
  public A withAttributeRestrictions(KubernetesResource attributeRestrictions) {
    if (attributeRestrictions==null){ this.attributeRestrictions = null; _visitables.remove("attributeRestrictions"); return (A) this;}
    if (attributeRestrictions instanceof GenericWebHookCause){ this.attributeRestrictions= new GenericWebHookCauseBuilder((GenericWebHookCause)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ServiceAccountRestriction){ this.attributeRestrictions= new ServiceAccountRestrictionBuilder((ServiceAccountRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ScopeRestriction){ this.attributeRestrictions= new ScopeRestrictionBuilder((ScopeRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecretLocalReference){ this.attributeRestrictions= new SecretLocalReferenceBuilder((SecretLocalReference)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof StepInfo){ this.attributeRestrictions= new StepInfoBuilder((StepInfo)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserRestriction){ this.attributeRestrictions= new UserRestrictionBuilder((UserRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodTemplateSpec){ this.attributeRestrictions= new PodTemplateSpecBuilder((PodTemplateSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceList){ this.attributeRestrictions= new TemplateInstanceListBuilder((TemplateInstanceList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImport){ this.attributeRestrictions= new ImageStreamImportBuilder((ImageStreamImport)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ResourceRequirements){ this.attributeRestrictions= new ResourceRequirementsBuilder((ResourceRequirements)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GitHubWebHookCause){ this.attributeRestrictions= new GitHubWebHookCauseBuilder((GitHubWebHookCause)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClientList){ this.attributeRestrictions= new OAuthClientListBuilder((OAuthClientList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicyReviewStatus){ this.attributeRestrictions= new PodSecurityPolicyReviewStatusBuilder((PodSecurityPolicyReviewStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceStatus){ this.attributeRestrictions= new TemplateInstanceStatusBuilder((TemplateInstanceStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepositoryList){ this.attributeRestrictions= new HelmChartRepositoryListBuilder((HelmChartRepositoryList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PolicyRule){ this.attributeRestrictions= new PolicyRuleBuilder((PolicyRule)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentTriggerPolicy){ this.attributeRestrictions= new DeploymentTriggerPolicyBuilder((DeploymentTriggerPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildStrategy){ this.attributeRestrictions= new BuildStrategyBuilder((BuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RepositoryImportSpec){ this.attributeRestrictions= new RepositoryImportSpecBuilder((RepositoryImportSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BrokerTemplateInstanceList){ this.attributeRestrictions= new BrokerTemplateInstanceListBuilder((BrokerTemplateInstanceList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImportStatus){ this.attributeRestrictions= new ImageStreamImportStatusBuilder((ImageStreamImportStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof CustomBuildStrategy){ this.attributeRestrictions= new CustomBuildStrategyBuilder((CustomBuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuotaSelector){ this.attributeRestrictions= new ClusterResourceQuotaSelectorBuilder((ClusterResourceQuotaSelector)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectAccessReviewResponse){ this.attributeRestrictions= new SubjectAccessReviewResponseBuilder((SubjectAccessReviewResponse)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentTriggerImageChangeParams){ this.attributeRestrictions= new DeploymentTriggerImageChangeParamsBuilder((DeploymentTriggerImageChangeParams)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LocalObjectReference){ this.attributeRestrictions= new LocalObjectReferenceBuilder((LocalObjectReference)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagImageHook){ this.attributeRestrictions= new TagImageHookBuilder((TagImageHook)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteTargetReference){ this.attributeRestrictions= new RouteTargetReferenceBuilder((RouteTargetReference)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.runtime.RawExtension){ this.attributeRestrictions= new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder((io.fabric8.openshift.api.model.runtime.RawExtension)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectRulesReviewSpec){ this.attributeRestrictions= new SubjectRulesReviewSpecBuilder((SubjectRulesReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagReferencePolicy){ this.attributeRestrictions= new TagReferencePolicyBuilder((TagReferencePolicy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleList){ this.attributeRestrictions= new RoleListBuilder((RoleList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Project){ this.attributeRestrictions= new ProjectBuilder((Project)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildVolumeSource){ this.attributeRestrictions= new BuildVolumeSourceBuilder((BuildVolumeSource)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof AppliedClusterResourceQuotaList){ this.attributeRestrictions= new AppliedClusterResourceQuotaListBuilder((AppliedClusterResourceQuotaList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfigList){ this.attributeRestrictions= new DeploymentConfigListBuilder((DeploymentConfigList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildStatusOutput){ this.attributeRestrictions= new BuildStatusOutputBuilder((BuildStatusOutput)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfig){ this.attributeRestrictions= new BuildConfigBuilder((BuildConfig)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageImportStatus){ this.attributeRestrictions= new ImageImportStatusBuilder((ImageImportStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySubjectReview){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewBuilder((PodSecurityPolicySubjectReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GitLabWebHookCause){ this.attributeRestrictions= new GitLabWebHookCauseBuilder((GitLabWebHookCause)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfigStatus){ this.attributeRestrictions= new DeploymentConfigStatusBuilder((DeploymentConfigStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecretBuildSource){ this.attributeRestrictions= new SecretBuildSourceBuilder((SecretBuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicySpec){ this.attributeRestrictions= new EgressNetworkPolicySpecBuilder((EgressNetworkPolicySpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepository){ this.attributeRestrictions= new HelmChartRepositoryBuilder((HelmChartRepository)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagEvent){ this.attributeRestrictions= new TagEventBuilder((TagEvent)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamTagList){ this.attributeRestrictions= new ImageStreamTagListBuilder((ImageStreamTagList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BitbucketWebHookCause){ this.attributeRestrictions= new BitbucketWebHookCauseBuilder((BitbucketWebHookCause)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectList){ this.attributeRestrictions= new ProjectListBuilder((ProjectList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RangeAllocation){ this.attributeRestrictions= new RangeAllocationBuilder((RangeAllocation)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleScopeRestriction){ this.attributeRestrictions= new ClusterRoleScopeRestrictionBuilder((ClusterRoleScopeRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Route){ this.attributeRestrictions= new RouteBuilder((Route)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SourceStrategyOptions){ this.attributeRestrictions= new SourceStrategyOptionsBuilder((SourceStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterNetwork){ this.attributeRestrictions= new ClusterNetworkBuilder((ClusterNetwork)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAuthorizeToken){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DockerBuildStrategy){ this.attributeRestrictions= new DockerBuildStrategyBuilder((DockerBuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SignatureCondition){ this.attributeRestrictions= new SignatureConditionBuilder((SignatureCondition)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserOAuthAccessToken){ this.attributeRestrictions= new UserOAuthAccessTokenBuilder((UserOAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingRestrictionList){ this.attributeRestrictions= new RoleBindingRestrictionListBuilder((RoleBindingRestrictionList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RawExtension){ this.attributeRestrictions= new RawExtensionBuilder((RawExtension)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecurityContextConstraintsList){ this.attributeRestrictions= new SecurityContextConstraintsListBuilder((SecurityContextConstraintsList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof IdentityList){ this.attributeRestrictions= new IdentityListBuilder((IdentityList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfigList){ this.attributeRestrictions= new BuildConfigListBuilder((BuildConfigList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterNetworkList){ this.attributeRestrictions= new ClusterNetworkListBuilder((ClusterNetworkList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceCondition){ this.attributeRestrictions= new TemplateInstanceConditionBuilder((TemplateInstanceCondition)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RepositoryImportStatus){ this.attributeRestrictions= new RepositoryImportStatusBuilder((RepositoryImportStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentCause){ this.attributeRestrictions= new DeploymentCauseBuilder((DeploymentCause)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GroupList){ this.attributeRestrictions= new GroupListBuilder((GroupList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RunAsUserStrategyOptions){ this.attributeRestrictions= new RunAsUserStrategyOptionsBuilder((RunAsUserStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LifecycleHook){ this.attributeRestrictions= new LifecycleHookBuilder((LifecycleHook)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamTagReference){ this.attributeRestrictions= new ImageStreamTagReferenceBuilder((ImageStreamTagReference)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SourceControlUser){ this.attributeRestrictions= new SourceControlUserBuilder((SourceControlUser)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Container){ this.attributeRestrictions= new ContainerBuilder((Container)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamList){ this.attributeRestrictions= new ImageStreamListBuilder((ImageStreamList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleBinding){ this.attributeRestrictions= new ClusterRoleBindingBuilder((ClusterRoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ResourceAccessReview){ this.attributeRestrictions= new ResourceAccessReviewBuilder((ResourceAccessReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SelfSubjectRulesReview){ this.attributeRestrictions= new SelfSubjectRulesReviewBuilder((SelfSubjectRulesReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserOAuthAccessTokenList){ this.attributeRestrictions= new UserOAuthAccessTokenListBuilder((UserOAuthAccessTokenList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageChangeTriggerStatus){ this.attributeRestrictions= new ImageChangeTriggerStatusBuilder((ImageChangeTriggerStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteStatus){ this.attributeRestrictions= new RouteStatusBuilder((RouteStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuota){ this.attributeRestrictions= new ClusterResourceQuotaBuilder((ClusterResourceQuota)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof NamedTagEventList){ this.attributeRestrictions= new NamedTagEventListBuilder((NamedTagEventList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuotaList){ this.attributeRestrictions= new ClusterResourceQuotaListBuilder((ClusterResourceQuotaList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteSpec){ this.attributeRestrictions= new RouteSpecBuilder((RouteSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectRequest){ this.attributeRestrictions= new ProjectRequestBuilder((ProjectRequest)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Template){ this.attributeRestrictions= new TemplateBuilder((Template)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageLookupPolicy){ this.attributeRestrictions= new ImageLookupPolicyBuilder((ImageLookupPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClientAuthorization){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageChangeCause){ this.attributeRestrictions= new ImageChangeCauseBuilder((ImageChangeCause)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof AllowedFlexVolume){ this.attributeRestrictions= new AllowedFlexVolumeBuilder((AllowedFlexVolume)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectAccessReview){ this.attributeRestrictions= new SubjectAccessReviewBuilder((SubjectAccessReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LocalResourceAccessReview){ this.attributeRestrictions= new LocalResourceAccessReviewBuilder((LocalResourceAccessReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRole){ this.attributeRestrictions= new ClusterRoleBuilder((ClusterRole)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ConnectionConfig){ this.attributeRestrictions= new ConnectionConfigBuilder((ConnectionConfig)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagEventCondition){ this.attributeRestrictions= new TagEventConditionBuilder((TagEventCondition)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LabelSelector){ this.attributeRestrictions= new LabelSelectorBuilder((LabelSelector)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof NetNamespaceList){ this.attributeRestrictions= new NetNamespaceListBuilder((NetNamespaceList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BrokerTemplateInstanceSpec){ this.attributeRestrictions= new BrokerTemplateInstanceSpecBuilder((BrokerTemplateInstanceSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BinaryBuildSource){ this.attributeRestrictions= new BinaryBuildSourceBuilder((BinaryBuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClientAuthorizationList){ this.attributeRestrictions= new OAuthClientAuthorizationListBuilder((OAuthClientAuthorizationList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildSpec){ this.attributeRestrictions= new BuildSpecBuilder((BuildSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectStatus){ this.attributeRestrictions= new ProjectStatusBuilder((ProjectStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LocalSubjectAccessReview){ this.attributeRestrictions= new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RollingDeploymentStrategyParams){ this.attributeRestrictions= new RollingDeploymentStrategyParamsBuilder((RollingDeploymentStrategyParams)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GitSourceRevision){ this.attributeRestrictions= new GitSourceRevisionBuilder((GitSourceRevision)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageLabel){ this.attributeRestrictions= new ImageLabelBuilder((ImageLabel)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageChangeTrigger){ this.attributeRestrictions= new ImageChangeTriggerBuilder((ImageChangeTrigger)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicyReviewSpec){ this.attributeRestrictions= new PodSecurityPolicyReviewSpecBuilder((PodSecurityPolicyReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageTag){ this.attributeRestrictions= new ImageTagBuilder((ImageTag)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImportSpec){ this.attributeRestrictions= new ImageStreamImportSpecBuilder((ImageStreamImportSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof FSGroupStrategyOptions){ this.attributeRestrictions= new FSGroupStrategyOptionsBuilder((FSGroupStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicyReview){ this.attributeRestrictions= new PodSecurityPolicyReviewBuilder((PodSecurityPolicyReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RecreateDeploymentStrategyParams){ this.attributeRestrictions= new RecreateDeploymentStrategyParamsBuilder((RecreateDeploymentStrategyParams)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DockerStrategyOptions){ this.attributeRestrictions= new DockerStrategyOptionsBuilder((DockerStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageList){ this.attributeRestrictions= new ImageListBuilder((ImageList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ConfigMapBuildSource){ this.attributeRestrictions= new ConfigMapBuildSourceBuilder((ConfigMapBuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageTagList){ this.attributeRestrictions= new ImageTagListBuilder((ImageTagList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAccessToken){ this.attributeRestrictions= new OAuthAccessTokenBuilder((OAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfig){ this.attributeRestrictions= new DeploymentConfigBuilder((DeploymentConfig)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBinding){ this.attributeRestrictions= new RoleBindingBuilder((RoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Image){ this.attributeRestrictions= new ImageBuilder((Image)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TLSConfig){ this.attributeRestrictions= new TLSConfigBuilder((TLSConfig)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildVolume){ this.attributeRestrictions= new BuildVolumeBuilder((BuildVolume)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceSpec){ this.attributeRestrictions= new TemplateInstanceSpecBuilder((TemplateInstanceSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildStatus){ this.attributeRestrictions= new BuildStatusBuilder((BuildStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageSource){ this.attributeRestrictions= new ImageSourceBuilder((ImageSource)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ObjectMeta){ this.attributeRestrictions= new ObjectMetaBuilder((ObjectMeta)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PersistentVolumeClaim){ this.attributeRestrictions= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySelfSubjectReview){ this.attributeRestrictions= new PodSecurityPolicySelfSubjectReviewBuilder((PodSecurityPolicySelfSubjectReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagReference){ this.attributeRestrictions= new TagReferenceBuilder((TagReference)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicyRule){ this.attributeRestrictions= new EgressNetworkPolicyRuleBuilder((EgressNetworkPolicyRule)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectRulesReviewStatus){ this.attributeRestrictions= new SubjectRulesReviewStatusBuilder((SubjectRulesReviewStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildVolumeMount){ this.attributeRestrictions= new BuildVolumeMountBuilder((BuildVolumeMount)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterNetworkEntry){ this.attributeRestrictions= new ClusterNetworkEntryBuilder((ClusterNetworkEntry)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceObject){ this.attributeRestrictions= new TemplateInstanceObjectBuilder((TemplateInstanceObject)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GenericKubernetesResource){ this.attributeRestrictions= new GenericKubernetesResourceBuilder((GenericKubernetesResource)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildSource){ this.attributeRestrictions= new BuildSourceBuilder((BuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuotaStatus){ this.attributeRestrictions= new ClusterResourceQuotaStatusBuilder((ClusterResourceQuotaStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentCondition){ this.attributeRestrictions= new DeploymentConditionBuilder((DeploymentCondition)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepositorySpec){ this.attributeRestrictions= new HelmChartRepositorySpecBuilder((HelmChartRepositorySpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentCauseImageTrigger){ this.attributeRestrictions= new DeploymentCauseImageTriggerBuilder((DeploymentCauseImageTrigger)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamMapping){ this.attributeRestrictions= new ImageStreamMappingBuilder((ImageStreamMapping)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectRulesReview){ this.attributeRestrictions= new SubjectRulesReviewBuilder((SubjectRulesReview)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Role){ this.attributeRestrictions= new RoleBuilder((Role)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GitBuildSource){ this.attributeRestrictions= new GitBuildSourceBuilder((GitBuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicyList){ this.attributeRestrictions= new EgressNetworkPolicyListBuilder((EgressNetworkPolicyList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SelfSubjectRulesReviewSpec){ this.attributeRestrictions= new SelfSubjectRulesReviewSpecBuilder((SelfSubjectRulesReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageSourcePath){ this.attributeRestrictions= new ImageSourcePathBuilder((ImageSourcePath)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfigStatus){ this.attributeRestrictions= new BuildConfigStatusBuilder((BuildConfigStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ResourceQuotaStatusByNamespace){ this.attributeRestrictions= new ResourceQuotaStatusByNamespaceBuilder((ResourceQuotaStatusByNamespace)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SourceBuildStrategy){ this.attributeRestrictions= new SourceBuildStrategyBuilder((SourceBuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Parameter){ this.attributeRestrictions= new ParameterBuilder((Parameter)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingList){ this.attributeRestrictions= new RoleBindingListBuilder((RoleBindingList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySelfSubjectReviewSpec){ this.attributeRestrictions= new PodSecurityPolicySelfSubjectReviewSpecBuilder((PodSecurityPolicySelfSubjectReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BrokerTemplateInstance){ this.attributeRestrictions= new BrokerTemplateInstanceBuilder((BrokerTemplateInstance)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildPostCommitSpec){ this.attributeRestrictions= new BuildPostCommitSpecBuilder((BuildPostCommitSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAuthorizeTokenList){ this.attributeRestrictions= new OAuthAuthorizeTokenListBuilder((OAuthAuthorizeTokenList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentStrategy){ this.attributeRestrictions= new DeploymentStrategyBuilder((DeploymentStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SignatureSubject){ this.attributeRestrictions= new SignatureSubjectBuilder((SignatureSubject)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HostSubnetList){ this.attributeRestrictions= new HostSubnetListBuilder((HostSubnetList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteIngressCondition){ this.attributeRestrictions= new RouteIngressConditionBuilder((RouteIngressCondition)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof CustomDeploymentStrategyParams){ this.attributeRestrictions= new CustomDeploymentStrategyParamsBuilder((CustomDeploymentStrategyParams)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageImportSpec){ this.attributeRestrictions= new ImageImportSpecBuilder((ImageImportSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof StageInfo){ this.attributeRestrictions= new StageInfoBuilder((StageInfo)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingRestrictionSpec){ this.attributeRestrictions= new RoleBindingRestrictionSpecBuilder((RoleBindingRestrictionSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof IDRange){ this.attributeRestrictions= new IDRangeBuilder((IDRange)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserList){ this.attributeRestrictions= new UserListBuilder((UserList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfigSpec){ this.attributeRestrictions= new BuildConfigSpecBuilder((BuildConfigSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof User){ this.attributeRestrictions= new UserBuilder((User)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImage){ this.attributeRestrictions= new ImageStreamImageBuilder((ImageStreamImage)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildStatusOutputTo){ this.attributeRestrictions= new BuildStatusOutputToBuilder((BuildStatusOutputTo)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildCondition){ this.attributeRestrictions= new BuildConditionBuilder((BuildCondition)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ResourceAccessReviewResponse){ this.attributeRestrictions= new ResourceAccessReviewResponseBuilder((ResourceAccessReviewResponse)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ExecNewPodHook){ this.attributeRestrictions= new ExecNewPodHookBuilder((ExecNewPodHook)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecretSpec){ this.attributeRestrictions= new SecretSpecBuilder((SecretSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleBindingList){ this.attributeRestrictions= new ClusterRoleBindingListBuilder((ClusterRoleBindingList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicyPeer){ this.attributeRestrictions= new EgressNetworkPolicyPeerBuilder((EgressNetworkPolicyPeer)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstance){ this.attributeRestrictions= new TemplateInstanceBuilder((TemplateInstance)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof WebHookTrigger){ this.attributeRestrictions= new WebHookTriggerBuilder((WebHookTrigger)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ServiceAccountReference){ this.attributeRestrictions= new ServiceAccountReferenceBuilder((ServiceAccountReference)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Build){ this.attributeRestrictions= new BuildBuilder((Build)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingRestriction){ this.attributeRestrictions= new RoleBindingRestrictionBuilder((RoleBindingRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagImportPolicy){ this.attributeRestrictions= new TagImportPolicyBuilder((TagImportPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamTag){ this.attributeRestrictions= new ImageStreamTagBuilder((ImageStreamTag)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildTriggerPolicy){ this.attributeRestrictions= new BuildTriggerPolicyBuilder((BuildTriggerPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoutePort){ this.attributeRestrictions= new RoutePortBuilder((RoutePort)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceRequester){ this.attributeRestrictions= new TemplateInstanceRequesterBuilder((TemplateInstanceRequester)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Group){ this.attributeRestrictions= new GroupBuilder((Group)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildTriggerCause){ this.attributeRestrictions= new BuildTriggerCauseBuilder((BuildTriggerCause)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageSignature){ this.attributeRestrictions= new ImageSignatureBuilder((ImageSignature)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepositoryStatus){ this.attributeRestrictions= new HelmChartRepositoryStatusBuilder((HelmChartRepositoryStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfigSpec){ this.attributeRestrictions= new DeploymentConfigSpecBuilder((DeploymentConfigSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HostSubnet){ this.attributeRestrictions= new HostSubnetBuilder((HostSubnet)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GroupRestriction){ this.attributeRestrictions= new GroupRestrictionBuilder((GroupRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof AppliedClusterResourceQuota){ this.attributeRestrictions= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAccessTokenList){ this.attributeRestrictions= new OAuthAccessTokenListBuilder((OAuthAccessTokenList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof JenkinsPipelineBuildStrategy){ this.attributeRestrictions= new JenkinsPipelineBuildStrategyBuilder((JenkinsPipelineBuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecurityContextConstraints){ this.attributeRestrictions= new SecurityContextConstraintsBuilder((SecurityContextConstraints)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SupplementalGroupsStrategyOptions){ this.attributeRestrictions= new SupplementalGroupsStrategyOptionsBuilder((SupplementalGroupsStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ServiceAccountPodSecurityPolicyReviewStatus){ this.attributeRestrictions= new ServiceAccountPodSecurityPolicyReviewStatusBuilder((ServiceAccountPodSecurityPolicyReviewStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildRequest){ this.attributeRestrictions= new BuildRequestBuilder((BuildRequest)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SELinuxContextStrategyOptions){ this.attributeRestrictions= new SELinuxContextStrategyOptionsBuilder((SELinuxContextStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleList){ this.attributeRestrictions= new ClusterRoleListBuilder((ClusterRoleList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteList){ this.attributeRestrictions= new RouteListBuilder((RouteList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamStatus){ this.attributeRestrictions= new ImageStreamStatusBuilder((ImageStreamStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicy){ this.attributeRestrictions= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof NetNamespace){ this.attributeRestrictions= new NetNamespaceBuilder((NetNamespace)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserIdentityMapping){ this.attributeRestrictions= new UserIdentityMappingBuilder((UserIdentityMapping)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentDetails){ this.attributeRestrictions= new DeploymentDetailsBuilder((DeploymentDetails)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySubjectReviewStatus){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewStatusBuilder((PodSecurityPolicySubjectReviewStatus)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySubjectReviewSpec){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewSpecBuilder((PodSecurityPolicySubjectReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStream){ this.attributeRestrictions= new ImageStreamBuilder((ImageStream)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildList){ this.attributeRestrictions= new BuildListBuilder((BuildList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateList){ this.attributeRestrictions= new TemplateListBuilder((TemplateList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildOutput){ this.attributeRestrictions= new BuildOutputBuilder((BuildOutput)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectSpec){ this.attributeRestrictions= new ProjectSpecBuilder((ProjectSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SourceRevision){ this.attributeRestrictions= new SourceRevisionBuilder((SourceRevision)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ObjectReference){ this.attributeRestrictions= new ObjectReferenceBuilder((ObjectReference)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SignatureIssuer){ this.attributeRestrictions= new SignatureIssuerBuilder((SignatureIssuer)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageLayer){ this.attributeRestrictions= new ImageLayerBuilder((ImageLayer)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuotaSpec){ this.attributeRestrictions= new ClusterResourceQuotaSpecBuilder((ClusterResourceQuotaSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamSpec){ this.attributeRestrictions= new ImageStreamSpecBuilder((ImageStreamSpec)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteIngress){ this.attributeRestrictions= new RouteIngressBuilder((RouteIngress)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClient){ this.attributeRestrictions= new OAuthClientBuilder((OAuthClient)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Identity){ this.attributeRestrictions= new IdentityBuilder((Identity)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RangeAllocationList){ this.attributeRestrictions= new RangeAllocationListBuilder((RangeAllocationList)attributeRestrictions); _visitables.get("attributeRestrictions").clear(); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    VisitableBuilder<? extends KubernetesResource,?> builder = builderOf(attributeRestrictions); _visitables.get("attributeRestrictions").clear();_visitables.get("attributeRestrictions").add(builder);this.attributeRestrictions = builder;
    return (A) this;
  }
  public Boolean hasAttributeRestrictions() {
    return this.attributeRestrictions != null;
  }
  public A withGenericWebHookCauseAttributeRestrictions(GenericWebHookCause genericWebHookCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (genericWebHookCauseAttributeRestrictions!=null){ this.attributeRestrictions= new GenericWebHookCauseBuilder(genericWebHookCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GenericWebHookCauseAttributeRestrictionsNested<A> withNewGenericWebHookCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GenericWebHookCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GenericWebHookCauseAttributeRestrictionsNested<A> withNewGenericWebHookCauseAttributeRestrictionsLike(GenericWebHookCause item) {
    return new PolicyRuleFluentImpl.GenericWebHookCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withServiceAccountRestrictionAttributeRestrictions(ServiceAccountRestriction serviceAccountRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (serviceAccountRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new ServiceAccountRestrictionBuilder(serviceAccountRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ServiceAccountRestrictionAttributeRestrictionsNested<A> withNewServiceAccountRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ServiceAccountRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ServiceAccountRestrictionAttributeRestrictionsNested<A> withNewServiceAccountRestrictionAttributeRestrictionsLike(ServiceAccountRestriction item) {
    return new PolicyRuleFluentImpl.ServiceAccountRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withScopeRestrictionAttributeRestrictions(ScopeRestriction scopeRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (scopeRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new ScopeRestrictionBuilder(scopeRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ScopeRestrictionAttributeRestrictionsNested<A> withNewScopeRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ScopeRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ScopeRestrictionAttributeRestrictionsNested<A> withNewScopeRestrictionAttributeRestrictionsLike(ScopeRestriction item) {
    return new PolicyRuleFluentImpl.ScopeRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withSecretLocalReferenceAttributeRestrictions(SecretLocalReference secretLocalReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (secretLocalReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new SecretLocalReferenceBuilder(secretLocalReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SecretLocalReferenceAttributeRestrictionsNested<A> withNewSecretLocalReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecretLocalReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SecretLocalReferenceAttributeRestrictionsNested<A> withNewSecretLocalReferenceAttributeRestrictionsLike(SecretLocalReference item) {
    return new PolicyRuleFluentImpl.SecretLocalReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSecretLocalReferenceAttributeRestrictions(String name) {
    return (A)withSecretLocalReferenceAttributeRestrictions(new SecretLocalReference(name));
  }
  public A withStepInfoAttributeRestrictions(StepInfo stepInfoAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (stepInfoAttributeRestrictions!=null){ this.attributeRestrictions= new StepInfoBuilder(stepInfoAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.StepInfoAttributeRestrictionsNested<A> withNewStepInfoAttributeRestrictions() {
    return new PolicyRuleFluentImpl.StepInfoAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.StepInfoAttributeRestrictionsNested<A> withNewStepInfoAttributeRestrictionsLike(StepInfo item) {
    return new PolicyRuleFluentImpl.StepInfoAttributeRestrictionsNestedImpl(item);
  }
  public A withNewStepInfoAttributeRestrictions(Long durationMilliseconds,String name,String startTime) {
    return (A)withStepInfoAttributeRestrictions(new StepInfo(durationMilliseconds, name, startTime));
  }
  public A withUserRestrictionAttributeRestrictions(UserRestriction userRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new UserRestrictionBuilder(userRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.UserRestrictionAttributeRestrictionsNested<A> withNewUserRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.UserRestrictionAttributeRestrictionsNested<A> withNewUserRestrictionAttributeRestrictionsLike(UserRestriction item) {
    return new PolicyRuleFluentImpl.UserRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withPodTemplateSpecAttributeRestrictions(PodTemplateSpec podTemplateSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podTemplateSpecAttributeRestrictions!=null){ this.attributeRestrictions= new PodTemplateSpecBuilder(podTemplateSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodTemplateSpecAttributeRestrictionsNested<A> withNewPodTemplateSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodTemplateSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodTemplateSpecAttributeRestrictionsNested<A> withNewPodTemplateSpecAttributeRestrictionsLike(PodTemplateSpec item) {
    return new PolicyRuleFluentImpl.PodTemplateSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceListAttributeRestrictions(TemplateInstanceList templateInstanceListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceListAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceListBuilder(templateInstanceListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateInstanceListAttributeRestrictionsNested<A> withNewTemplateInstanceListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateInstanceListAttributeRestrictionsNested<A> withNewTemplateInstanceListAttributeRestrictionsLike(TemplateInstanceList item) {
    return new PolicyRuleFluentImpl.TemplateInstanceListAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImportAttributeRestrictions(ImageStreamImport imageStreamImportAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImportAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportBuilder(imageStreamImportAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(ImageStreamImport item) {
    return new PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNestedImpl(item);
  }
  public A withResourceRequirementsAttributeRestrictions(ResourceRequirements resourceRequirementsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (resourceRequirementsAttributeRestrictions!=null){ this.attributeRestrictions= new ResourceRequirementsBuilder(resourceRequirementsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ResourceRequirementsAttributeRestrictionsNested<A> withNewResourceRequirementsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ResourceRequirementsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ResourceRequirementsAttributeRestrictionsNested<A> withNewResourceRequirementsAttributeRestrictionsLike(ResourceRequirements item) {
    return new PolicyRuleFluentImpl.ResourceRequirementsAttributeRestrictionsNestedImpl(item);
  }
  public A withGitHubWebHookCauseAttributeRestrictions(GitHubWebHookCause gitHubWebHookCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (gitHubWebHookCauseAttributeRestrictions!=null){ this.attributeRestrictions= new GitHubWebHookCauseBuilder(gitHubWebHookCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GitHubWebHookCauseAttributeRestrictionsNested<A> withNewGitHubWebHookCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GitHubWebHookCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GitHubWebHookCauseAttributeRestrictionsNested<A> withNewGitHubWebHookCauseAttributeRestrictionsLike(GitHubWebHookCause item) {
    return new PolicyRuleFluentImpl.GitHubWebHookCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthClientListAttributeRestrictions(OAuthClientList oAuthClientListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientListAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientListBuilder(oAuthClientListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OAuthClientListAttributeRestrictionsNested<A> withNewOAuthClientListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OAuthClientListAttributeRestrictionsNested<A> withNewOAuthClientListAttributeRestrictionsLike(OAuthClientList item) {
    return new PolicyRuleFluentImpl.OAuthClientListAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewStatusAttributeRestrictions(PodSecurityPolicyReviewStatus podSecurityPolicyReviewStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicyReviewStatusAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicyReviewStatusBuilder(podSecurityPolicyReviewStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewStatusAttributeRestrictionsLike(PodSecurityPolicyReviewStatus item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceStatusAttributeRestrictions(TemplateInstanceStatus templateInstanceStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceStatusAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceStatusBuilder(templateInstanceStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateInstanceStatusAttributeRestrictionsNested<A> withNewTemplateInstanceStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateInstanceStatusAttributeRestrictionsNested<A> withNewTemplateInstanceStatusAttributeRestrictionsLike(TemplateInstanceStatus item) {
    return new PolicyRuleFluentImpl.TemplateInstanceStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositoryListAttributeRestrictions(HelmChartRepositoryList helmChartRepositoryListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositoryListAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositoryListBuilder(helmChartRepositoryListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.HelmChartRepositoryListAttributeRestrictionsNested<A> withNewHelmChartRepositoryListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositoryListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.HelmChartRepositoryListAttributeRestrictionsNested<A> withNewHelmChartRepositoryListAttributeRestrictionsLike(HelmChartRepositoryList item) {
    return new PolicyRuleFluentImpl.HelmChartRepositoryListAttributeRestrictionsNestedImpl(item);
  }
  public A withPolicyRuleAttributeRestrictions(PolicyRule policyRuleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (policyRuleAttributeRestrictions!=null){ this.attributeRestrictions= new PolicyRuleBuilder(policyRuleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PolicyRuleAttributeRestrictionsNested<A> withNewPolicyRuleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PolicyRuleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PolicyRuleAttributeRestrictionsNested<A> withNewPolicyRuleAttributeRestrictionsLike(PolicyRule item) {
    return new PolicyRuleFluentImpl.PolicyRuleAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentTriggerPolicyAttributeRestrictions(DeploymentTriggerPolicy deploymentTriggerPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentTriggerPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentTriggerPolicyBuilder(deploymentTriggerPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentTriggerPolicyAttributeRestrictionsNested<A> withNewDeploymentTriggerPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentTriggerPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentTriggerPolicyAttributeRestrictionsNested<A> withNewDeploymentTriggerPolicyAttributeRestrictionsLike(DeploymentTriggerPolicy item) {
    return new PolicyRuleFluentImpl.DeploymentTriggerPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildStrategyAttributeRestrictions(BuildStrategy buildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new BuildStrategyBuilder(buildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildStrategyAttributeRestrictionsNested<A> withNewBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildStrategyAttributeRestrictionsNested<A> withNewBuildStrategyAttributeRestrictionsLike(BuildStrategy item) {
    return new PolicyRuleFluentImpl.BuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withRepositoryImportSpecAttributeRestrictions(RepositoryImportSpec repositoryImportSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (repositoryImportSpecAttributeRestrictions!=null){ this.attributeRestrictions= new RepositoryImportSpecBuilder(repositoryImportSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RepositoryImportSpecAttributeRestrictionsNested<A> withNewRepositoryImportSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RepositoryImportSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RepositoryImportSpecAttributeRestrictionsNested<A> withNewRepositoryImportSpecAttributeRestrictionsLike(RepositoryImportSpec item) {
    return new PolicyRuleFluentImpl.RepositoryImportSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withBrokerTemplateInstanceListAttributeRestrictions(BrokerTemplateInstanceList brokerTemplateInstanceListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (brokerTemplateInstanceListAttributeRestrictions!=null){ this.attributeRestrictions= new BrokerTemplateInstanceListBuilder(brokerTemplateInstanceListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BrokerTemplateInstanceListAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BrokerTemplateInstanceListAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceListAttributeRestrictionsLike(BrokerTemplateInstanceList item) {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceListAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImportStatusAttributeRestrictions(ImageStreamImportStatus imageStreamImportStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImportStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportStatusBuilder(imageStreamImportStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamImportStatusAttributeRestrictionsNested<A> withNewImageStreamImportStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImportStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamImportStatusAttributeRestrictionsNested<A> withNewImageStreamImportStatusAttributeRestrictionsLike(ImageStreamImportStatus item) {
    return new PolicyRuleFluentImpl.ImageStreamImportStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withCustomBuildStrategyAttributeRestrictions(CustomBuildStrategy customBuildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (customBuildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new CustomBuildStrategyBuilder(customBuildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.CustomBuildStrategyAttributeRestrictionsNested<A> withNewCustomBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.CustomBuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.CustomBuildStrategyAttributeRestrictionsNested<A> withNewCustomBuildStrategyAttributeRestrictionsLike(CustomBuildStrategy item) {
    return new PolicyRuleFluentImpl.CustomBuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaSelectorAttributeRestrictions(ClusterResourceQuotaSelector clusterResourceQuotaSelectorAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaSelectorAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaSelectorBuilder(clusterResourceQuotaSelectorAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaSelectorAttributeRestrictionsNested<A> withNewClusterResourceQuotaSelectorAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaSelectorAttributeRestrictionsNested<A> withNewClusterResourceQuotaSelectorAttributeRestrictionsLike(ClusterResourceQuotaSelector item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl(item);
  }
  public A withSubjectAccessReviewResponseAttributeRestrictions(SubjectAccessReviewResponse subjectAccessReviewResponseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectAccessReviewResponseAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectAccessReviewResponseBuilder(subjectAccessReviewResponseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SubjectAccessReviewResponseAttributeRestrictionsNested<A> withNewSubjectAccessReviewResponseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectAccessReviewResponseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SubjectAccessReviewResponseAttributeRestrictionsNested<A> withNewSubjectAccessReviewResponseAttributeRestrictionsLike(SubjectAccessReviewResponse item) {
    return new PolicyRuleFluentImpl.SubjectAccessReviewResponseAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentTriggerImageChangeParamsAttributeRestrictions(DeploymentTriggerImageChangeParams deploymentTriggerImageChangeParamsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentTriggerImageChangeParamsAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentTriggerImageChangeParamsBuilder(deploymentTriggerImageChangeParamsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<A> withNewDeploymentTriggerImageChangeParamsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<A> withNewDeploymentTriggerImageChangeParamsAttributeRestrictionsLike(DeploymentTriggerImageChangeParams item) {
    return new PolicyRuleFluentImpl.DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl(item);
  }
  public A withLocalObjectReferenceAttributeRestrictions(LocalObjectReference localObjectReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (localObjectReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new LocalObjectReferenceBuilder(localObjectReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.LocalObjectReferenceAttributeRestrictionsNested<A> withNewLocalObjectReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LocalObjectReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.LocalObjectReferenceAttributeRestrictionsNested<A> withNewLocalObjectReferenceAttributeRestrictionsLike(LocalObjectReference item) {
    return new PolicyRuleFluentImpl.LocalObjectReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewLocalObjectReferenceAttributeRestrictions(String name) {
    return (A)withLocalObjectReferenceAttributeRestrictions(new LocalObjectReference(name));
  }
  public A withTagImageHookAttributeRestrictions(TagImageHook tagImageHookAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagImageHookAttributeRestrictions!=null){ this.attributeRestrictions= new TagImageHookBuilder(tagImageHookAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TagImageHookAttributeRestrictionsNested<A> withNewTagImageHookAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagImageHookAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TagImageHookAttributeRestrictionsNested<A> withNewTagImageHookAttributeRestrictionsLike(TagImageHook item) {
    return new PolicyRuleFluentImpl.TagImageHookAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteTargetReferenceAttributeRestrictions(RouteTargetReference routeTargetReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeTargetReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new RouteTargetReferenceBuilder(routeTargetReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RouteTargetReferenceAttributeRestrictionsNested<A> withNewRouteTargetReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteTargetReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RouteTargetReferenceAttributeRestrictionsNested<A> withNewRouteTargetReferenceAttributeRestrictionsLike(RouteTargetReference item) {
    return new PolicyRuleFluentImpl.RouteTargetReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewRouteTargetReferenceAttributeRestrictions(String kind,String name,Integer weight) {
    return (A)withRouteTargetReferenceAttributeRestrictions(new RouteTargetReference(kind, name, weight));
  }
  public A withRawExtensionAttributeRestrictions(io.fabric8.openshift.api.model.runtime.RawExtension rawExtensionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rawExtensionAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(rawExtensionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OpenshiftRawExtensionAttributeRestrictionsNested<A> withNewOpenshiftRawExtensionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OpenshiftRawExtensionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OpenshiftRawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictionsLike(io.fabric8.openshift.api.model.runtime.RawExtension item) {
    return new PolicyRuleFluentImpl.OpenshiftRawExtensionAttributeRestrictionsNestedImpl(item);
  }
  public A withNewOpenshiftRawExtensionAttributeRestrictions(Object value) {
    return (A)withRawExtensionAttributeRestrictions(new RawExtension(value));
  }
  public A withSubjectRulesReviewSpecAttributeRestrictions(SubjectRulesReviewSpec subjectRulesReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectRulesReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectRulesReviewSpecBuilder(subjectRulesReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSubjectRulesReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectRulesReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSubjectRulesReviewSpecAttributeRestrictionsLike(SubjectRulesReviewSpec item) {
    return new PolicyRuleFluentImpl.SubjectRulesReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withTagReferencePolicyAttributeRestrictions(TagReferencePolicy tagReferencePolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagReferencePolicyAttributeRestrictions!=null){ this.attributeRestrictions= new TagReferencePolicyBuilder(tagReferencePolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TagReferencePolicyAttributeRestrictionsNested<A> withNewTagReferencePolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagReferencePolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TagReferencePolicyAttributeRestrictionsNested<A> withNewTagReferencePolicyAttributeRestrictionsLike(TagReferencePolicy item) {
    return new PolicyRuleFluentImpl.TagReferencePolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNewTagReferencePolicyAttributeRestrictions(String type) {
    return (A)withTagReferencePolicyAttributeRestrictions(new TagReferencePolicy(type));
  }
  public A withRoleListAttributeRestrictions(RoleList roleListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleListAttributeRestrictions!=null){ this.attributeRestrictions= new RoleListBuilder(roleListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RoleListAttributeRestrictionsNested<A> withNewRoleListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RoleListAttributeRestrictionsNested<A> withNewRoleListAttributeRestrictionsLike(RoleList item) {
    return new PolicyRuleFluentImpl.RoleListAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectAttributeRestrictions(Project projectAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectBuilder(projectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(Project item) {
    return new PolicyRuleFluentImpl.ProjectAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildVolumeSourceAttributeRestrictions(BuildVolumeSource buildVolumeSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildVolumeSourceAttributeRestrictions!=null){ this.attributeRestrictions= new BuildVolumeSourceBuilder(buildVolumeSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildVolumeSourceAttributeRestrictionsNested<A> withNewBuildVolumeSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildVolumeSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildVolumeSourceAttributeRestrictionsNested<A> withNewBuildVolumeSourceAttributeRestrictionsLike(BuildVolumeSource item) {
    return new PolicyRuleFluentImpl.BuildVolumeSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaListAttributeRestrictions(AppliedClusterResourceQuotaList appliedClusterResourceQuotaListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (appliedClusterResourceQuotaListAttributeRestrictions!=null){ this.attributeRestrictions= new AppliedClusterResourceQuotaListBuilder(appliedClusterResourceQuotaListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.AppliedClusterResourceQuotaListAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.AppliedClusterResourceQuotaListAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaListAttributeRestrictionsLike(AppliedClusterResourceQuotaList item) {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigListAttributeRestrictions(DeploymentConfigList deploymentConfigListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigListAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigListBuilder(deploymentConfigListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentConfigListAttributeRestrictionsNested<A> withNewDeploymentConfigListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentConfigListAttributeRestrictionsNested<A> withNewDeploymentConfigListAttributeRestrictionsLike(DeploymentConfigList item) {
    return new PolicyRuleFluentImpl.DeploymentConfigListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildStatusOutputAttributeRestrictions(BuildStatusOutput buildStatusOutputAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildStatusOutputAttributeRestrictions!=null){ this.attributeRestrictions= new BuildStatusOutputBuilder(buildStatusOutputAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildStatusOutputAttributeRestrictionsNested<A> withNewBuildStatusOutputAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildStatusOutputAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildStatusOutputAttributeRestrictionsNested<A> withNewBuildStatusOutputAttributeRestrictionsLike(BuildStatusOutput item) {
    return new PolicyRuleFluentImpl.BuildStatusOutputAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildConfigAttributeRestrictions(BuildConfig buildConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigBuilder(buildConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(BuildConfig item) {
    return new PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withImageImportStatusAttributeRestrictions(ImageImportStatus imageImportStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageImportStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ImageImportStatusBuilder(imageImportStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageImportStatusAttributeRestrictionsNested<A> withNewImageImportStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageImportStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageImportStatusAttributeRestrictionsNested<A> withNewImageImportStatusAttributeRestrictionsLike(ImageImportStatus item) {
    return new PolicyRuleFluentImpl.ImageImportStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewAttributeRestrictions(PodSecurityPolicySubjectReview podSecurityPolicySubjectReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySubjectReviewAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewBuilder(podSecurityPolicySubjectReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewAttributeRestrictionsLike(PodSecurityPolicySubjectReview item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withGitLabWebHookCauseAttributeRestrictions(GitLabWebHookCause gitLabWebHookCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (gitLabWebHookCauseAttributeRestrictions!=null){ this.attributeRestrictions= new GitLabWebHookCauseBuilder(gitLabWebHookCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GitLabWebHookCauseAttributeRestrictionsNested<A> withNewGitLabWebHookCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GitLabWebHookCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GitLabWebHookCauseAttributeRestrictionsNested<A> withNewGitLabWebHookCauseAttributeRestrictionsLike(GitLabWebHookCause item) {
    return new PolicyRuleFluentImpl.GitLabWebHookCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigStatusAttributeRestrictions(DeploymentConfigStatus deploymentConfigStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigStatusAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigStatusBuilder(deploymentConfigStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentConfigStatusAttributeRestrictionsNested<A> withNewDeploymentConfigStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentConfigStatusAttributeRestrictionsNested<A> withNewDeploymentConfigStatusAttributeRestrictionsLike(DeploymentConfigStatus item) {
    return new PolicyRuleFluentImpl.DeploymentConfigStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withSecretBuildSourceAttributeRestrictions(SecretBuildSource secretBuildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (secretBuildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new SecretBuildSourceBuilder(secretBuildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SecretBuildSourceAttributeRestrictionsNested<A> withNewSecretBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecretBuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SecretBuildSourceAttributeRestrictionsNested<A> withNewSecretBuildSourceAttributeRestrictionsLike(SecretBuildSource item) {
    return new PolicyRuleFluentImpl.SecretBuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicySpecAttributeRestrictions(EgressNetworkPolicySpec egressNetworkPolicySpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicySpecAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicySpecBuilder(egressNetworkPolicySpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicySpecAttributeRestrictionsNested<A> withNewEgressNetworkPolicySpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicySpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicySpecAttributeRestrictionsNested<A> withNewEgressNetworkPolicySpecAttributeRestrictionsLike(EgressNetworkPolicySpec item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicySpecAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositoryAttributeRestrictions(HelmChartRepository helmChartRepositoryAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositoryAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositoryBuilder(helmChartRepositoryAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictionsLike(HelmChartRepository item) {
    return new PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNestedImpl(item);
  }
  public A withTagEventAttributeRestrictions(TagEvent tagEventAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagEventAttributeRestrictions!=null){ this.attributeRestrictions= new TagEventBuilder(tagEventAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TagEventAttributeRestrictionsNested<A> withNewTagEventAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagEventAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TagEventAttributeRestrictionsNested<A> withNewTagEventAttributeRestrictionsLike(TagEvent item) {
    return new PolicyRuleFluentImpl.TagEventAttributeRestrictionsNestedImpl(item);
  }
  public A withNewTagEventAttributeRestrictions(String created,String dockerImageReference,Long generation,String image) {
    return (A)withTagEventAttributeRestrictions(new TagEvent(created, dockerImageReference, generation, image));
  }
  public A withImageStreamTagListAttributeRestrictions(ImageStreamTagList imageStreamTagListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamTagListAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamTagListBuilder(imageStreamTagListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamTagListAttributeRestrictionsNested<A> withNewImageStreamTagListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamTagListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamTagListAttributeRestrictionsNested<A> withNewImageStreamTagListAttributeRestrictionsLike(ImageStreamTagList item) {
    return new PolicyRuleFluentImpl.ImageStreamTagListAttributeRestrictionsNestedImpl(item);
  }
  public A withBitbucketWebHookCauseAttributeRestrictions(BitbucketWebHookCause bitbucketWebHookCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (bitbucketWebHookCauseAttributeRestrictions!=null){ this.attributeRestrictions= new BitbucketWebHookCauseBuilder(bitbucketWebHookCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BitbucketWebHookCauseAttributeRestrictionsNested<A> withNewBitbucketWebHookCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BitbucketWebHookCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BitbucketWebHookCauseAttributeRestrictionsNested<A> withNewBitbucketWebHookCauseAttributeRestrictionsLike(BitbucketWebHookCause item) {
    return new PolicyRuleFluentImpl.BitbucketWebHookCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectListAttributeRestrictions(ProjectList projectListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectListAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectListBuilder(projectListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ProjectListAttributeRestrictionsNested<A> withNewProjectListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ProjectListAttributeRestrictionsNested<A> withNewProjectListAttributeRestrictionsLike(ProjectList item) {
    return new PolicyRuleFluentImpl.ProjectListAttributeRestrictionsNestedImpl(item);
  }
  public A withRangeAllocationAttributeRestrictions(RangeAllocation rangeAllocationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rangeAllocationAttributeRestrictions!=null){ this.attributeRestrictions= new RangeAllocationBuilder(rangeAllocationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictionsLike(RangeAllocation item) {
    return new PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleScopeRestrictionAttributeRestrictions(ClusterRoleScopeRestriction clusterRoleScopeRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleScopeRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleScopeRestrictionBuilder(clusterRoleScopeRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterRoleScopeRestrictionAttributeRestrictionsNested<A> withNewClusterRoleScopeRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterRoleScopeRestrictionAttributeRestrictionsNested<A> withNewClusterRoleScopeRestrictionAttributeRestrictionsLike(ClusterRoleScopeRestriction item) {
    return new PolicyRuleFluentImpl.ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteAttributeRestrictions(Route routeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeAttributeRestrictions!=null){ this.attributeRestrictions= new RouteBuilder(routeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(Route item) {
    return new PolicyRuleFluentImpl.RouteAttributeRestrictionsNestedImpl(item);
  }
  public A withSourceStrategyOptionsAttributeRestrictions(SourceStrategyOptions sourceStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sourceStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new SourceStrategyOptionsBuilder(sourceStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SourceStrategyOptionsAttributeRestrictionsNested<A> withNewSourceStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SourceStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SourceStrategyOptionsAttributeRestrictionsNested<A> withNewSourceStrategyOptionsAttributeRestrictionsLike(SourceStrategyOptions item) {
    return new PolicyRuleFluentImpl.SourceStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSourceStrategyOptionsAttributeRestrictions(Boolean incremental) {
    return (A)withSourceStrategyOptionsAttributeRestrictions(new SourceStrategyOptions(incremental));
  }
  public A withClusterNetworkAttributeRestrictions(ClusterNetwork clusterNetworkAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterNetworkAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterNetworkBuilder(clusterNetworkAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictionsLike(ClusterNetwork item) {
    return new PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenAttributeRestrictions(OAuthAuthorizeToken oAuthAuthorizeTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAuthorizeTokenAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(OAuthAuthorizeToken item) {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withDockerBuildStrategyAttributeRestrictions(DockerBuildStrategy dockerBuildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (dockerBuildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new DockerBuildStrategyBuilder(dockerBuildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DockerBuildStrategyAttributeRestrictionsNested<A> withNewDockerBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DockerBuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DockerBuildStrategyAttributeRestrictionsNested<A> withNewDockerBuildStrategyAttributeRestrictionsLike(DockerBuildStrategy item) {
    return new PolicyRuleFluentImpl.DockerBuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withSignatureConditionAttributeRestrictions(SignatureCondition signatureConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (signatureConditionAttributeRestrictions!=null){ this.attributeRestrictions= new SignatureConditionBuilder(signatureConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SignatureConditionAttributeRestrictionsNested<A> withNewSignatureConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SignatureConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SignatureConditionAttributeRestrictionsNested<A> withNewSignatureConditionAttributeRestrictionsLike(SignatureCondition item) {
    return new PolicyRuleFluentImpl.SignatureConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withUserOAuthAccessTokenAttributeRestrictions(UserOAuthAccessToken userOAuthAccessTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userOAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new UserOAuthAccessTokenBuilder(userOAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictionsLike(UserOAuthAccessToken item) {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingRestrictionListAttributeRestrictions(RoleBindingRestrictionList roleBindingRestrictionListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingRestrictionListAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingRestrictionListBuilder(roleBindingRestrictionListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RoleBindingRestrictionListAttributeRestrictionsNested<A> withNewRoleBindingRestrictionListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RoleBindingRestrictionListAttributeRestrictionsNested<A> withNewRoleBindingRestrictionListAttributeRestrictionsLike(RoleBindingRestrictionList item) {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionListAttributeRestrictionsNestedImpl(item);
  }
  public A withRawExtensionAttributeRestrictions(RawExtension rawExtensionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rawExtensionAttributeRestrictions!=null){ this.attributeRestrictions= new RawExtensionBuilder(rawExtensionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RawExtensionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictionsLike(RawExtension item) {
    return new PolicyRuleFluentImpl.RawExtensionAttributeRestrictionsNestedImpl(item);
  }
  public A withNewRawExtensionAttributeRestrictions(Object value) {
    return (A)withRawExtensionAttributeRestrictions(new RawExtension(value));
  }
  public A withSecurityContextConstraintsListAttributeRestrictions(SecurityContextConstraintsList securityContextConstraintsListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (securityContextConstraintsListAttributeRestrictions!=null){ this.attributeRestrictions= new SecurityContextConstraintsListBuilder(securityContextConstraintsListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SecurityContextConstraintsListAttributeRestrictionsNested<A> withNewSecurityContextConstraintsListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SecurityContextConstraintsListAttributeRestrictionsNested<A> withNewSecurityContextConstraintsListAttributeRestrictionsLike(SecurityContextConstraintsList item) {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsListAttributeRestrictionsNestedImpl(item);
  }
  public A withIdentityListAttributeRestrictions(IdentityList identityListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (identityListAttributeRestrictions!=null){ this.attributeRestrictions= new IdentityListBuilder(identityListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.IdentityListAttributeRestrictionsNested<A> withNewIdentityListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IdentityListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.IdentityListAttributeRestrictionsNested<A> withNewIdentityListAttributeRestrictionsLike(IdentityList item) {
    return new PolicyRuleFluentImpl.IdentityListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildConfigListAttributeRestrictions(BuildConfigList buildConfigListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigListAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigListBuilder(buildConfigListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildConfigListAttributeRestrictionsNested<A> withNewBuildConfigListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildConfigListAttributeRestrictionsNested<A> withNewBuildConfigListAttributeRestrictionsLike(BuildConfigList item) {
    return new PolicyRuleFluentImpl.BuildConfigListAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterNetworkListAttributeRestrictions(ClusterNetworkList clusterNetworkListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterNetworkListAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterNetworkListBuilder(clusterNetworkListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterNetworkListAttributeRestrictionsNested<A> withNewClusterNetworkListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterNetworkListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterNetworkListAttributeRestrictionsNested<A> withNewClusterNetworkListAttributeRestrictionsLike(ClusterNetworkList item) {
    return new PolicyRuleFluentImpl.ClusterNetworkListAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceConditionAttributeRestrictions(TemplateInstanceCondition templateInstanceConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceConditionAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceConditionBuilder(templateInstanceConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateInstanceConditionAttributeRestrictionsNested<A> withNewTemplateInstanceConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateInstanceConditionAttributeRestrictionsNested<A> withNewTemplateInstanceConditionAttributeRestrictionsLike(TemplateInstanceCondition item) {
    return new PolicyRuleFluentImpl.TemplateInstanceConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withNewTemplateInstanceConditionAttributeRestrictions(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withTemplateInstanceConditionAttributeRestrictions(new TemplateInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withRepositoryImportStatusAttributeRestrictions(RepositoryImportStatus repositoryImportStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (repositoryImportStatusAttributeRestrictions!=null){ this.attributeRestrictions= new RepositoryImportStatusBuilder(repositoryImportStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RepositoryImportStatusAttributeRestrictionsNested<A> withNewRepositoryImportStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RepositoryImportStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RepositoryImportStatusAttributeRestrictionsNested<A> withNewRepositoryImportStatusAttributeRestrictionsLike(RepositoryImportStatus item) {
    return new PolicyRuleFluentImpl.RepositoryImportStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentCauseAttributeRestrictions(DeploymentCause deploymentCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentCauseAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentCauseBuilder(deploymentCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentCauseAttributeRestrictionsNested<A> withNewDeploymentCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentCauseAttributeRestrictionsNested<A> withNewDeploymentCauseAttributeRestrictionsLike(DeploymentCause item) {
    return new PolicyRuleFluentImpl.DeploymentCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withGroupListAttributeRestrictions(GroupList groupListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (groupListAttributeRestrictions!=null){ this.attributeRestrictions= new GroupListBuilder(groupListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GroupListAttributeRestrictionsNested<A> withNewGroupListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GroupListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GroupListAttributeRestrictionsNested<A> withNewGroupListAttributeRestrictionsLike(GroupList item) {
    return new PolicyRuleFluentImpl.GroupListAttributeRestrictionsNestedImpl(item);
  }
  public A withRunAsUserStrategyOptionsAttributeRestrictions(RunAsUserStrategyOptions runAsUserStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (runAsUserStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new RunAsUserStrategyOptionsBuilder(runAsUserStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RunAsUserStrategyOptionsAttributeRestrictionsNested<A> withNewRunAsUserStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RunAsUserStrategyOptionsAttributeRestrictionsNested<A> withNewRunAsUserStrategyOptionsAttributeRestrictionsLike(RunAsUserStrategyOptions item) {
    return new PolicyRuleFluentImpl.RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withNewRunAsUserStrategyOptionsAttributeRestrictions(String type,Long uid,Long uidRangeMax,Long uidRangeMin) {
    return (A)withRunAsUserStrategyOptionsAttributeRestrictions(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
  }
  public A withLifecycleHookAttributeRestrictions(LifecycleHook lifecycleHookAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (lifecycleHookAttributeRestrictions!=null){ this.attributeRestrictions= new LifecycleHookBuilder(lifecycleHookAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.LifecycleHookAttributeRestrictionsNested<A> withNewLifecycleHookAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LifecycleHookAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.LifecycleHookAttributeRestrictionsNested<A> withNewLifecycleHookAttributeRestrictionsLike(LifecycleHook item) {
    return new PolicyRuleFluentImpl.LifecycleHookAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamTagReferenceAttributeRestrictions(ImageStreamTagReference imageStreamTagReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamTagReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamTagReferenceBuilder(imageStreamTagReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamTagReferenceAttributeRestrictionsNested<A> withNewImageStreamTagReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamTagReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamTagReferenceAttributeRestrictionsNested<A> withNewImageStreamTagReferenceAttributeRestrictionsLike(ImageStreamTagReference item) {
    return new PolicyRuleFluentImpl.ImageStreamTagReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageStreamTagReferenceAttributeRestrictions(String name,String namespace) {
    return (A)withImageStreamTagReferenceAttributeRestrictions(new ImageStreamTagReference(name, namespace));
  }
  public A withSourceControlUserAttributeRestrictions(SourceControlUser sourceControlUserAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sourceControlUserAttributeRestrictions!=null){ this.attributeRestrictions= new SourceControlUserBuilder(sourceControlUserAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SourceControlUserAttributeRestrictionsNested<A> withNewSourceControlUserAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SourceControlUserAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SourceControlUserAttributeRestrictionsNested<A> withNewSourceControlUserAttributeRestrictionsLike(SourceControlUser item) {
    return new PolicyRuleFluentImpl.SourceControlUserAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSourceControlUserAttributeRestrictions(String email,String name) {
    return (A)withSourceControlUserAttributeRestrictions(new SourceControlUser(email, name));
  }
  public A withContainerAttributeRestrictions(Container containerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (containerAttributeRestrictions!=null){ this.attributeRestrictions= new ContainerBuilder(containerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ContainerAttributeRestrictionsNested<A> withNewContainerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ContainerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ContainerAttributeRestrictionsNested<A> withNewContainerAttributeRestrictionsLike(Container item) {
    return new PolicyRuleFluentImpl.ContainerAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamListAttributeRestrictions(ImageStreamList imageStreamListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamListAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamListBuilder(imageStreamListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamListAttributeRestrictionsNested<A> withNewImageStreamListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamListAttributeRestrictionsNested<A> withNewImageStreamListAttributeRestrictionsLike(ImageStreamList item) {
    return new PolicyRuleFluentImpl.ImageStreamListAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleBindingAttributeRestrictions(ClusterRoleBinding clusterRoleBindingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBindingBuilder(clusterRoleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(ClusterRoleBinding item) {
    return new PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNestedImpl(item);
  }
  public A withResourceAccessReviewAttributeRestrictions(ResourceAccessReview resourceAccessReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (resourceAccessReviewAttributeRestrictions!=null){ this.attributeRestrictions= new ResourceAccessReviewBuilder(resourceAccessReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ResourceAccessReviewAttributeRestrictionsNested<A> withNewResourceAccessReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ResourceAccessReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ResourceAccessReviewAttributeRestrictionsNested<A> withNewResourceAccessReviewAttributeRestrictionsLike(ResourceAccessReview item) {
    return new PolicyRuleFluentImpl.ResourceAccessReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withSelfSubjectRulesReviewAttributeRestrictions(SelfSubjectRulesReview selfSubjectRulesReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (selfSubjectRulesReviewAttributeRestrictions!=null){ this.attributeRestrictions= new SelfSubjectRulesReviewBuilder(selfSubjectRulesReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SelfSubjectRulesReviewAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SelfSubjectRulesReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SelfSubjectRulesReviewAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewAttributeRestrictionsLike(SelfSubjectRulesReview item) {
    return new PolicyRuleFluentImpl.SelfSubjectRulesReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withUserOAuthAccessTokenListAttributeRestrictions(UserOAuthAccessTokenList userOAuthAccessTokenListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userOAuthAccessTokenListAttributeRestrictions!=null){ this.attributeRestrictions= new UserOAuthAccessTokenListBuilder(userOAuthAccessTokenListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.UserOAuthAccessTokenListAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.UserOAuthAccessTokenListAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenListAttributeRestrictionsLike(UserOAuthAccessTokenList item) {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenListAttributeRestrictionsNestedImpl(item);
  }
  public A withImageChangeTriggerStatusAttributeRestrictions(ImageChangeTriggerStatus imageChangeTriggerStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageChangeTriggerStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ImageChangeTriggerStatusBuilder(imageChangeTriggerStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageChangeTriggerStatusAttributeRestrictionsNested<A> withNewImageChangeTriggerStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageChangeTriggerStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageChangeTriggerStatusAttributeRestrictionsNested<A> withNewImageChangeTriggerStatusAttributeRestrictionsLike(ImageChangeTriggerStatus item) {
    return new PolicyRuleFluentImpl.ImageChangeTriggerStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteStatusAttributeRestrictions(RouteStatus routeStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeStatusAttributeRestrictions!=null){ this.attributeRestrictions= new RouteStatusBuilder(routeStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RouteStatusAttributeRestrictionsNested<A> withNewRouteStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RouteStatusAttributeRestrictionsNested<A> withNewRouteStatusAttributeRestrictionsLike(RouteStatus item) {
    return new PolicyRuleFluentImpl.RouteStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaAttributeRestrictions(ClusterResourceQuota clusterResourceQuotaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaBuilder(clusterResourceQuotaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictionsLike(ClusterResourceQuota item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNestedImpl(item);
  }
  public A withNamedTagEventListAttributeRestrictions(NamedTagEventList namedTagEventListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (namedTagEventListAttributeRestrictions!=null){ this.attributeRestrictions= new NamedTagEventListBuilder(namedTagEventListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.NamedTagEventListAttributeRestrictionsNested<A> withNewNamedTagEventListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NamedTagEventListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.NamedTagEventListAttributeRestrictionsNested<A> withNewNamedTagEventListAttributeRestrictionsLike(NamedTagEventList item) {
    return new PolicyRuleFluentImpl.NamedTagEventListAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaListAttributeRestrictions(ClusterResourceQuotaList clusterResourceQuotaListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaListAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaListBuilder(clusterResourceQuotaListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaListAttributeRestrictionsNested<A> withNewClusterResourceQuotaListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaListAttributeRestrictionsNested<A> withNewClusterResourceQuotaListAttributeRestrictionsLike(ClusterResourceQuotaList item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaListAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteSpecAttributeRestrictions(RouteSpec routeSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeSpecAttributeRestrictions!=null){ this.attributeRestrictions= new RouteSpecBuilder(routeSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RouteSpecAttributeRestrictionsNested<A> withNewRouteSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RouteSpecAttributeRestrictionsNested<A> withNewRouteSpecAttributeRestrictionsLike(RouteSpec item) {
    return new PolicyRuleFluentImpl.RouteSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectRequestAttributeRestrictions(ProjectRequest projectRequestAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectRequestAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectRequestBuilder(projectRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(ProjectRequest item) {
    return new PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateAttributeRestrictions(Template templateAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateBuilder(templateAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(Template item) {
    return new PolicyRuleFluentImpl.TemplateAttributeRestrictionsNestedImpl(item);
  }
  public A withImageLookupPolicyAttributeRestrictions(ImageLookupPolicy imageLookupPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageLookupPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new ImageLookupPolicyBuilder(imageLookupPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageLookupPolicyAttributeRestrictionsNested<A> withNewImageLookupPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageLookupPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageLookupPolicyAttributeRestrictionsNested<A> withNewImageLookupPolicyAttributeRestrictionsLike(ImageLookupPolicy item) {
    return new PolicyRuleFluentImpl.ImageLookupPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageLookupPolicyAttributeRestrictions(Boolean local) {
    return (A)withImageLookupPolicyAttributeRestrictions(new ImageLookupPolicy(local));
  }
  public A withOAuthClientAuthorizationAttributeRestrictions(OAuthClientAuthorization oAuthClientAuthorizationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAuthorizationAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(OAuthClientAuthorization item) {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNestedImpl(item);
  }
  public A withImageChangeCauseAttributeRestrictions(ImageChangeCause imageChangeCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageChangeCauseAttributeRestrictions!=null){ this.attributeRestrictions= new ImageChangeCauseBuilder(imageChangeCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageChangeCauseAttributeRestrictionsNested<A> withNewImageChangeCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageChangeCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageChangeCauseAttributeRestrictionsNested<A> withNewImageChangeCauseAttributeRestrictionsLike(ImageChangeCause item) {
    return new PolicyRuleFluentImpl.ImageChangeCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withAllowedFlexVolumeAttributeRestrictions(AllowedFlexVolume allowedFlexVolumeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (allowedFlexVolumeAttributeRestrictions!=null){ this.attributeRestrictions= new AllowedFlexVolumeBuilder(allowedFlexVolumeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.AllowedFlexVolumeAttributeRestrictionsNested<A> withNewAllowedFlexVolumeAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AllowedFlexVolumeAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.AllowedFlexVolumeAttributeRestrictionsNested<A> withNewAllowedFlexVolumeAttributeRestrictionsLike(AllowedFlexVolume item) {
    return new PolicyRuleFluentImpl.AllowedFlexVolumeAttributeRestrictionsNestedImpl(item);
  }
  public A withNewAllowedFlexVolumeAttributeRestrictions(String driver) {
    return (A)withAllowedFlexVolumeAttributeRestrictions(new AllowedFlexVolume(driver));
  }
  public A withSubjectAccessReviewAttributeRestrictions(SubjectAccessReview subjectAccessReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectAccessReviewAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectAccessReviewBuilder(subjectAccessReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SubjectAccessReviewAttributeRestrictionsNested<A> withNewSubjectAccessReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectAccessReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SubjectAccessReviewAttributeRestrictionsNested<A> withNewSubjectAccessReviewAttributeRestrictionsLike(SubjectAccessReview item) {
    return new PolicyRuleFluentImpl.SubjectAccessReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withLocalResourceAccessReviewAttributeRestrictions(LocalResourceAccessReview localResourceAccessReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (localResourceAccessReviewAttributeRestrictions!=null){ this.attributeRestrictions= new LocalResourceAccessReviewBuilder(localResourceAccessReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.LocalResourceAccessReviewAttributeRestrictionsNested<A> withNewLocalResourceAccessReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LocalResourceAccessReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.LocalResourceAccessReviewAttributeRestrictionsNested<A> withNewLocalResourceAccessReviewAttributeRestrictionsLike(LocalResourceAccessReview item) {
    return new PolicyRuleFluentImpl.LocalResourceAccessReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleAttributeRestrictions(ClusterRole clusterRoleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBuilder(clusterRoleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(ClusterRole item) {
    return new PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNestedImpl(item);
  }
  public A withConnectionConfigAttributeRestrictions(ConnectionConfig connectionConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (connectionConfigAttributeRestrictions!=null){ this.attributeRestrictions= new ConnectionConfigBuilder(connectionConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ConnectionConfigAttributeRestrictionsNested<A> withNewConnectionConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ConnectionConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ConnectionConfigAttributeRestrictionsNested<A> withNewConnectionConfigAttributeRestrictionsLike(ConnectionConfig item) {
    return new PolicyRuleFluentImpl.ConnectionConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withTagEventConditionAttributeRestrictions(TagEventCondition tagEventConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagEventConditionAttributeRestrictions!=null){ this.attributeRestrictions= new TagEventConditionBuilder(tagEventConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TagEventConditionAttributeRestrictionsNested<A> withNewTagEventConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagEventConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TagEventConditionAttributeRestrictionsNested<A> withNewTagEventConditionAttributeRestrictionsLike(TagEventCondition item) {
    return new PolicyRuleFluentImpl.TagEventConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withLabelSelectorAttributeRestrictions(LabelSelector labelSelectorAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (labelSelectorAttributeRestrictions!=null){ this.attributeRestrictions= new LabelSelectorBuilder(labelSelectorAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.LabelSelectorAttributeRestrictionsNested<A> withNewLabelSelectorAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LabelSelectorAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.LabelSelectorAttributeRestrictionsNested<A> withNewLabelSelectorAttributeRestrictionsLike(LabelSelector item) {
    return new PolicyRuleFluentImpl.LabelSelectorAttributeRestrictionsNestedImpl(item);
  }
  public A withNetNamespaceListAttributeRestrictions(NetNamespaceList netNamespaceListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (netNamespaceListAttributeRestrictions!=null){ this.attributeRestrictions= new NetNamespaceListBuilder(netNamespaceListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.NetNamespaceListAttributeRestrictionsNested<A> withNewNetNamespaceListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NetNamespaceListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.NetNamespaceListAttributeRestrictionsNested<A> withNewNetNamespaceListAttributeRestrictionsLike(NetNamespaceList item) {
    return new PolicyRuleFluentImpl.NetNamespaceListAttributeRestrictionsNestedImpl(item);
  }
  public A withBrokerTemplateInstanceSpecAttributeRestrictions(BrokerTemplateInstanceSpec brokerTemplateInstanceSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (brokerTemplateInstanceSpecAttributeRestrictions!=null){ this.attributeRestrictions= new BrokerTemplateInstanceSpecBuilder(brokerTemplateInstanceSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BrokerTemplateInstanceSpecAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BrokerTemplateInstanceSpecAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceSpecAttributeRestrictionsLike(BrokerTemplateInstanceSpec item) {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withBinaryBuildSourceAttributeRestrictions(BinaryBuildSource binaryBuildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (binaryBuildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new BinaryBuildSourceBuilder(binaryBuildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BinaryBuildSourceAttributeRestrictionsNested<A> withNewBinaryBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BinaryBuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BinaryBuildSourceAttributeRestrictionsNested<A> withNewBinaryBuildSourceAttributeRestrictionsLike(BinaryBuildSource item) {
    return new PolicyRuleFluentImpl.BinaryBuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewBinaryBuildSourceAttributeRestrictions(String asFile) {
    return (A)withBinaryBuildSourceAttributeRestrictions(new BinaryBuildSource(asFile));
  }
  public A withOAuthClientAuthorizationListAttributeRestrictions(OAuthClientAuthorizationList oAuthClientAuthorizationListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAuthorizationListAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientAuthorizationListBuilder(oAuthClientAuthorizationListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OAuthClientAuthorizationListAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OAuthClientAuthorizationListAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationListAttributeRestrictionsLike(OAuthClientAuthorizationList item) {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildSpecAttributeRestrictions(BuildSpec buildSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildSpecAttributeRestrictions!=null){ this.attributeRestrictions= new BuildSpecBuilder(buildSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildSpecAttributeRestrictionsNested<A> withNewBuildSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildSpecAttributeRestrictionsNested<A> withNewBuildSpecAttributeRestrictionsLike(BuildSpec item) {
    return new PolicyRuleFluentImpl.BuildSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectStatusAttributeRestrictions(ProjectStatus projectStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectStatusBuilder(projectStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ProjectStatusAttributeRestrictionsNested<A> withNewProjectStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ProjectStatusAttributeRestrictionsNested<A> withNewProjectStatusAttributeRestrictionsLike(ProjectStatus item) {
    return new PolicyRuleFluentImpl.ProjectStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withLocalSubjectAccessReviewAttributeRestrictions(LocalSubjectAccessReview localSubjectAccessReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (localSubjectAccessReviewAttributeRestrictions!=null){ this.attributeRestrictions= new LocalSubjectAccessReviewBuilder(localSubjectAccessReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.LocalSubjectAccessReviewAttributeRestrictionsNested<A> withNewLocalSubjectAccessReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LocalSubjectAccessReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.LocalSubjectAccessReviewAttributeRestrictionsNested<A> withNewLocalSubjectAccessReviewAttributeRestrictionsLike(LocalSubjectAccessReview item) {
    return new PolicyRuleFluentImpl.LocalSubjectAccessReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withRollingDeploymentStrategyParamsAttributeRestrictions(RollingDeploymentStrategyParams rollingDeploymentStrategyParamsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rollingDeploymentStrategyParamsAttributeRestrictions!=null){ this.attributeRestrictions= new RollingDeploymentStrategyParamsBuilder(rollingDeploymentStrategyParamsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RollingDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRollingDeploymentStrategyParamsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RollingDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRollingDeploymentStrategyParamsAttributeRestrictionsLike(RollingDeploymentStrategyParams item) {
    return new PolicyRuleFluentImpl.RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl(item);
  }
  public A withGitSourceRevisionAttributeRestrictions(GitSourceRevision gitSourceRevisionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (gitSourceRevisionAttributeRestrictions!=null){ this.attributeRestrictions= new GitSourceRevisionBuilder(gitSourceRevisionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GitSourceRevisionAttributeRestrictionsNested<A> withNewGitSourceRevisionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GitSourceRevisionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GitSourceRevisionAttributeRestrictionsNested<A> withNewGitSourceRevisionAttributeRestrictionsLike(GitSourceRevision item) {
    return new PolicyRuleFluentImpl.GitSourceRevisionAttributeRestrictionsNestedImpl(item);
  }
  public A withImageLabelAttributeRestrictions(ImageLabel imageLabelAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageLabelAttributeRestrictions!=null){ this.attributeRestrictions= new ImageLabelBuilder(imageLabelAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageLabelAttributeRestrictionsNested<A> withNewImageLabelAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageLabelAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageLabelAttributeRestrictionsNested<A> withNewImageLabelAttributeRestrictionsLike(ImageLabel item) {
    return new PolicyRuleFluentImpl.ImageLabelAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageLabelAttributeRestrictions(String name,String value) {
    return (A)withImageLabelAttributeRestrictions(new ImageLabel(name, value));
  }
  public A withImageChangeTriggerAttributeRestrictions(ImageChangeTrigger imageChangeTriggerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageChangeTriggerAttributeRestrictions!=null){ this.attributeRestrictions= new ImageChangeTriggerBuilder(imageChangeTriggerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageChangeTriggerAttributeRestrictionsNested<A> withNewImageChangeTriggerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageChangeTriggerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageChangeTriggerAttributeRestrictionsNested<A> withNewImageChangeTriggerAttributeRestrictionsLike(ImageChangeTrigger item) {
    return new PolicyRuleFluentImpl.ImageChangeTriggerAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewSpecAttributeRestrictions(PodSecurityPolicyReviewSpec podSecurityPolicyReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicyReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicyReviewSpecBuilder(podSecurityPolicyReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodSecurityPolicyReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodSecurityPolicyReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewSpecAttributeRestrictionsLike(PodSecurityPolicyReviewSpec item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withImageTagAttributeRestrictions(ImageTag imageTagAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageTagAttributeRestrictions!=null){ this.attributeRestrictions= new ImageTagBuilder(imageTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictionsLike(ImageTag item) {
    return new PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImportSpecAttributeRestrictions(ImageStreamImportSpec imageStreamImportSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImportSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportSpecBuilder(imageStreamImportSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamImportSpecAttributeRestrictionsNested<A> withNewImageStreamImportSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImportSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamImportSpecAttributeRestrictionsNested<A> withNewImageStreamImportSpecAttributeRestrictionsLike(ImageStreamImportSpec item) {
    return new PolicyRuleFluentImpl.ImageStreamImportSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withFSGroupStrategyOptionsAttributeRestrictions(FSGroupStrategyOptions fSGroupStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (fSGroupStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new FSGroupStrategyOptionsBuilder(fSGroupStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.FSGroupStrategyOptionsAttributeRestrictionsNested<A> withNewFSGroupStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.FSGroupStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.FSGroupStrategyOptionsAttributeRestrictionsNested<A> withNewFSGroupStrategyOptionsAttributeRestrictionsLike(FSGroupStrategyOptions item) {
    return new PolicyRuleFluentImpl.FSGroupStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewAttributeRestrictions(PodSecurityPolicyReview podSecurityPolicyReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicyReviewAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicyReviewBuilder(podSecurityPolicyReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodSecurityPolicyReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodSecurityPolicyReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewAttributeRestrictionsLike(PodSecurityPolicyReview item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withRecreateDeploymentStrategyParamsAttributeRestrictions(RecreateDeploymentStrategyParams recreateDeploymentStrategyParamsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (recreateDeploymentStrategyParamsAttributeRestrictions!=null){ this.attributeRestrictions= new RecreateDeploymentStrategyParamsBuilder(recreateDeploymentStrategyParamsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RecreateDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRecreateDeploymentStrategyParamsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RecreateDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRecreateDeploymentStrategyParamsAttributeRestrictionsLike(RecreateDeploymentStrategyParams item) {
    return new PolicyRuleFluentImpl.RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl(item);
  }
  public A withDockerStrategyOptionsAttributeRestrictions(DockerStrategyOptions dockerStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (dockerStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new DockerStrategyOptionsBuilder(dockerStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DockerStrategyOptionsAttributeRestrictionsNested<A> withNewDockerStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DockerStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DockerStrategyOptionsAttributeRestrictionsNested<A> withNewDockerStrategyOptionsAttributeRestrictionsLike(DockerStrategyOptions item) {
    return new PolicyRuleFluentImpl.DockerStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withImageListAttributeRestrictions(ImageList imageListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageListAttributeRestrictions!=null){ this.attributeRestrictions= new ImageListBuilder(imageListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageListAttributeRestrictionsNested<A> withNewImageListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageListAttributeRestrictionsNested<A> withNewImageListAttributeRestrictionsLike(ImageList item) {
    return new PolicyRuleFluentImpl.ImageListAttributeRestrictionsNestedImpl(item);
  }
  public A withConfigMapBuildSourceAttributeRestrictions(ConfigMapBuildSource configMapBuildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (configMapBuildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new ConfigMapBuildSourceBuilder(configMapBuildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ConfigMapBuildSourceAttributeRestrictionsNested<A> withNewConfigMapBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ConfigMapBuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ConfigMapBuildSourceAttributeRestrictionsNested<A> withNewConfigMapBuildSourceAttributeRestrictionsLike(ConfigMapBuildSource item) {
    return new PolicyRuleFluentImpl.ConfigMapBuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withImageTagListAttributeRestrictions(ImageTagList imageTagListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageTagListAttributeRestrictions!=null){ this.attributeRestrictions= new ImageTagListBuilder(imageTagListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageTagListAttributeRestrictionsNested<A> withNewImageTagListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageTagListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageTagListAttributeRestrictionsNested<A> withNewImageTagListAttributeRestrictionsLike(ImageTagList item) {
    return new PolicyRuleFluentImpl.ImageTagListAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAccessTokenAttributeRestrictions(OAuthAccessToken oAuthAccessTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAccessTokenBuilder(oAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(OAuthAccessToken item) {
    return new PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigAttributeRestrictions(DeploymentConfig deploymentConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigBuilder(deploymentConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(DeploymentConfig item) {
    return new PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingAttributeRestrictions(RoleBinding roleBindingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingBuilder(roleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(RoleBinding item) {
    return new PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNestedImpl(item);
  }
  public A withImageAttributeRestrictions(Image imageAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageAttributeRestrictions!=null){ this.attributeRestrictions= new ImageBuilder(imageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(Image item) {
    return new PolicyRuleFluentImpl.ImageAttributeRestrictionsNestedImpl(item);
  }
  public A withTLSConfigAttributeRestrictions(TLSConfig tLSConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tLSConfigAttributeRestrictions!=null){ this.attributeRestrictions= new TLSConfigBuilder(tLSConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TLSConfigAttributeRestrictionsNested<A> withNewTLSConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TLSConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TLSConfigAttributeRestrictionsNested<A> withNewTLSConfigAttributeRestrictionsLike(TLSConfig item) {
    return new PolicyRuleFluentImpl.TLSConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildVolumeAttributeRestrictions(BuildVolume buildVolumeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildVolumeAttributeRestrictions!=null){ this.attributeRestrictions= new BuildVolumeBuilder(buildVolumeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildVolumeAttributeRestrictionsNested<A> withNewBuildVolumeAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildVolumeAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildVolumeAttributeRestrictionsNested<A> withNewBuildVolumeAttributeRestrictionsLike(BuildVolume item) {
    return new PolicyRuleFluentImpl.BuildVolumeAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceSpecAttributeRestrictions(TemplateInstanceSpec templateInstanceSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceSpecAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceSpecBuilder(templateInstanceSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateInstanceSpecAttributeRestrictionsNested<A> withNewTemplateInstanceSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateInstanceSpecAttributeRestrictionsNested<A> withNewTemplateInstanceSpecAttributeRestrictionsLike(TemplateInstanceSpec item) {
    return new PolicyRuleFluentImpl.TemplateInstanceSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildStatusAttributeRestrictions(BuildStatus buildStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildStatusAttributeRestrictions!=null){ this.attributeRestrictions= new BuildStatusBuilder(buildStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildStatusAttributeRestrictionsNested<A> withNewBuildStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildStatusAttributeRestrictionsNested<A> withNewBuildStatusAttributeRestrictionsLike(BuildStatus item) {
    return new PolicyRuleFluentImpl.BuildStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withImageSourceAttributeRestrictions(ImageSource imageSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageSourceAttributeRestrictions!=null){ this.attributeRestrictions= new ImageSourceBuilder(imageSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageSourceAttributeRestrictionsNested<A> withNewImageSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageSourceAttributeRestrictionsNested<A> withNewImageSourceAttributeRestrictionsLike(ImageSource item) {
    return new PolicyRuleFluentImpl.ImageSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withObjectMetaAttributeRestrictions(ObjectMeta objectMetaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (objectMetaAttributeRestrictions!=null){ this.attributeRestrictions= new ObjectMetaBuilder(objectMetaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ObjectMetaAttributeRestrictionsNested<A> withNewObjectMetaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ObjectMetaAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ObjectMetaAttributeRestrictionsNested<A> withNewObjectMetaAttributeRestrictionsLike(ObjectMeta item) {
    return new PolicyRuleFluentImpl.ObjectMetaAttributeRestrictionsNestedImpl(item);
  }
  public A withPersistentVolumeClaimAttributeRestrictions(PersistentVolumeClaim persistentVolumeClaimAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (persistentVolumeClaimAttributeRestrictions!=null){ this.attributeRestrictions= new PersistentVolumeClaimBuilder(persistentVolumeClaimAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(PersistentVolumeClaim item) {
    return new PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySelfSubjectReviewAttributeRestrictions(PodSecurityPolicySelfSubjectReview podSecurityPolicySelfSubjectReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySelfSubjectReviewAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySelfSubjectReviewBuilder(podSecurityPolicySelfSubjectReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewAttributeRestrictionsLike(PodSecurityPolicySelfSubjectReview item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withTagReferenceAttributeRestrictions(TagReference tagReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new TagReferenceBuilder(tagReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TagReferenceAttributeRestrictionsNested<A> withNewTagReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TagReferenceAttributeRestrictionsNested<A> withNewTagReferenceAttributeRestrictionsLike(TagReference item) {
    return new PolicyRuleFluentImpl.TagReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicyRuleAttributeRestrictions(EgressNetworkPolicyRule egressNetworkPolicyRuleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyRuleAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyRuleBuilder(egressNetworkPolicyRuleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicyRuleAttributeRestrictionsNested<A> withNewEgressNetworkPolicyRuleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicyRuleAttributeRestrictionsNested<A> withNewEgressNetworkPolicyRuleAttributeRestrictionsLike(EgressNetworkPolicyRule item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl(item);
  }
  public A withSubjectRulesReviewStatusAttributeRestrictions(SubjectRulesReviewStatus subjectRulesReviewStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectRulesReviewStatusAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectRulesReviewStatusBuilder(subjectRulesReviewStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SubjectRulesReviewStatusAttributeRestrictionsNested<A> withNewSubjectRulesReviewStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectRulesReviewStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SubjectRulesReviewStatusAttributeRestrictionsNested<A> withNewSubjectRulesReviewStatusAttributeRestrictionsLike(SubjectRulesReviewStatus item) {
    return new PolicyRuleFluentImpl.SubjectRulesReviewStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildVolumeMountAttributeRestrictions(BuildVolumeMount buildVolumeMountAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildVolumeMountAttributeRestrictions!=null){ this.attributeRestrictions= new BuildVolumeMountBuilder(buildVolumeMountAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildVolumeMountAttributeRestrictionsNested<A> withNewBuildVolumeMountAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildVolumeMountAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildVolumeMountAttributeRestrictionsNested<A> withNewBuildVolumeMountAttributeRestrictionsLike(BuildVolumeMount item) {
    return new PolicyRuleFluentImpl.BuildVolumeMountAttributeRestrictionsNestedImpl(item);
  }
  public A withNewBuildVolumeMountAttributeRestrictions(String destinationPath) {
    return (A)withBuildVolumeMountAttributeRestrictions(new BuildVolumeMount(destinationPath));
  }
  public A withClusterNetworkEntryAttributeRestrictions(ClusterNetworkEntry clusterNetworkEntryAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterNetworkEntryAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterNetworkEntryBuilder(clusterNetworkEntryAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterNetworkEntryAttributeRestrictionsNested<A> withNewClusterNetworkEntryAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterNetworkEntryAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterNetworkEntryAttributeRestrictionsNested<A> withNewClusterNetworkEntryAttributeRestrictionsLike(ClusterNetworkEntry item) {
    return new PolicyRuleFluentImpl.ClusterNetworkEntryAttributeRestrictionsNestedImpl(item);
  }
  public A withNewClusterNetworkEntryAttributeRestrictions(String cidr,Integer hostSubnetLength) {
    return (A)withClusterNetworkEntryAttributeRestrictions(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  public A withTemplateInstanceObjectAttributeRestrictions(TemplateInstanceObject templateInstanceObjectAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceObjectAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceObjectBuilder(templateInstanceObjectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateInstanceObjectAttributeRestrictionsNested<A> withNewTemplateInstanceObjectAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceObjectAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateInstanceObjectAttributeRestrictionsNested<A> withNewTemplateInstanceObjectAttributeRestrictionsLike(TemplateInstanceObject item) {
    return new PolicyRuleFluentImpl.TemplateInstanceObjectAttributeRestrictionsNestedImpl(item);
  }
  public A withGenericKubernetesResourceAttributeRestrictions(GenericKubernetesResource genericKubernetesResourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (genericKubernetesResourceAttributeRestrictions!=null){ this.attributeRestrictions= new GenericKubernetesResourceBuilder(genericKubernetesResourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GenericKubernetesResourceAttributeRestrictionsNested<A> withNewGenericKubernetesResourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GenericKubernetesResourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GenericKubernetesResourceAttributeRestrictionsNested<A> withNewGenericKubernetesResourceAttributeRestrictionsLike(GenericKubernetesResource item) {
    return new PolicyRuleFluentImpl.GenericKubernetesResourceAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildSourceAttributeRestrictions(BuildSource buildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new BuildSourceBuilder(buildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildSourceAttributeRestrictionsNested<A> withNewBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildSourceAttributeRestrictionsNested<A> withNewBuildSourceAttributeRestrictionsLike(BuildSource item) {
    return new PolicyRuleFluentImpl.BuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaStatusAttributeRestrictions(ClusterResourceQuotaStatus clusterResourceQuotaStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaStatusBuilder(clusterResourceQuotaStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaStatusAttributeRestrictionsNested<A> withNewClusterResourceQuotaStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaStatusAttributeRestrictionsNested<A> withNewClusterResourceQuotaStatusAttributeRestrictionsLike(ClusterResourceQuotaStatus item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConditionAttributeRestrictions(DeploymentCondition deploymentConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConditionAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConditionBuilder(deploymentConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentConditionAttributeRestrictionsNested<A> withNewDeploymentConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentConditionAttributeRestrictionsNested<A> withNewDeploymentConditionAttributeRestrictionsLike(DeploymentCondition item) {
    return new PolicyRuleFluentImpl.DeploymentConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositorySpecAttributeRestrictions(HelmChartRepositorySpec helmChartRepositorySpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositorySpecAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositorySpecBuilder(helmChartRepositorySpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.HelmChartRepositorySpecAttributeRestrictionsNested<A> withNewHelmChartRepositorySpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositorySpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.HelmChartRepositorySpecAttributeRestrictionsNested<A> withNewHelmChartRepositorySpecAttributeRestrictionsLike(HelmChartRepositorySpec item) {
    return new PolicyRuleFluentImpl.HelmChartRepositorySpecAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentCauseImageTriggerAttributeRestrictions(DeploymentCauseImageTrigger deploymentCauseImageTriggerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentCauseImageTriggerAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentCauseImageTriggerBuilder(deploymentCauseImageTriggerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentCauseImageTriggerAttributeRestrictionsNested<A> withNewDeploymentCauseImageTriggerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentCauseImageTriggerAttributeRestrictionsNested<A> withNewDeploymentCauseImageTriggerAttributeRestrictionsLike(DeploymentCauseImageTrigger item) {
    return new PolicyRuleFluentImpl.DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamMappingAttributeRestrictions(ImageStreamMapping imageStreamMappingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamMappingAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamMappingBuilder(imageStreamMappingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictionsLike(ImageStreamMapping item) {
    return new PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNestedImpl(item);
  }
  public A withSubjectRulesReviewAttributeRestrictions(SubjectRulesReview subjectRulesReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectRulesReviewAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectRulesReviewBuilder(subjectRulesReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SubjectRulesReviewAttributeRestrictionsNested<A> withNewSubjectRulesReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectRulesReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SubjectRulesReviewAttributeRestrictionsNested<A> withNewSubjectRulesReviewAttributeRestrictionsLike(SubjectRulesReview item) {
    return new PolicyRuleFluentImpl.SubjectRulesReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleAttributeRestrictions(Role roleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBuilder(roleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(Role item) {
    return new PolicyRuleFluentImpl.RoleAttributeRestrictionsNestedImpl(item);
  }
  public A withGitBuildSourceAttributeRestrictions(GitBuildSource gitBuildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (gitBuildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new GitBuildSourceBuilder(gitBuildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GitBuildSourceAttributeRestrictionsNested<A> withNewGitBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GitBuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GitBuildSourceAttributeRestrictionsNested<A> withNewGitBuildSourceAttributeRestrictionsLike(GitBuildSource item) {
    return new PolicyRuleFluentImpl.GitBuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewGitBuildSourceAttributeRestrictions(String httpProxy,String httpsProxy,String noProxy,String ref,String uri) {
    return (A)withGitBuildSourceAttributeRestrictions(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
  }
  public A withEgressNetworkPolicyListAttributeRestrictions(EgressNetworkPolicyList egressNetworkPolicyListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyListAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyListBuilder(egressNetworkPolicyListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicyListAttributeRestrictionsNested<A> withNewEgressNetworkPolicyListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicyListAttributeRestrictionsNested<A> withNewEgressNetworkPolicyListAttributeRestrictionsLike(EgressNetworkPolicyList item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyListAttributeRestrictionsNestedImpl(item);
  }
  public A withSelfSubjectRulesReviewSpecAttributeRestrictions(SelfSubjectRulesReviewSpec selfSubjectRulesReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (selfSubjectRulesReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new SelfSubjectRulesReviewSpecBuilder(selfSubjectRulesReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SelfSubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SelfSubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewSpecAttributeRestrictionsLike(SelfSubjectRulesReviewSpec item) {
    return new PolicyRuleFluentImpl.SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withImageSourcePathAttributeRestrictions(ImageSourcePath imageSourcePathAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageSourcePathAttributeRestrictions!=null){ this.attributeRestrictions= new ImageSourcePathBuilder(imageSourcePathAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageSourcePathAttributeRestrictionsNested<A> withNewImageSourcePathAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageSourcePathAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageSourcePathAttributeRestrictionsNested<A> withNewImageSourcePathAttributeRestrictionsLike(ImageSourcePath item) {
    return new PolicyRuleFluentImpl.ImageSourcePathAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageSourcePathAttributeRestrictions(String destinationDir,String sourcePath) {
    return (A)withImageSourcePathAttributeRestrictions(new ImageSourcePath(destinationDir, sourcePath));
  }
  public A withBuildConfigStatusAttributeRestrictions(BuildConfigStatus buildConfigStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigStatusAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigStatusBuilder(buildConfigStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildConfigStatusAttributeRestrictionsNested<A> withNewBuildConfigStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildConfigStatusAttributeRestrictionsNested<A> withNewBuildConfigStatusAttributeRestrictionsLike(BuildConfigStatus item) {
    return new PolicyRuleFluentImpl.BuildConfigStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withResourceQuotaStatusByNamespaceAttributeRestrictions(ResourceQuotaStatusByNamespace resourceQuotaStatusByNamespaceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (resourceQuotaStatusByNamespaceAttributeRestrictions!=null){ this.attributeRestrictions= new ResourceQuotaStatusByNamespaceBuilder(resourceQuotaStatusByNamespaceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<A> withNewResourceQuotaStatusByNamespaceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<A> withNewResourceQuotaStatusByNamespaceAttributeRestrictionsLike(ResourceQuotaStatusByNamespace item) {
    return new PolicyRuleFluentImpl.ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl(item);
  }
  public A withSourceBuildStrategyAttributeRestrictions(SourceBuildStrategy sourceBuildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sourceBuildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new SourceBuildStrategyBuilder(sourceBuildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SourceBuildStrategyAttributeRestrictionsNested<A> withNewSourceBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SourceBuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SourceBuildStrategyAttributeRestrictionsNested<A> withNewSourceBuildStrategyAttributeRestrictionsLike(SourceBuildStrategy item) {
    return new PolicyRuleFluentImpl.SourceBuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withParameterAttributeRestrictions(Parameter parameterAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (parameterAttributeRestrictions!=null){ this.attributeRestrictions= new ParameterBuilder(parameterAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ParameterAttributeRestrictionsNested<A> withNewParameterAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ParameterAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ParameterAttributeRestrictionsNested<A> withNewParameterAttributeRestrictionsLike(Parameter item) {
    return new PolicyRuleFluentImpl.ParameterAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingListAttributeRestrictions(RoleBindingList roleBindingListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingListAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingListBuilder(roleBindingListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RoleBindingListAttributeRestrictionsNested<A> withNewRoleBindingListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RoleBindingListAttributeRestrictionsNested<A> withNewRoleBindingListAttributeRestrictionsLike(RoleBindingList item) {
    return new PolicyRuleFluentImpl.RoleBindingListAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictions(PodSecurityPolicySelfSubjectReviewSpec podSecurityPolicySelfSubjectReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySelfSubjectReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySelfSubjectReviewSpecBuilder(podSecurityPolicySelfSubjectReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsLike(PodSecurityPolicySelfSubjectReviewSpec item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withBrokerTemplateInstanceAttributeRestrictions(BrokerTemplateInstance brokerTemplateInstanceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (brokerTemplateInstanceAttributeRestrictions!=null){ this.attributeRestrictions= new BrokerTemplateInstanceBuilder(brokerTemplateInstanceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictionsLike(BrokerTemplateInstance item) {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildPostCommitSpecAttributeRestrictions(BuildPostCommitSpec buildPostCommitSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildPostCommitSpecAttributeRestrictions!=null){ this.attributeRestrictions= new BuildPostCommitSpecBuilder(buildPostCommitSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildPostCommitSpecAttributeRestrictionsNested<A> withNewBuildPostCommitSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildPostCommitSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildPostCommitSpecAttributeRestrictionsNested<A> withNewBuildPostCommitSpecAttributeRestrictionsLike(BuildPostCommitSpec item) {
    return new PolicyRuleFluentImpl.BuildPostCommitSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenListAttributeRestrictions(OAuthAuthorizeTokenList oAuthAuthorizeTokenListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAuthorizeTokenListAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAuthorizeTokenListBuilder(oAuthAuthorizeTokenListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OAuthAuthorizeTokenListAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OAuthAuthorizeTokenListAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenListAttributeRestrictionsLike(OAuthAuthorizeTokenList item) {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentStrategyAttributeRestrictions(DeploymentStrategy deploymentStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentStrategyBuilder(deploymentStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentStrategyAttributeRestrictionsNested<A> withNewDeploymentStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentStrategyAttributeRestrictionsNested<A> withNewDeploymentStrategyAttributeRestrictionsLike(DeploymentStrategy item) {
    return new PolicyRuleFluentImpl.DeploymentStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withSignatureSubjectAttributeRestrictions(SignatureSubject signatureSubjectAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (signatureSubjectAttributeRestrictions!=null){ this.attributeRestrictions= new SignatureSubjectBuilder(signatureSubjectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SignatureSubjectAttributeRestrictionsNested<A> withNewSignatureSubjectAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SignatureSubjectAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SignatureSubjectAttributeRestrictionsNested<A> withNewSignatureSubjectAttributeRestrictionsLike(SignatureSubject item) {
    return new PolicyRuleFluentImpl.SignatureSubjectAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSignatureSubjectAttributeRestrictions(String commonName,String organization,String publicKeyID) {
    return (A)withSignatureSubjectAttributeRestrictions(new SignatureSubject(commonName, organization, publicKeyID));
  }
  public A withHostSubnetListAttributeRestrictions(HostSubnetList hostSubnetListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (hostSubnetListAttributeRestrictions!=null){ this.attributeRestrictions= new HostSubnetListBuilder(hostSubnetListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.HostSubnetListAttributeRestrictionsNested<A> withNewHostSubnetListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HostSubnetListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.HostSubnetListAttributeRestrictionsNested<A> withNewHostSubnetListAttributeRestrictionsLike(HostSubnetList item) {
    return new PolicyRuleFluentImpl.HostSubnetListAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteIngressConditionAttributeRestrictions(RouteIngressCondition routeIngressConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeIngressConditionAttributeRestrictions!=null){ this.attributeRestrictions= new RouteIngressConditionBuilder(routeIngressConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RouteIngressConditionAttributeRestrictionsNested<A> withNewRouteIngressConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteIngressConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RouteIngressConditionAttributeRestrictionsNested<A> withNewRouteIngressConditionAttributeRestrictionsLike(RouteIngressCondition item) {
    return new PolicyRuleFluentImpl.RouteIngressConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withNewRouteIngressConditionAttributeRestrictions(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withRouteIngressConditionAttributeRestrictions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withCustomDeploymentStrategyParamsAttributeRestrictions(CustomDeploymentStrategyParams customDeploymentStrategyParamsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (customDeploymentStrategyParamsAttributeRestrictions!=null){ this.attributeRestrictions= new CustomDeploymentStrategyParamsBuilder(customDeploymentStrategyParamsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.CustomDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewCustomDeploymentStrategyParamsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.CustomDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewCustomDeploymentStrategyParamsAttributeRestrictionsLike(CustomDeploymentStrategyParams item) {
    return new PolicyRuleFluentImpl.CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl(item);
  }
  public A withImageImportSpecAttributeRestrictions(ImageImportSpec imageImportSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageImportSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ImageImportSpecBuilder(imageImportSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageImportSpecAttributeRestrictionsNested<A> withNewImageImportSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageImportSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageImportSpecAttributeRestrictionsNested<A> withNewImageImportSpecAttributeRestrictionsLike(ImageImportSpec item) {
    return new PolicyRuleFluentImpl.ImageImportSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withStageInfoAttributeRestrictions(StageInfo stageInfoAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (stageInfoAttributeRestrictions!=null){ this.attributeRestrictions= new StageInfoBuilder(stageInfoAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.StageInfoAttributeRestrictionsNested<A> withNewStageInfoAttributeRestrictions() {
    return new PolicyRuleFluentImpl.StageInfoAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.StageInfoAttributeRestrictionsNested<A> withNewStageInfoAttributeRestrictionsLike(StageInfo item) {
    return new PolicyRuleFluentImpl.StageInfoAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingRestrictionSpecAttributeRestrictions(RoleBindingRestrictionSpec roleBindingRestrictionSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingRestrictionSpecAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingRestrictionSpecBuilder(roleBindingRestrictionSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RoleBindingRestrictionSpecAttributeRestrictionsNested<A> withNewRoleBindingRestrictionSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RoleBindingRestrictionSpecAttributeRestrictionsNested<A> withNewRoleBindingRestrictionSpecAttributeRestrictionsLike(RoleBindingRestrictionSpec item) {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withIDRangeAttributeRestrictions(IDRange iDRangeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (iDRangeAttributeRestrictions!=null){ this.attributeRestrictions= new IDRangeBuilder(iDRangeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.IDRangeAttributeRestrictionsNested<A> withNewIDRangeAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IDRangeAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.IDRangeAttributeRestrictionsNested<A> withNewIDRangeAttributeRestrictionsLike(IDRange item) {
    return new PolicyRuleFluentImpl.IDRangeAttributeRestrictionsNestedImpl(item);
  }
  public A withNewIDRangeAttributeRestrictions(Long max,Long min) {
    return (A)withIDRangeAttributeRestrictions(new IDRange(max, min));
  }
  public A withUserListAttributeRestrictions(UserList userListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userListAttributeRestrictions!=null){ this.attributeRestrictions= new UserListBuilder(userListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.UserListAttributeRestrictionsNested<A> withNewUserListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.UserListAttributeRestrictionsNested<A> withNewUserListAttributeRestrictionsLike(UserList item) {
    return new PolicyRuleFluentImpl.UserListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildConfigSpecAttributeRestrictions(BuildConfigSpec buildConfigSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigSpecAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigSpecBuilder(buildConfigSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildConfigSpecAttributeRestrictionsNested<A> withNewBuildConfigSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildConfigSpecAttributeRestrictionsNested<A> withNewBuildConfigSpecAttributeRestrictionsLike(BuildConfigSpec item) {
    return new PolicyRuleFluentImpl.BuildConfigSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withUserAttributeRestrictions(User userAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userAttributeRestrictions!=null){ this.attributeRestrictions= new UserBuilder(userAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(User item) {
    return new PolicyRuleFluentImpl.UserAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImageAttributeRestrictions(ImageStreamImage imageStreamImageAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImageAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImageBuilder(imageStreamImageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictionsLike(ImageStreamImage item) {
    return new PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildStatusOutputToAttributeRestrictions(BuildStatusOutputTo buildStatusOutputToAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildStatusOutputToAttributeRestrictions!=null){ this.attributeRestrictions= new BuildStatusOutputToBuilder(buildStatusOutputToAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildStatusOutputToAttributeRestrictionsNested<A> withNewBuildStatusOutputToAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildStatusOutputToAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildStatusOutputToAttributeRestrictionsNested<A> withNewBuildStatusOutputToAttributeRestrictionsLike(BuildStatusOutputTo item) {
    return new PolicyRuleFluentImpl.BuildStatusOutputToAttributeRestrictionsNestedImpl(item);
  }
  public A withNewBuildStatusOutputToAttributeRestrictions(String imageDigest) {
    return (A)withBuildStatusOutputToAttributeRestrictions(new BuildStatusOutputTo(imageDigest));
  }
  public A withBuildConditionAttributeRestrictions(BuildCondition buildConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConditionAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConditionBuilder(buildConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildConditionAttributeRestrictionsNested<A> withNewBuildConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildConditionAttributeRestrictionsNested<A> withNewBuildConditionAttributeRestrictionsLike(BuildCondition item) {
    return new PolicyRuleFluentImpl.BuildConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withResourceAccessReviewResponseAttributeRestrictions(ResourceAccessReviewResponse resourceAccessReviewResponseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (resourceAccessReviewResponseAttributeRestrictions!=null){ this.attributeRestrictions= new ResourceAccessReviewResponseBuilder(resourceAccessReviewResponseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ResourceAccessReviewResponseAttributeRestrictionsNested<A> withNewResourceAccessReviewResponseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ResourceAccessReviewResponseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ResourceAccessReviewResponseAttributeRestrictionsNested<A> withNewResourceAccessReviewResponseAttributeRestrictionsLike(ResourceAccessReviewResponse item) {
    return new PolicyRuleFluentImpl.ResourceAccessReviewResponseAttributeRestrictionsNestedImpl(item);
  }
  public A withExecNewPodHookAttributeRestrictions(ExecNewPodHook execNewPodHookAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (execNewPodHookAttributeRestrictions!=null){ this.attributeRestrictions= new ExecNewPodHookBuilder(execNewPodHookAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ExecNewPodHookAttributeRestrictionsNested<A> withNewExecNewPodHookAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ExecNewPodHookAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ExecNewPodHookAttributeRestrictionsNested<A> withNewExecNewPodHookAttributeRestrictionsLike(ExecNewPodHook item) {
    return new PolicyRuleFluentImpl.ExecNewPodHookAttributeRestrictionsNestedImpl(item);
  }
  public A withSecretSpecAttributeRestrictions(SecretSpec secretSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (secretSpecAttributeRestrictions!=null){ this.attributeRestrictions= new SecretSpecBuilder(secretSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SecretSpecAttributeRestrictionsNested<A> withNewSecretSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecretSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SecretSpecAttributeRestrictionsNested<A> withNewSecretSpecAttributeRestrictionsLike(SecretSpec item) {
    return new PolicyRuleFluentImpl.SecretSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleBindingListAttributeRestrictions(ClusterRoleBindingList clusterRoleBindingListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleBindingListAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBindingListBuilder(clusterRoleBindingListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterRoleBindingListAttributeRestrictionsNested<A> withNewClusterRoleBindingListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleBindingListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterRoleBindingListAttributeRestrictionsNested<A> withNewClusterRoleBindingListAttributeRestrictionsLike(ClusterRoleBindingList item) {
    return new PolicyRuleFluentImpl.ClusterRoleBindingListAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicyPeerAttributeRestrictions(EgressNetworkPolicyPeer egressNetworkPolicyPeerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyPeerAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyPeerBuilder(egressNetworkPolicyPeerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicyPeerAttributeRestrictionsNested<A> withNewEgressNetworkPolicyPeerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicyPeerAttributeRestrictionsNested<A> withNewEgressNetworkPolicyPeerAttributeRestrictionsLike(EgressNetworkPolicyPeer item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl(item);
  }
  public A withNewEgressNetworkPolicyPeerAttributeRestrictions(String cidrSelector,String dnsName) {
    return (A)withEgressNetworkPolicyPeerAttributeRestrictions(new EgressNetworkPolicyPeer(cidrSelector, dnsName));
  }
  public A withTemplateInstanceAttributeRestrictions(TemplateInstance templateInstanceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceBuilder(templateInstanceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictionsLike(TemplateInstance item) {
    return new PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNestedImpl(item);
  }
  public A withWebHookTriggerAttributeRestrictions(WebHookTrigger webHookTriggerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (webHookTriggerAttributeRestrictions!=null){ this.attributeRestrictions= new WebHookTriggerBuilder(webHookTriggerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.WebHookTriggerAttributeRestrictionsNested<A> withNewWebHookTriggerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.WebHookTriggerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.WebHookTriggerAttributeRestrictionsNested<A> withNewWebHookTriggerAttributeRestrictionsLike(WebHookTrigger item) {
    return new PolicyRuleFluentImpl.WebHookTriggerAttributeRestrictionsNestedImpl(item);
  }
  public A withServiceAccountReferenceAttributeRestrictions(ServiceAccountReference serviceAccountReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (serviceAccountReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new ServiceAccountReferenceBuilder(serviceAccountReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ServiceAccountReferenceAttributeRestrictionsNested<A> withNewServiceAccountReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ServiceAccountReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ServiceAccountReferenceAttributeRestrictionsNested<A> withNewServiceAccountReferenceAttributeRestrictionsLike(ServiceAccountReference item) {
    return new PolicyRuleFluentImpl.ServiceAccountReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewServiceAccountReferenceAttributeRestrictions(String name,String namespace) {
    return (A)withServiceAccountReferenceAttributeRestrictions(new ServiceAccountReference(name, namespace));
  }
  public A withBuildAttributeRestrictions(Build buildAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildAttributeRestrictions!=null){ this.attributeRestrictions= new BuildBuilder(buildAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(Build item) {
    return new PolicyRuleFluentImpl.BuildAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingRestrictionAttributeRestrictions(RoleBindingRestriction roleBindingRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingRestrictionBuilder(roleBindingRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(RoleBindingRestriction item) {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withTagImportPolicyAttributeRestrictions(TagImportPolicy tagImportPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagImportPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new TagImportPolicyBuilder(tagImportPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TagImportPolicyAttributeRestrictionsNested<A> withNewTagImportPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagImportPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TagImportPolicyAttributeRestrictionsNested<A> withNewTagImportPolicyAttributeRestrictionsLike(TagImportPolicy item) {
    return new PolicyRuleFluentImpl.TagImportPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNewTagImportPolicyAttributeRestrictions(Boolean insecure,Boolean scheduled) {
    return (A)withTagImportPolicyAttributeRestrictions(new TagImportPolicy(insecure, scheduled));
  }
  public A withImageStreamTagAttributeRestrictions(ImageStreamTag imageStreamTagAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamTagAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamTagBuilder(imageStreamTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(ImageStreamTag item) {
    return new PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildTriggerPolicyAttributeRestrictions(BuildTriggerPolicy buildTriggerPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildTriggerPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new BuildTriggerPolicyBuilder(buildTriggerPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildTriggerPolicyAttributeRestrictionsNested<A> withNewBuildTriggerPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildTriggerPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildTriggerPolicyAttributeRestrictionsNested<A> withNewBuildTriggerPolicyAttributeRestrictionsLike(BuildTriggerPolicy item) {
    return new PolicyRuleFluentImpl.BuildTriggerPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withRoutePortAttributeRestrictions(RoutePort routePortAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routePortAttributeRestrictions!=null){ this.attributeRestrictions= new RoutePortBuilder(routePortAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RoutePortAttributeRestrictionsNested<A> withNewRoutePortAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoutePortAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RoutePortAttributeRestrictionsNested<A> withNewRoutePortAttributeRestrictionsLike(RoutePort item) {
    return new PolicyRuleFluentImpl.RoutePortAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceRequesterAttributeRestrictions(TemplateInstanceRequester templateInstanceRequesterAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceRequesterAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceRequesterBuilder(templateInstanceRequesterAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateInstanceRequesterAttributeRestrictionsNested<A> withNewTemplateInstanceRequesterAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceRequesterAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateInstanceRequesterAttributeRestrictionsNested<A> withNewTemplateInstanceRequesterAttributeRestrictionsLike(TemplateInstanceRequester item) {
    return new PolicyRuleFluentImpl.TemplateInstanceRequesterAttributeRestrictionsNestedImpl(item);
  }
  public A withGroupAttributeRestrictions(Group groupAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (groupAttributeRestrictions!=null){ this.attributeRestrictions= new GroupBuilder(groupAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GroupAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(Group item) {
    return new PolicyRuleFluentImpl.GroupAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildTriggerCauseAttributeRestrictions(BuildTriggerCause buildTriggerCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildTriggerCauseAttributeRestrictions!=null){ this.attributeRestrictions= new BuildTriggerCauseBuilder(buildTriggerCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildTriggerCauseAttributeRestrictionsNested<A> withNewBuildTriggerCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildTriggerCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildTriggerCauseAttributeRestrictionsNested<A> withNewBuildTriggerCauseAttributeRestrictionsLike(BuildTriggerCause item) {
    return new PolicyRuleFluentImpl.BuildTriggerCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withImageSignatureAttributeRestrictions(ImageSignature imageSignatureAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageSignatureAttributeRestrictions!=null){ this.attributeRestrictions= new ImageSignatureBuilder(imageSignatureAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(ImageSignature item) {
    return new PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositoryStatusAttributeRestrictions(HelmChartRepositoryStatus helmChartRepositoryStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositoryStatusAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositoryStatusBuilder(helmChartRepositoryStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.HelmChartRepositoryStatusAttributeRestrictionsNested<A> withNewHelmChartRepositoryStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositoryStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.HelmChartRepositoryStatusAttributeRestrictionsNested<A> withNewHelmChartRepositoryStatusAttributeRestrictionsLike(HelmChartRepositoryStatus item) {
    return new PolicyRuleFluentImpl.HelmChartRepositoryStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigSpecAttributeRestrictions(DeploymentConfigSpec deploymentConfigSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigSpecAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigSpecBuilder(deploymentConfigSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentConfigSpecAttributeRestrictionsNested<A> withNewDeploymentConfigSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentConfigSpecAttributeRestrictionsNested<A> withNewDeploymentConfigSpecAttributeRestrictionsLike(DeploymentConfigSpec item) {
    return new PolicyRuleFluentImpl.DeploymentConfigSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withHostSubnetAttributeRestrictions(HostSubnet hostSubnetAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (hostSubnetAttributeRestrictions!=null){ this.attributeRestrictions= new HostSubnetBuilder(hostSubnetAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictionsLike(HostSubnet item) {
    return new PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNestedImpl(item);
  }
  public A withGroupRestrictionAttributeRestrictions(GroupRestriction groupRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (groupRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new GroupRestrictionBuilder(groupRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.GroupRestrictionAttributeRestrictionsNested<A> withNewGroupRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GroupRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.GroupRestrictionAttributeRestrictionsNested<A> withNewGroupRestrictionAttributeRestrictionsLike(GroupRestriction item) {
    return new PolicyRuleFluentImpl.GroupRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaAttributeRestrictions(AppliedClusterResourceQuota appliedClusterResourceQuotaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (appliedClusterResourceQuotaAttributeRestrictions!=null){ this.attributeRestrictions= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictionsLike(AppliedClusterResourceQuota item) {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAccessTokenListAttributeRestrictions(OAuthAccessTokenList oAuthAccessTokenListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAccessTokenListAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAccessTokenListBuilder(oAuthAccessTokenListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OAuthAccessTokenListAttributeRestrictionsNested<A> withNewOAuthAccessTokenListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAccessTokenListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OAuthAccessTokenListAttributeRestrictionsNested<A> withNewOAuthAccessTokenListAttributeRestrictionsLike(OAuthAccessTokenList item) {
    return new PolicyRuleFluentImpl.OAuthAccessTokenListAttributeRestrictionsNestedImpl(item);
  }
  public A withJenkinsPipelineBuildStrategyAttributeRestrictions(JenkinsPipelineBuildStrategy jenkinsPipelineBuildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (jenkinsPipelineBuildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new JenkinsPipelineBuildStrategyBuilder(jenkinsPipelineBuildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.JenkinsPipelineBuildStrategyAttributeRestrictionsNested<A> withNewJenkinsPipelineBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.JenkinsPipelineBuildStrategyAttributeRestrictionsNested<A> withNewJenkinsPipelineBuildStrategyAttributeRestrictionsLike(JenkinsPipelineBuildStrategy item) {
    return new PolicyRuleFluentImpl.JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withSecurityContextConstraintsAttributeRestrictions(SecurityContextConstraints securityContextConstraintsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (securityContextConstraintsAttributeRestrictions!=null){ this.attributeRestrictions= new SecurityContextConstraintsBuilder(securityContextConstraintsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(SecurityContextConstraints item) {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNestedImpl(item);
  }
  public A withSupplementalGroupsStrategyOptionsAttributeRestrictions(SupplementalGroupsStrategyOptions supplementalGroupsStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (supplementalGroupsStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroupsStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<A> withNewSupplementalGroupsStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<A> withNewSupplementalGroupsStrategyOptionsAttributeRestrictionsLike(SupplementalGroupsStrategyOptions item) {
    return new PolicyRuleFluentImpl.SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictions(ServiceAccountPodSecurityPolicyReviewStatus serviceAccountPodSecurityPolicyReviewStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (serviceAccountPodSecurityPolicyReviewStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ServiceAccountPodSecurityPolicyReviewStatusBuilder(serviceAccountPodSecurityPolicyReviewStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
    return new PolicyRuleFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildRequestAttributeRestrictions(BuildRequest buildRequestAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildRequestAttributeRestrictions!=null){ this.attributeRestrictions= new BuildRequestBuilder(buildRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(BuildRequest item) {
    return new PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNestedImpl(item);
  }
  public A withSELinuxContextStrategyOptionsAttributeRestrictions(SELinuxContextStrategyOptions sELinuxContextStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sELinuxContextStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new SELinuxContextStrategyOptionsBuilder(sELinuxContextStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SELinuxContextStrategyOptionsAttributeRestrictionsNested<A> withNewSELinuxContextStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SELinuxContextStrategyOptionsAttributeRestrictionsNested<A> withNewSELinuxContextStrategyOptionsAttributeRestrictionsLike(SELinuxContextStrategyOptions item) {
    return new PolicyRuleFluentImpl.SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleListAttributeRestrictions(ClusterRoleList clusterRoleListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleListAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleListBuilder(clusterRoleListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterRoleListAttributeRestrictionsNested<A> withNewClusterRoleListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterRoleListAttributeRestrictionsNested<A> withNewClusterRoleListAttributeRestrictionsLike(ClusterRoleList item) {
    return new PolicyRuleFluentImpl.ClusterRoleListAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteListAttributeRestrictions(RouteList routeListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeListAttributeRestrictions!=null){ this.attributeRestrictions= new RouteListBuilder(routeListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RouteListAttributeRestrictionsNested<A> withNewRouteListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RouteListAttributeRestrictionsNested<A> withNewRouteListAttributeRestrictionsLike(RouteList item) {
    return new PolicyRuleFluentImpl.RouteListAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamStatusAttributeRestrictions(ImageStreamStatus imageStreamStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamStatusBuilder(imageStreamStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamStatusAttributeRestrictionsNested<A> withNewImageStreamStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamStatusAttributeRestrictionsNested<A> withNewImageStreamStatusAttributeRestrictionsLike(ImageStreamStatus item) {
    return new PolicyRuleFluentImpl.ImageStreamStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicyAttributeRestrictions(EgressNetworkPolicy egressNetworkPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyBuilder(egressNetworkPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictionsLike(EgressNetworkPolicy item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNetNamespaceAttributeRestrictions(NetNamespace netNamespaceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (netNamespaceAttributeRestrictions!=null){ this.attributeRestrictions= new NetNamespaceBuilder(netNamespaceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(NetNamespace item) {
    return new PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNestedImpl(item);
  }
  public A withUserIdentityMappingAttributeRestrictions(UserIdentityMapping userIdentityMappingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userIdentityMappingAttributeRestrictions!=null){ this.attributeRestrictions= new UserIdentityMappingBuilder(userIdentityMappingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictionsLike(UserIdentityMapping item) {
    return new PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentDetailsAttributeRestrictions(DeploymentDetails deploymentDetailsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentDetailsAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentDetailsBuilder(deploymentDetailsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.DeploymentDetailsAttributeRestrictionsNested<A> withNewDeploymentDetailsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentDetailsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.DeploymentDetailsAttributeRestrictionsNested<A> withNewDeploymentDetailsAttributeRestrictionsLike(DeploymentDetails item) {
    return new PolicyRuleFluentImpl.DeploymentDetailsAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewStatusAttributeRestrictions(PodSecurityPolicySubjectReviewStatus podSecurityPolicySubjectReviewStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySubjectReviewStatusAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewStatusBuilder(podSecurityPolicySubjectReviewStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewStatusAttributeRestrictionsLike(PodSecurityPolicySubjectReviewStatus item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewSpecAttributeRestrictions(PodSecurityPolicySubjectReviewSpec podSecurityPolicySubjectReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySubjectReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewSpecBuilder(podSecurityPolicySubjectReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewSpecAttributeRestrictionsLike(PodSecurityPolicySubjectReviewSpec item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamAttributeRestrictions(ImageStream imageStreamAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamBuilder(imageStreamAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(ImageStream item) {
    return new PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildListAttributeRestrictions(BuildList buildListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildListAttributeRestrictions!=null){ this.attributeRestrictions= new BuildListBuilder(buildListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildListAttributeRestrictionsNested<A> withNewBuildListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildListAttributeRestrictionsNested<A> withNewBuildListAttributeRestrictionsLike(BuildList item) {
    return new PolicyRuleFluentImpl.BuildListAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateListAttributeRestrictions(TemplateList templateListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateListAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateListBuilder(templateListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.TemplateListAttributeRestrictionsNested<A> withNewTemplateListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.TemplateListAttributeRestrictionsNested<A> withNewTemplateListAttributeRestrictionsLike(TemplateList item) {
    return new PolicyRuleFluentImpl.TemplateListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildOutputAttributeRestrictions(BuildOutput buildOutputAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildOutputAttributeRestrictions!=null){ this.attributeRestrictions= new BuildOutputBuilder(buildOutputAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.BuildOutputAttributeRestrictionsNested<A> withNewBuildOutputAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildOutputAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.BuildOutputAttributeRestrictionsNested<A> withNewBuildOutputAttributeRestrictionsLike(BuildOutput item) {
    return new PolicyRuleFluentImpl.BuildOutputAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectSpecAttributeRestrictions(ProjectSpec projectSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectSpecBuilder(projectSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ProjectSpecAttributeRestrictionsNested<A> withNewProjectSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ProjectSpecAttributeRestrictionsNested<A> withNewProjectSpecAttributeRestrictionsLike(ProjectSpec item) {
    return new PolicyRuleFluentImpl.ProjectSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withSourceRevisionAttributeRestrictions(SourceRevision sourceRevisionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sourceRevisionAttributeRestrictions!=null){ this.attributeRestrictions= new SourceRevisionBuilder(sourceRevisionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SourceRevisionAttributeRestrictionsNested<A> withNewSourceRevisionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SourceRevisionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SourceRevisionAttributeRestrictionsNested<A> withNewSourceRevisionAttributeRestrictionsLike(SourceRevision item) {
    return new PolicyRuleFluentImpl.SourceRevisionAttributeRestrictionsNestedImpl(item);
  }
  public A withObjectReferenceAttributeRestrictions(ObjectReference objectReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (objectReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new ObjectReferenceBuilder(objectReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ObjectReferenceAttributeRestrictionsNested<A> withNewObjectReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ObjectReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ObjectReferenceAttributeRestrictionsNested<A> withNewObjectReferenceAttributeRestrictionsLike(ObjectReference item) {
    return new PolicyRuleFluentImpl.ObjectReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withSignatureIssuerAttributeRestrictions(SignatureIssuer signatureIssuerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (signatureIssuerAttributeRestrictions!=null){ this.attributeRestrictions= new SignatureIssuerBuilder(signatureIssuerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.SignatureIssuerAttributeRestrictionsNested<A> withNewSignatureIssuerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SignatureIssuerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.SignatureIssuerAttributeRestrictionsNested<A> withNewSignatureIssuerAttributeRestrictionsLike(SignatureIssuer item) {
    return new PolicyRuleFluentImpl.SignatureIssuerAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSignatureIssuerAttributeRestrictions(String commonName,String organization) {
    return (A)withSignatureIssuerAttributeRestrictions(new SignatureIssuer(commonName, organization));
  }
  public A withImageLayerAttributeRestrictions(ImageLayer imageLayerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageLayerAttributeRestrictions!=null){ this.attributeRestrictions= new ImageLayerBuilder(imageLayerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageLayerAttributeRestrictionsNested<A> withNewImageLayerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageLayerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageLayerAttributeRestrictionsNested<A> withNewImageLayerAttributeRestrictionsLike(ImageLayer item) {
    return new PolicyRuleFluentImpl.ImageLayerAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageLayerAttributeRestrictions(String mediaType,String name,Long size) {
    return (A)withImageLayerAttributeRestrictions(new ImageLayer(mediaType, name, size));
  }
  public A withClusterResourceQuotaSpecAttributeRestrictions(ClusterResourceQuotaSpec clusterResourceQuotaSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaSpecBuilder(clusterResourceQuotaSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaSpecAttributeRestrictionsNested<A> withNewClusterResourceQuotaSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ClusterResourceQuotaSpecAttributeRestrictionsNested<A> withNewClusterResourceQuotaSpecAttributeRestrictionsLike(ClusterResourceQuotaSpec item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamSpecAttributeRestrictions(ImageStreamSpec imageStreamSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamSpecBuilder(imageStreamSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.ImageStreamSpecAttributeRestrictionsNested<A> withNewImageStreamSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.ImageStreamSpecAttributeRestrictionsNested<A> withNewImageStreamSpecAttributeRestrictionsLike(ImageStreamSpec item) {
    return new PolicyRuleFluentImpl.ImageStreamSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteIngressAttributeRestrictions(RouteIngress routeIngressAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeIngressAttributeRestrictions!=null){ this.attributeRestrictions= new RouteIngressBuilder(routeIngressAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RouteIngressAttributeRestrictionsNested<A> withNewRouteIngressAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteIngressAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RouteIngressAttributeRestrictionsNested<A> withNewRouteIngressAttributeRestrictionsLike(RouteIngress item) {
    return new PolicyRuleFluentImpl.RouteIngressAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthClientAttributeRestrictions(OAuthClient oAuthClientAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientBuilder(oAuthClientAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(OAuthClient item) {
    return new PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNestedImpl(item);
  }
  public A withIdentityAttributeRestrictions(Identity identityAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (identityAttributeRestrictions!=null){ this.attributeRestrictions= new IdentityBuilder(identityAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IdentityAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(Identity item) {
    return new PolicyRuleFluentImpl.IdentityAttributeRestrictionsNestedImpl(item);
  }
  public A withRangeAllocationListAttributeRestrictions(RangeAllocationList rangeAllocationListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rangeAllocationListAttributeRestrictions!=null){ this.attributeRestrictions= new RangeAllocationListBuilder(rangeAllocationListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluentImpl.RangeAllocationListAttributeRestrictionsNested<A> withNewRangeAllocationListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RangeAllocationListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluentImpl.RangeAllocationListAttributeRestrictionsNested<A> withNewRangeAllocationListAttributeRestrictionsLike(RangeAllocationList item) {
    return new PolicyRuleFluentImpl.RangeAllocationListAttributeRestrictionsNestedImpl(item);
  }
  public A addToNonResourceURLs(int index,String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    this.nonResourceURLs.add(index, item);
    return (A)this;
  }
  public A setToNonResourceURLs(int index,String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    this.nonResourceURLs.set(index, item); return (A)this;
  }
  public A addToNonResourceURLs(java.lang.String... items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  public A addAllToNonResourceURLs(Collection<String> items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  public A removeFromNonResourceURLs(java.lang.String... items) {
    for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
  }
  public A removeAllFromNonResourceURLs(Collection<String> items) {
    for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
  }
  public List<String> getNonResourceURLs() {
    return this.nonResourceURLs;
  }
  public String getNonResourceURL(int index) {
    return this.nonResourceURLs.get(index);
  }
  public String getFirstNonResourceURL() {
    return this.nonResourceURLs.get(0);
  }
  public String getLastNonResourceURL() {
    return this.nonResourceURLs.get(nonResourceURLs.size() - 1);
  }
  public String getMatchingNonResourceURL(Predicate<String> predicate) {
    for (String item: nonResourceURLs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
    for (String item: nonResourceURLs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNonResourceURLs(List<String> nonResourceURLs) {
    if (nonResourceURLs != null) {this.nonResourceURLs = new ArrayList(); for (String item : nonResourceURLs){this.addToNonResourceURLs(item);}} else { this.nonResourceURLs = null;} return (A) this;
  }
  public A withNonResourceURLs(java.lang.String... nonResourceURLs) {
    if (this.nonResourceURLs != null) {this.nonResourceURLs.clear(); _visitables.remove("nonResourceURLs"); }
    if (nonResourceURLs != null) {for (String item :nonResourceURLs){ this.addToNonResourceURLs(item);}} return (A) this;
  }
  public Boolean hasNonResourceURLs() {
    return nonResourceURLs != null && !nonResourceURLs.isEmpty();
  }
  public A addToResourceNames(int index,String item) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    this.resourceNames.add(index, item);
    return (A)this;
  }
  public A setToResourceNames(int index,String item) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    this.resourceNames.set(index, item); return (A)this;
  }
  public A addToResourceNames(java.lang.String... items) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    for (String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  public A addAllToResourceNames(Collection<String> items) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    for (String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  public A removeFromResourceNames(java.lang.String... items) {
    for (String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
  }
  public A removeAllFromResourceNames(Collection<String> items) {
    for (String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
  }
  public List<String> getResourceNames() {
    return this.resourceNames;
  }
  public String getResourceName(int index) {
    return this.resourceNames.get(index);
  }
  public String getFirstResourceName() {
    return this.resourceNames.get(0);
  }
  public String getLastResourceName() {
    return this.resourceNames.get(resourceNames.size() - 1);
  }
  public String getMatchingResourceName(Predicate<String> predicate) {
    for (String item: resourceNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingResourceName(Predicate<String> predicate) {
    for (String item: resourceNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceNames(List<String> resourceNames) {
    if (resourceNames != null) {this.resourceNames = new ArrayList(); for (String item : resourceNames){this.addToResourceNames(item);}} else { this.resourceNames = null;} return (A) this;
  }
  public A withResourceNames(java.lang.String... resourceNames) {
    if (this.resourceNames != null) {this.resourceNames.clear(); _visitables.remove("resourceNames"); }
    if (resourceNames != null) {for (String item :resourceNames){ this.addToResourceNames(item);}} return (A) this;
  }
  public Boolean hasResourceNames() {
    return resourceNames != null && !resourceNames.isEmpty();
  }
  public A addToResources(int index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.add(index, item);
    return (A)this;
  }
  public A setToResources(int index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.set(index, item); return (A)this;
  }
  public A addToResources(java.lang.String... items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A addAllToResources(Collection<String> items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A removeFromResources(java.lang.String... items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public A removeAllFromResources(Collection<String> items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public List<String> getResources() {
    return this.resources;
  }
  public String getResource(int index) {
    return this.resources.get(index);
  }
  public String getFirstResource() {
    return this.resources.get(0);
  }
  public String getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  public String getMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<String> resources) {
    if (resources != null) {this.resources = new ArrayList(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(java.lang.String... resources) {
    if (this.resources != null) {this.resources.clear(); _visitables.remove("resources"); }
    if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
  }
  public Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public A addToVerbs(int index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.add(index, item);
    return (A)this;
  }
  public A setToVerbs(int index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.set(index, item); return (A)this;
  }
  public A addToVerbs(java.lang.String... items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A addAllToVerbs(Collection<String> items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A removeFromVerbs(java.lang.String... items) {
    for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public A removeAllFromVerbs(Collection<String> items) {
    for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public List<String> getVerbs() {
    return this.verbs;
  }
  public String getVerb(int index) {
    return this.verbs.get(index);
  }
  public String getFirstVerb() {
    return this.verbs.get(0);
  }
  public String getLastVerb() {
    return this.verbs.get(verbs.size() - 1);
  }
  public String getMatchingVerb(Predicate<String> predicate) {
    for (String item: verbs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVerb(Predicate<String> predicate) {
    for (String item: verbs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerbs(List<String> verbs) {
    if (verbs != null) {this.verbs = new ArrayList(); for (String item : verbs){this.addToVerbs(item);}} else { this.verbs = null;} return (A) this;
  }
  public A withVerbs(java.lang.String... verbs) {
    if (this.verbs != null) {this.verbs.clear(); _visitables.remove("verbs"); }
    if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (A) this;
  }
  public Boolean hasVerbs() {
    return verbs != null && !verbs.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicyRuleFluentImpl that = (PolicyRuleFluentImpl) o;
    if (!java.util.Objects.equals(apiGroups, that.apiGroups)) return false;

    if (!java.util.Objects.equals(attributeRestrictions, that.attributeRestrictions)) return false;

    if (!java.util.Objects.equals(nonResourceURLs, that.nonResourceURLs)) return false;

    if (!java.util.Objects.equals(resourceNames, that.resourceNames)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(verbs, that.verbs)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiGroups,  attributeRestrictions,  nonResourceURLs,  resourceNames,  resources,  verbs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiGroups != null && !apiGroups.isEmpty()) { sb.append("apiGroups:"); sb.append(apiGroups + ","); }
    if (attributeRestrictions != null) { sb.append("attributeRestrictions:"); sb.append(attributeRestrictions + ","); }
    if (nonResourceURLs != null && !nonResourceURLs.isEmpty()) { sb.append("nonResourceURLs:"); sb.append(nonResourceURLs + ","); }
    if (resourceNames != null && !resourceNames.isEmpty()) { sb.append("resourceNames:"); sb.append(resourceNames + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (verbs != null && !verbs.isEmpty()) { sb.append("verbs:"); sb.append(verbs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class GenericWebHookCauseAttributeRestrictionsNestedImpl<N> extends GenericWebHookCauseFluentImpl<PolicyRuleFluentImpl.GenericWebHookCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GenericWebHookCauseAttributeRestrictionsNested<N>,Nested<N>{
    GenericWebHookCauseAttributeRestrictionsNestedImpl(GenericWebHookCause item) {
      this.builder = new GenericWebHookCauseBuilder(this, item);
    }
    GenericWebHookCauseAttributeRestrictionsNestedImpl() {
      this.builder = new GenericWebHookCauseBuilder(this);
    }
    GenericWebHookCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGenericWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class ServiceAccountRestrictionAttributeRestrictionsNestedImpl<N> extends ServiceAccountRestrictionFluentImpl<PolicyRuleFluentImpl.ServiceAccountRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ServiceAccountRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    ServiceAccountRestrictionAttributeRestrictionsNestedImpl(ServiceAccountRestriction item) {
      this.builder = new ServiceAccountRestrictionBuilder(this, item);
    }
    ServiceAccountRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new ServiceAccountRestrictionBuilder(this);
    }
    ServiceAccountRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endServiceAccountRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class ScopeRestrictionAttributeRestrictionsNestedImpl<N> extends ScopeRestrictionFluentImpl<PolicyRuleFluentImpl.ScopeRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ScopeRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    ScopeRestrictionAttributeRestrictionsNestedImpl(ScopeRestriction item) {
      this.builder = new ScopeRestrictionBuilder(this, item);
    }
    ScopeRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new ScopeRestrictionBuilder(this);
    }
    ScopeRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endScopeRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class SecretLocalReferenceAttributeRestrictionsNestedImpl<N> extends SecretLocalReferenceFluentImpl<PolicyRuleFluentImpl.SecretLocalReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SecretLocalReferenceAttributeRestrictionsNested<N>,Nested<N>{
    SecretLocalReferenceAttributeRestrictionsNestedImpl(SecretLocalReference item) {
      this.builder = new SecretLocalReferenceBuilder(this, item);
    }
    SecretLocalReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new SecretLocalReferenceBuilder(this);
    }
    SecretLocalReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecretLocalReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class StepInfoAttributeRestrictionsNestedImpl<N> extends StepInfoFluentImpl<PolicyRuleFluentImpl.StepInfoAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.StepInfoAttributeRestrictionsNested<N>,Nested<N>{
    StepInfoAttributeRestrictionsNestedImpl(StepInfo item) {
      this.builder = new StepInfoBuilder(this, item);
    }
    StepInfoAttributeRestrictionsNestedImpl() {
      this.builder = new StepInfoBuilder(this);
    }
    StepInfoBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endStepInfoAttributeRestrictions() {
      return and();
    }
    
  }
  class UserRestrictionAttributeRestrictionsNestedImpl<N> extends UserRestrictionFluentImpl<PolicyRuleFluentImpl.UserRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.UserRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    UserRestrictionAttributeRestrictionsNestedImpl(UserRestriction item) {
      this.builder = new UserRestrictionBuilder(this, item);
    }
    UserRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new UserRestrictionBuilder(this);
    }
    UserRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class PodTemplateSpecAttributeRestrictionsNestedImpl<N> extends PodTemplateSpecFluentImpl<PolicyRuleFluentImpl.PodTemplateSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodTemplateSpecAttributeRestrictionsNested<N>,Nested<N>{
    PodTemplateSpecAttributeRestrictionsNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecAttributeRestrictionsNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodTemplateSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceListAttributeRestrictionsNestedImpl<N> extends TemplateInstanceListFluentImpl<PolicyRuleFluentImpl.TemplateInstanceListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateInstanceListAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceListAttributeRestrictionsNestedImpl(TemplateInstanceList item) {
      this.builder = new TemplateInstanceListBuilder(this, item);
    }
    TemplateInstanceListAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceListBuilder(this);
    }
    TemplateInstanceListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceListAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImportAttributeRestrictionsNestedImpl<N> extends ImageStreamImportFluentImpl<PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImportAttributeRestrictionsNestedImpl(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImportBuilder(this);
    }
    ImageStreamImportBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportAttributeRestrictions() {
      return and();
    }
    
  }
  class ResourceRequirementsAttributeRestrictionsNestedImpl<N> extends ResourceRequirementsFluentImpl<PolicyRuleFluentImpl.ResourceRequirementsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ResourceRequirementsAttributeRestrictionsNested<N>,Nested<N>{
    ResourceRequirementsAttributeRestrictionsNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsAttributeRestrictionsNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endResourceRequirementsAttributeRestrictions() {
      return and();
    }
    
  }
  class GitHubWebHookCauseAttributeRestrictionsNestedImpl<N> extends GitHubWebHookCauseFluentImpl<PolicyRuleFluentImpl.GitHubWebHookCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GitHubWebHookCauseAttributeRestrictionsNested<N>,Nested<N>{
    GitHubWebHookCauseAttributeRestrictionsNestedImpl(GitHubWebHookCause item) {
      this.builder = new GitHubWebHookCauseBuilder(this, item);
    }
    GitHubWebHookCauseAttributeRestrictionsNestedImpl() {
      this.builder = new GitHubWebHookCauseBuilder(this);
    }
    GitHubWebHookCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGitHubWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientListAttributeRestrictionsNestedImpl<N> extends OAuthClientListFluentImpl<PolicyRuleFluentImpl.OAuthClientListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OAuthClientListAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientListAttributeRestrictionsNestedImpl(OAuthClientList item) {
      this.builder = new OAuthClientListBuilder(this, item);
    }
    OAuthClientListAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientListBuilder(this);
    }
    OAuthClientListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientListAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicyReviewStatusFluentImpl<PolicyRuleFluentImpl.PodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl(PodSecurityPolicyReviewStatus item) {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this, item);
    }
    PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this);
    }
    PodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicyReviewStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceStatusAttributeRestrictionsNestedImpl<N> extends TemplateInstanceStatusFluentImpl<PolicyRuleFluentImpl.TemplateInstanceStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateInstanceStatusAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceStatusAttributeRestrictionsNestedImpl(TemplateInstanceStatus item) {
      this.builder = new TemplateInstanceStatusBuilder(this, item);
    }
    TemplateInstanceStatusAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceStatusBuilder(this);
    }
    TemplateInstanceStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositoryListAttributeRestrictionsNestedImpl<N> extends HelmChartRepositoryListFluentImpl<PolicyRuleFluentImpl.HelmChartRepositoryListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.HelmChartRepositoryListAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositoryListAttributeRestrictionsNestedImpl(HelmChartRepositoryList item) {
      this.builder = new HelmChartRepositoryListBuilder(this, item);
    }
    HelmChartRepositoryListAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositoryListBuilder(this);
    }
    HelmChartRepositoryListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositoryListAttributeRestrictions() {
      return and();
    }
    
  }
  class PolicyRuleAttributeRestrictionsNestedImpl<N> extends PolicyRuleFluentImpl<PolicyRuleFluentImpl.PolicyRuleAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PolicyRuleAttributeRestrictionsNested<N>,Nested<N>{
    PolicyRuleAttributeRestrictionsNestedImpl(PolicyRule item) {
      this.builder = new PolicyRuleBuilder(this, item);
    }
    PolicyRuleAttributeRestrictionsNestedImpl() {
      this.builder = new PolicyRuleBuilder(this);
    }
    PolicyRuleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPolicyRuleAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentTriggerPolicyAttributeRestrictionsNestedImpl<N> extends DeploymentTriggerPolicyFluentImpl<PolicyRuleFluentImpl.DeploymentTriggerPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentTriggerPolicyAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentTriggerPolicyAttributeRestrictionsNestedImpl(DeploymentTriggerPolicy item) {
      this.builder = new DeploymentTriggerPolicyBuilder(this, item);
    }
    DeploymentTriggerPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentTriggerPolicyBuilder(this);
    }
    DeploymentTriggerPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentTriggerPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildStrategyAttributeRestrictionsNestedImpl<N> extends BuildStrategyFluentImpl<PolicyRuleFluentImpl.BuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    BuildStrategyAttributeRestrictionsNestedImpl(BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    BuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new BuildStrategyBuilder(this);
    }
    BuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class RepositoryImportSpecAttributeRestrictionsNestedImpl<N> extends RepositoryImportSpecFluentImpl<PolicyRuleFluentImpl.RepositoryImportSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RepositoryImportSpecAttributeRestrictionsNested<N>,Nested<N>{
    RepositoryImportSpecAttributeRestrictionsNestedImpl(RepositoryImportSpec item) {
      this.builder = new RepositoryImportSpecBuilder(this, item);
    }
    RepositoryImportSpecAttributeRestrictionsNestedImpl() {
      this.builder = new RepositoryImportSpecBuilder(this);
    }
    RepositoryImportSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRepositoryImportSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceListAttributeRestrictionsNestedImpl<N> extends BrokerTemplateInstanceListFluentImpl<PolicyRuleFluentImpl.BrokerTemplateInstanceListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BrokerTemplateInstanceListAttributeRestrictionsNested<N>,Nested<N>{
    BrokerTemplateInstanceListAttributeRestrictionsNestedImpl(BrokerTemplateInstanceList item) {
      this.builder = new BrokerTemplateInstanceListBuilder(this, item);
    }
    BrokerTemplateInstanceListAttributeRestrictionsNestedImpl() {
      this.builder = new BrokerTemplateInstanceListBuilder(this);
    }
    BrokerTemplateInstanceListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBrokerTemplateInstanceListAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImportStatusAttributeRestrictionsNestedImpl<N> extends ImageStreamImportStatusFluentImpl<PolicyRuleFluentImpl.ImageStreamImportStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamImportStatusAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImportStatusAttributeRestrictionsNestedImpl(ImageStreamImportStatus item) {
      this.builder = new ImageStreamImportStatusBuilder(this, item);
    }
    ImageStreamImportStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImportStatusBuilder(this);
    }
    ImageStreamImportStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class CustomBuildStrategyAttributeRestrictionsNestedImpl<N> extends CustomBuildStrategyFluentImpl<PolicyRuleFluentImpl.CustomBuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.CustomBuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    CustomBuildStrategyAttributeRestrictionsNestedImpl(CustomBuildStrategy item) {
      this.builder = new CustomBuildStrategyBuilder(this, item);
    }
    CustomBuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new CustomBuildStrategyBuilder(this);
    }
    CustomBuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endCustomBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaSelectorFluentImpl<PolicyRuleFluentImpl.ClusterResourceQuotaSelectorAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterResourceQuotaSelectorAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl(ClusterResourceQuotaSelector item) {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this, item);
    }
    ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this);
    }
    ClusterResourceQuotaSelectorBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaSelectorAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectAccessReviewResponseAttributeRestrictionsNestedImpl<N> extends SubjectAccessReviewResponseFluentImpl<PolicyRuleFluentImpl.SubjectAccessReviewResponseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SubjectAccessReviewResponseAttributeRestrictionsNested<N>,Nested<N>{
    SubjectAccessReviewResponseAttributeRestrictionsNestedImpl(SubjectAccessReviewResponse item) {
      this.builder = new SubjectAccessReviewResponseBuilder(this, item);
    }
    SubjectAccessReviewResponseAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectAccessReviewResponseBuilder(this);
    }
    SubjectAccessReviewResponseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectAccessReviewResponseAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl<N> extends DeploymentTriggerImageChangeParamsFluentImpl<PolicyRuleFluentImpl.DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl(DeploymentTriggerImageChangeParams item) {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
    }
    DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this);
    }
    DeploymentTriggerImageChangeParamsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentTriggerImageChangeParamsAttributeRestrictions() {
      return and();
    }
    
  }
  class LocalObjectReferenceAttributeRestrictionsNestedImpl<N> extends LocalObjectReferenceFluentImpl<PolicyRuleFluentImpl.LocalObjectReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.LocalObjectReferenceAttributeRestrictionsNested<N>,Nested<N>{
    LocalObjectReferenceAttributeRestrictionsNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLocalObjectReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class TagImageHookAttributeRestrictionsNestedImpl<N> extends TagImageHookFluentImpl<PolicyRuleFluentImpl.TagImageHookAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TagImageHookAttributeRestrictionsNested<N>,Nested<N>{
    TagImageHookAttributeRestrictionsNestedImpl(TagImageHook item) {
      this.builder = new TagImageHookBuilder(this, item);
    }
    TagImageHookAttributeRestrictionsNestedImpl() {
      this.builder = new TagImageHookBuilder(this);
    }
    TagImageHookBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagImageHookAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteTargetReferenceAttributeRestrictionsNestedImpl<N> extends RouteTargetReferenceFluentImpl<PolicyRuleFluentImpl.RouteTargetReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RouteTargetReferenceAttributeRestrictionsNested<N>,Nested<N>{
    RouteTargetReferenceAttributeRestrictionsNestedImpl(RouteTargetReference item) {
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    RouteTargetReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new RouteTargetReferenceBuilder(this);
    }
    RouteTargetReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteTargetReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class OpenshiftRawExtensionAttributeRestrictionsNestedImpl<N> extends io.fabric8.openshift.api.model.runtime.RawExtensionFluentImpl<PolicyRuleFluentImpl.OpenshiftRawExtensionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OpenshiftRawExtensionAttributeRestrictionsNested<N>,Nested<N>{
    OpenshiftRawExtensionAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.runtime.RawExtension item) {
      this.builder = new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(this, item);
    }
    OpenshiftRawExtensionAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(this);
    }
    io.fabric8.openshift.api.model.runtime.RawExtensionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOpenshiftRawExtensionAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectRulesReviewSpecAttributeRestrictionsNestedImpl<N> extends SubjectRulesReviewSpecFluentImpl<PolicyRuleFluentImpl.SubjectRulesReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SubjectRulesReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    SubjectRulesReviewSpecAttributeRestrictionsNestedImpl(SubjectRulesReviewSpec item) {
      this.builder = new SubjectRulesReviewSpecBuilder(this, item);
    }
    SubjectRulesReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectRulesReviewSpecBuilder(this);
    }
    SubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectRulesReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class TagReferencePolicyAttributeRestrictionsNestedImpl<N> extends TagReferencePolicyFluentImpl<PolicyRuleFluentImpl.TagReferencePolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TagReferencePolicyAttributeRestrictionsNested<N>,Nested<N>{
    TagReferencePolicyAttributeRestrictionsNestedImpl(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    TagReferencePolicyAttributeRestrictionsNestedImpl() {
      this.builder = new TagReferencePolicyBuilder(this);
    }
    TagReferencePolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagReferencePolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleListAttributeRestrictionsNestedImpl<N> extends RoleListFluentImpl<PolicyRuleFluentImpl.RoleListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RoleListAttributeRestrictionsNested<N>,Nested<N>{
    RoleListAttributeRestrictionsNestedImpl(RoleList item) {
      this.builder = new RoleListBuilder(this, item);
    }
    RoleListAttributeRestrictionsNestedImpl() {
      this.builder = new RoleListBuilder(this);
    }
    RoleListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleListAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectAttributeRestrictionsNestedImpl<N> extends ProjectFluentImpl<PolicyRuleFluentImpl.ProjectAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ProjectAttributeRestrictionsNested<N>,Nested<N>{
    ProjectAttributeRestrictionsNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectBuilder(this);
    }
    ProjectBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildVolumeSourceAttributeRestrictionsNestedImpl<N> extends BuildVolumeSourceFluentImpl<PolicyRuleFluentImpl.BuildVolumeSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildVolumeSourceAttributeRestrictionsNested<N>,Nested<N>{
    BuildVolumeSourceAttributeRestrictionsNestedImpl(BuildVolumeSource item) {
      this.builder = new BuildVolumeSourceBuilder(this, item);
    }
    BuildVolumeSourceAttributeRestrictionsNestedImpl() {
      this.builder = new BuildVolumeSourceBuilder(this);
    }
    BuildVolumeSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildVolumeSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl<N> extends AppliedClusterResourceQuotaListFluentImpl<PolicyRuleFluentImpl.AppliedClusterResourceQuotaListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.AppliedClusterResourceQuotaListAttributeRestrictionsNested<N>,Nested<N>{
    AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl(AppliedClusterResourceQuotaList item) {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this, item);
    }
    AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this);
    }
    AppliedClusterResourceQuotaListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAppliedClusterResourceQuotaListAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigListAttributeRestrictionsNestedImpl<N> extends DeploymentConfigListFluentImpl<PolicyRuleFluentImpl.DeploymentConfigListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentConfigListAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigListAttributeRestrictionsNestedImpl(DeploymentConfigList item) {
      this.builder = new DeploymentConfigListBuilder(this, item);
    }
    DeploymentConfigListAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigListBuilder(this);
    }
    DeploymentConfigListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildStatusOutputAttributeRestrictionsNestedImpl<N> extends BuildStatusOutputFluentImpl<PolicyRuleFluentImpl.BuildStatusOutputAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildStatusOutputAttributeRestrictionsNested<N>,Nested<N>{
    BuildStatusOutputAttributeRestrictionsNestedImpl(BuildStatusOutput item) {
      this.builder = new BuildStatusOutputBuilder(this, item);
    }
    BuildStatusOutputAttributeRestrictionsNestedImpl() {
      this.builder = new BuildStatusOutputBuilder(this);
    }
    BuildStatusOutputBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildStatusOutputAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigAttributeRestrictionsNestedImpl<N> extends BuildConfigFluentImpl<PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigAttributeRestrictionsNestedImpl(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigBuilder(this);
    }
    BuildConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageImportStatusAttributeRestrictionsNestedImpl<N> extends ImageImportStatusFluentImpl<PolicyRuleFluentImpl.ImageImportStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageImportStatusAttributeRestrictionsNested<N>,Nested<N>{
    ImageImportStatusAttributeRestrictionsNestedImpl(ImageImportStatus item) {
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImageImportStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ImageImportStatusBuilder(this);
    }
    ImageImportStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageImportStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySubjectReviewFluentImpl<PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl(PodSecurityPolicySubjectReview item) {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this);
    }
    PodSecurityPolicySubjectReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class GitLabWebHookCauseAttributeRestrictionsNestedImpl<N> extends GitLabWebHookCauseFluentImpl<PolicyRuleFluentImpl.GitLabWebHookCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GitLabWebHookCauseAttributeRestrictionsNested<N>,Nested<N>{
    GitLabWebHookCauseAttributeRestrictionsNestedImpl(GitLabWebHookCause item) {
      this.builder = new GitLabWebHookCauseBuilder(this, item);
    }
    GitLabWebHookCauseAttributeRestrictionsNestedImpl() {
      this.builder = new GitLabWebHookCauseBuilder(this);
    }
    GitLabWebHookCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGitLabWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigStatusAttributeRestrictionsNestedImpl<N> extends DeploymentConfigStatusFluentImpl<PolicyRuleFluentImpl.DeploymentConfigStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentConfigStatusAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigStatusAttributeRestrictionsNestedImpl(DeploymentConfigStatus item) {
      this.builder = new DeploymentConfigStatusBuilder(this, item);
    }
    DeploymentConfigStatusAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigStatusBuilder(this);
    }
    DeploymentConfigStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class SecretBuildSourceAttributeRestrictionsNestedImpl<N> extends SecretBuildSourceFluentImpl<PolicyRuleFluentImpl.SecretBuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SecretBuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    SecretBuildSourceAttributeRestrictionsNestedImpl(SecretBuildSource item) {
      this.builder = new SecretBuildSourceBuilder(this, item);
    }
    SecretBuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new SecretBuildSourceBuilder(this);
    }
    SecretBuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecretBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicySpecAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicySpecFluentImpl<PolicyRuleFluentImpl.EgressNetworkPolicySpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.EgressNetworkPolicySpecAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicySpecAttributeRestrictionsNestedImpl(EgressNetworkPolicySpec item) {
      this.builder = new EgressNetworkPolicySpecBuilder(this, item);
    }
    EgressNetworkPolicySpecAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicySpecBuilder(this);
    }
    EgressNetworkPolicySpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicySpecAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositoryAttributeRestrictionsNestedImpl<N> extends HelmChartRepositoryFluentImpl<PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositoryAttributeRestrictionsNestedImpl(HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositoryBuilder(this);
    }
    HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositoryAttributeRestrictions() {
      return and();
    }
    
  }
  class TagEventAttributeRestrictionsNestedImpl<N> extends TagEventFluentImpl<PolicyRuleFluentImpl.TagEventAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TagEventAttributeRestrictionsNested<N>,Nested<N>{
    TagEventAttributeRestrictionsNestedImpl(TagEvent item) {
      this.builder = new TagEventBuilder(this, item);
    }
    TagEventAttributeRestrictionsNestedImpl() {
      this.builder = new TagEventBuilder(this);
    }
    TagEventBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagEventAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamTagListAttributeRestrictionsNestedImpl<N> extends ImageStreamTagListFluentImpl<PolicyRuleFluentImpl.ImageStreamTagListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamTagListAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamTagListAttributeRestrictionsNestedImpl(ImageStreamTagList item) {
      this.builder = new ImageStreamTagListBuilder(this, item);
    }
    ImageStreamTagListAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamTagListBuilder(this);
    }
    ImageStreamTagListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagListAttributeRestrictions() {
      return and();
    }
    
  }
  class BitbucketWebHookCauseAttributeRestrictionsNestedImpl<N> extends BitbucketWebHookCauseFluentImpl<PolicyRuleFluentImpl.BitbucketWebHookCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BitbucketWebHookCauseAttributeRestrictionsNested<N>,Nested<N>{
    BitbucketWebHookCauseAttributeRestrictionsNestedImpl(BitbucketWebHookCause item) {
      this.builder = new BitbucketWebHookCauseBuilder(this, item);
    }
    BitbucketWebHookCauseAttributeRestrictionsNestedImpl() {
      this.builder = new BitbucketWebHookCauseBuilder(this);
    }
    BitbucketWebHookCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBitbucketWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectListAttributeRestrictionsNestedImpl<N> extends ProjectListFluentImpl<PolicyRuleFluentImpl.ProjectListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ProjectListAttributeRestrictionsNested<N>,Nested<N>{
    ProjectListAttributeRestrictionsNestedImpl(ProjectList item) {
      this.builder = new ProjectListBuilder(this, item);
    }
    ProjectListAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectListBuilder(this);
    }
    ProjectListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectListAttributeRestrictions() {
      return and();
    }
    
  }
  class RangeAllocationAttributeRestrictionsNestedImpl<N> extends RangeAllocationFluentImpl<PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNested<N>,Nested<N>{
    RangeAllocationAttributeRestrictionsNestedImpl(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationAttributeRestrictionsNestedImpl() {
      this.builder = new RangeAllocationBuilder(this);
    }
    RangeAllocationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRangeAllocationAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl<N> extends ClusterRoleScopeRestrictionFluentImpl<PolicyRuleFluentImpl.ClusterRoleScopeRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterRoleScopeRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl(ClusterRoleScopeRestriction item) {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
    }
    ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this);
    }
    ClusterRoleScopeRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleScopeRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteAttributeRestrictionsNestedImpl<N> extends RouteFluentImpl<PolicyRuleFluentImpl.RouteAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RouteAttributeRestrictionsNested<N>,Nested<N>{
    RouteAttributeRestrictionsNestedImpl(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteAttributeRestrictionsNestedImpl() {
      this.builder = new RouteBuilder(this);
    }
    RouteBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteAttributeRestrictions() {
      return and();
    }
    
  }
  class SourceStrategyOptionsAttributeRestrictionsNestedImpl<N> extends SourceStrategyOptionsFluentImpl<PolicyRuleFluentImpl.SourceStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SourceStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    SourceStrategyOptionsAttributeRestrictionsNestedImpl(SourceStrategyOptions item) {
      this.builder = new SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new SourceStrategyOptionsBuilder(this);
    }
    SourceStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSourceStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterNetworkAttributeRestrictionsNestedImpl<N> extends ClusterNetworkFluentImpl<PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNested<N>,Nested<N>{
    ClusterNetworkAttributeRestrictionsNestedImpl(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterNetworkBuilder(this);
    }
    ClusterNetworkBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterNetworkAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenAttributeRestrictionsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAuthorizeTokenBuilder(this);
    }
    OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAuthorizeTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class DockerBuildStrategyAttributeRestrictionsNestedImpl<N> extends DockerBuildStrategyFluentImpl<PolicyRuleFluentImpl.DockerBuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DockerBuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    DockerBuildStrategyAttributeRestrictionsNestedImpl(DockerBuildStrategy item) {
      this.builder = new DockerBuildStrategyBuilder(this, item);
    }
    DockerBuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new DockerBuildStrategyBuilder(this);
    }
    DockerBuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDockerBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class SignatureConditionAttributeRestrictionsNestedImpl<N> extends SignatureConditionFluentImpl<PolicyRuleFluentImpl.SignatureConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SignatureConditionAttributeRestrictionsNested<N>,Nested<N>{
    SignatureConditionAttributeRestrictionsNestedImpl(SignatureCondition item) {
      this.builder = new SignatureConditionBuilder(this, item);
    }
    SignatureConditionAttributeRestrictionsNestedImpl() {
      this.builder = new SignatureConditionBuilder(this);
    }
    SignatureConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSignatureConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNested<N>,Nested<N>{
    UserOAuthAccessTokenAttributeRestrictionsNestedImpl(UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenAttributeRestrictionsNestedImpl() {
      this.builder = new UserOAuthAccessTokenBuilder(this);
    }
    UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingRestrictionListAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionListFluentImpl<PolicyRuleFluentImpl.RoleBindingRestrictionListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RoleBindingRestrictionListAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingRestrictionListAttributeRestrictionsNestedImpl(RoleBindingRestrictionList item) {
      this.builder = new RoleBindingRestrictionListBuilder(this, item);
    }
    RoleBindingRestrictionListAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingRestrictionListBuilder(this);
    }
    RoleBindingRestrictionListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionListAttributeRestrictions() {
      return and();
    }
    
  }
  class RawExtensionAttributeRestrictionsNestedImpl<N> extends RawExtensionFluentImpl<PolicyRuleFluentImpl.RawExtensionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RawExtensionAttributeRestrictionsNested<N>,Nested<N>{
    RawExtensionAttributeRestrictionsNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionAttributeRestrictionsNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRawExtensionAttributeRestrictions() {
      return and();
    }
    
  }
  class SecurityContextConstraintsListAttributeRestrictionsNestedImpl<N> extends SecurityContextConstraintsListFluentImpl<PolicyRuleFluentImpl.SecurityContextConstraintsListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SecurityContextConstraintsListAttributeRestrictionsNested<N>,Nested<N>{
    SecurityContextConstraintsListAttributeRestrictionsNestedImpl(SecurityContextConstraintsList item) {
      this.builder = new SecurityContextConstraintsListBuilder(this, item);
    }
    SecurityContextConstraintsListAttributeRestrictionsNestedImpl() {
      this.builder = new SecurityContextConstraintsListBuilder(this);
    }
    SecurityContextConstraintsListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecurityContextConstraintsListAttributeRestrictions() {
      return and();
    }
    
  }
  class IdentityListAttributeRestrictionsNestedImpl<N> extends IdentityListFluentImpl<PolicyRuleFluentImpl.IdentityListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.IdentityListAttributeRestrictionsNested<N>,Nested<N>{
    IdentityListAttributeRestrictionsNestedImpl(IdentityList item) {
      this.builder = new IdentityListBuilder(this, item);
    }
    IdentityListAttributeRestrictionsNestedImpl() {
      this.builder = new IdentityListBuilder(this);
    }
    IdentityListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIdentityListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigListAttributeRestrictionsNestedImpl<N> extends BuildConfigListFluentImpl<PolicyRuleFluentImpl.BuildConfigListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildConfigListAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigListAttributeRestrictionsNestedImpl(BuildConfigList item) {
      this.builder = new BuildConfigListBuilder(this, item);
    }
    BuildConfigListAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigListBuilder(this);
    }
    BuildConfigListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigListAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterNetworkListAttributeRestrictionsNestedImpl<N> extends ClusterNetworkListFluentImpl<PolicyRuleFluentImpl.ClusterNetworkListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterNetworkListAttributeRestrictionsNested<N>,Nested<N>{
    ClusterNetworkListAttributeRestrictionsNestedImpl(ClusterNetworkList item) {
      this.builder = new ClusterNetworkListBuilder(this, item);
    }
    ClusterNetworkListAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterNetworkListBuilder(this);
    }
    ClusterNetworkListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterNetworkListAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceConditionAttributeRestrictionsNestedImpl<N> extends TemplateInstanceConditionFluentImpl<PolicyRuleFluentImpl.TemplateInstanceConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateInstanceConditionAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceConditionAttributeRestrictionsNestedImpl(TemplateInstanceCondition item) {
      this.builder = new TemplateInstanceConditionBuilder(this, item);
    }
    TemplateInstanceConditionAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceConditionBuilder(this);
    }
    TemplateInstanceConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class RepositoryImportStatusAttributeRestrictionsNestedImpl<N> extends RepositoryImportStatusFluentImpl<PolicyRuleFluentImpl.RepositoryImportStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RepositoryImportStatusAttributeRestrictionsNested<N>,Nested<N>{
    RepositoryImportStatusAttributeRestrictionsNestedImpl(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryImportStatusAttributeRestrictionsNestedImpl() {
      this.builder = new RepositoryImportStatusBuilder(this);
    }
    RepositoryImportStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRepositoryImportStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentCauseAttributeRestrictionsNestedImpl<N> extends DeploymentCauseFluentImpl<PolicyRuleFluentImpl.DeploymentCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentCauseAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentCauseAttributeRestrictionsNestedImpl(DeploymentCause item) {
      this.builder = new DeploymentCauseBuilder(this, item);
    }
    DeploymentCauseAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentCauseBuilder(this);
    }
    DeploymentCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class GroupListAttributeRestrictionsNestedImpl<N> extends GroupListFluentImpl<PolicyRuleFluentImpl.GroupListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GroupListAttributeRestrictionsNested<N>,Nested<N>{
    GroupListAttributeRestrictionsNestedImpl(GroupList item) {
      this.builder = new GroupListBuilder(this, item);
    }
    GroupListAttributeRestrictionsNestedImpl() {
      this.builder = new GroupListBuilder(this);
    }
    GroupListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupListAttributeRestrictions() {
      return and();
    }
    
  }
  class RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<PolicyRuleFluentImpl.RunAsUserStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RunAsUserStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl(RunAsUserStrategyOptions item) {
      this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new RunAsUserStrategyOptionsBuilder(this);
    }
    RunAsUserStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRunAsUserStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class LifecycleHookAttributeRestrictionsNestedImpl<N> extends LifecycleHookFluentImpl<PolicyRuleFluentImpl.LifecycleHookAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.LifecycleHookAttributeRestrictionsNested<N>,Nested<N>{
    LifecycleHookAttributeRestrictionsNestedImpl(LifecycleHook item) {
      this.builder = new LifecycleHookBuilder(this, item);
    }
    LifecycleHookAttributeRestrictionsNestedImpl() {
      this.builder = new LifecycleHookBuilder(this);
    }
    LifecycleHookBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLifecycleHookAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamTagReferenceAttributeRestrictionsNestedImpl<N> extends ImageStreamTagReferenceFluentImpl<PolicyRuleFluentImpl.ImageStreamTagReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamTagReferenceAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamTagReferenceAttributeRestrictionsNestedImpl(ImageStreamTagReference item) {
      this.builder = new ImageStreamTagReferenceBuilder(this, item);
    }
    ImageStreamTagReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamTagReferenceBuilder(this);
    }
    ImageStreamTagReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class SourceControlUserAttributeRestrictionsNestedImpl<N> extends SourceControlUserFluentImpl<PolicyRuleFluentImpl.SourceControlUserAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SourceControlUserAttributeRestrictionsNested<N>,Nested<N>{
    SourceControlUserAttributeRestrictionsNestedImpl(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    SourceControlUserAttributeRestrictionsNestedImpl() {
      this.builder = new SourceControlUserBuilder(this);
    }
    SourceControlUserBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSourceControlUserAttributeRestrictions() {
      return and();
    }
    
  }
  class ContainerAttributeRestrictionsNestedImpl<N> extends ContainerFluentImpl<PolicyRuleFluentImpl.ContainerAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ContainerAttributeRestrictionsNested<N>,Nested<N>{
    ContainerAttributeRestrictionsNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerAttributeRestrictionsNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endContainerAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamListAttributeRestrictionsNestedImpl<N> extends ImageStreamListFluentImpl<PolicyRuleFluentImpl.ImageStreamListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamListAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamListAttributeRestrictionsNestedImpl(ImageStreamList item) {
      this.builder = new ImageStreamListBuilder(this, item);
    }
    ImageStreamListAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamListBuilder(this);
    }
    ImageStreamListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamListAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleBindingAttributeRestrictionsNestedImpl<N> extends ClusterRoleBindingFluentImpl<PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleBindingAttributeRestrictionsNestedImpl(ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleBindingBuilder(this);
    }
    ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleBindingAttributeRestrictions() {
      return and();
    }
    
  }
  class ResourceAccessReviewAttributeRestrictionsNestedImpl<N> extends ResourceAccessReviewFluentImpl<PolicyRuleFluentImpl.ResourceAccessReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ResourceAccessReviewAttributeRestrictionsNested<N>,Nested<N>{
    ResourceAccessReviewAttributeRestrictionsNestedImpl(ResourceAccessReview item) {
      this.builder = new ResourceAccessReviewBuilder(this, item);
    }
    ResourceAccessReviewAttributeRestrictionsNestedImpl() {
      this.builder = new ResourceAccessReviewBuilder(this);
    }
    ResourceAccessReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endResourceAccessReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class SelfSubjectRulesReviewAttributeRestrictionsNestedImpl<N> extends SelfSubjectRulesReviewFluentImpl<PolicyRuleFluentImpl.SelfSubjectRulesReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SelfSubjectRulesReviewAttributeRestrictionsNested<N>,Nested<N>{
    SelfSubjectRulesReviewAttributeRestrictionsNestedImpl(SelfSubjectRulesReview item) {
      this.builder = new SelfSubjectRulesReviewBuilder(this, item);
    }
    SelfSubjectRulesReviewAttributeRestrictionsNestedImpl() {
      this.builder = new SelfSubjectRulesReviewBuilder(this);
    }
    SelfSubjectRulesReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSelfSubjectRulesReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenListAttributeRestrictionsNestedImpl<N> extends UserOAuthAccessTokenListFluentImpl<PolicyRuleFluentImpl.UserOAuthAccessTokenListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.UserOAuthAccessTokenListAttributeRestrictionsNested<N>,Nested<N>{
    UserOAuthAccessTokenListAttributeRestrictionsNestedImpl(UserOAuthAccessTokenList item) {
      this.builder = new UserOAuthAccessTokenListBuilder(this, item);
    }
    UserOAuthAccessTokenListAttributeRestrictionsNestedImpl() {
      this.builder = new UserOAuthAccessTokenListBuilder(this);
    }
    UserOAuthAccessTokenListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserOAuthAccessTokenListAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageChangeTriggerStatusAttributeRestrictionsNestedImpl<N> extends ImageChangeTriggerStatusFluentImpl<PolicyRuleFluentImpl.ImageChangeTriggerStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageChangeTriggerStatusAttributeRestrictionsNested<N>,Nested<N>{
    ImageChangeTriggerStatusAttributeRestrictionsNestedImpl(ImageChangeTriggerStatus item) {
      this.builder = new ImageChangeTriggerStatusBuilder(this, item);
    }
    ImageChangeTriggerStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ImageChangeTriggerStatusBuilder(this);
    }
    ImageChangeTriggerStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageChangeTriggerStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteStatusAttributeRestrictionsNestedImpl<N> extends RouteStatusFluentImpl<PolicyRuleFluentImpl.RouteStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RouteStatusAttributeRestrictionsNested<N>,Nested<N>{
    RouteStatusAttributeRestrictionsNestedImpl(RouteStatus item) {
      this.builder = new RouteStatusBuilder(this, item);
    }
    RouteStatusAttributeRestrictionsNestedImpl() {
      this.builder = new RouteStatusBuilder(this);
    }
    RouteStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaFluentImpl<PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaAttributeRestrictionsNestedImpl(ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaBuilder(this);
    }
    ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  }
  class NamedTagEventListAttributeRestrictionsNestedImpl<N> extends NamedTagEventListFluentImpl<PolicyRuleFluentImpl.NamedTagEventListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.NamedTagEventListAttributeRestrictionsNested<N>,Nested<N>{
    NamedTagEventListAttributeRestrictionsNestedImpl(NamedTagEventList item) {
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    NamedTagEventListAttributeRestrictionsNestedImpl() {
      this.builder = new NamedTagEventListBuilder(this);
    }
    NamedTagEventListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNamedTagEventListAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaListAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaListFluentImpl<PolicyRuleFluentImpl.ClusterResourceQuotaListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterResourceQuotaListAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaListAttributeRestrictionsNestedImpl(ClusterResourceQuotaList item) {
      this.builder = new ClusterResourceQuotaListBuilder(this, item);
    }
    ClusterResourceQuotaListAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaListBuilder(this);
    }
    ClusterResourceQuotaListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaListAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteSpecAttributeRestrictionsNestedImpl<N> extends RouteSpecFluentImpl<PolicyRuleFluentImpl.RouteSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RouteSpecAttributeRestrictionsNested<N>,Nested<N>{
    RouteSpecAttributeRestrictionsNestedImpl(RouteSpec item) {
      this.builder = new RouteSpecBuilder(this, item);
    }
    RouteSpecAttributeRestrictionsNestedImpl() {
      this.builder = new RouteSpecBuilder(this);
    }
    RouteSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectRequestAttributeRestrictionsNestedImpl<N> extends ProjectRequestFluentImpl<PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNested<N>,Nested<N>{
    ProjectRequestAttributeRestrictionsNestedImpl(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectRequestBuilder(this);
    }
    ProjectRequestBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectRequestAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateAttributeRestrictionsNestedImpl<N> extends TemplateFluentImpl<PolicyRuleFluentImpl.TemplateAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateAttributeRestrictionsNested<N>,Nested<N>{
    TemplateAttributeRestrictionsNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageLookupPolicyAttributeRestrictionsNestedImpl<N> extends ImageLookupPolicyFluentImpl<PolicyRuleFluentImpl.ImageLookupPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageLookupPolicyAttributeRestrictionsNested<N>,Nested<N>{
    ImageLookupPolicyAttributeRestrictionsNestedImpl(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    ImageLookupPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new ImageLookupPolicyBuilder(this);
    }
    ImageLookupPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageLookupPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationAttributeRestrictionsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientAuthorizationAttributeRestrictionsNestedImpl(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientAuthorizationBuilder(this);
    }
    OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAuthorizationAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageChangeCauseAttributeRestrictionsNestedImpl<N> extends ImageChangeCauseFluentImpl<PolicyRuleFluentImpl.ImageChangeCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageChangeCauseAttributeRestrictionsNested<N>,Nested<N>{
    ImageChangeCauseAttributeRestrictionsNestedImpl(ImageChangeCause item) {
      this.builder = new ImageChangeCauseBuilder(this, item);
    }
    ImageChangeCauseAttributeRestrictionsNestedImpl() {
      this.builder = new ImageChangeCauseBuilder(this);
    }
    ImageChangeCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageChangeCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class AllowedFlexVolumeAttributeRestrictionsNestedImpl<N> extends AllowedFlexVolumeFluentImpl<PolicyRuleFluentImpl.AllowedFlexVolumeAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.AllowedFlexVolumeAttributeRestrictionsNested<N>,Nested<N>{
    AllowedFlexVolumeAttributeRestrictionsNestedImpl(AllowedFlexVolume item) {
      this.builder = new AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumeAttributeRestrictionsNestedImpl() {
      this.builder = new AllowedFlexVolumeBuilder(this);
    }
    AllowedFlexVolumeBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAllowedFlexVolumeAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectAccessReviewAttributeRestrictionsNestedImpl<N> extends SubjectAccessReviewFluentImpl<PolicyRuleFluentImpl.SubjectAccessReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SubjectAccessReviewAttributeRestrictionsNested<N>,Nested<N>{
    SubjectAccessReviewAttributeRestrictionsNestedImpl(SubjectAccessReview item) {
      this.builder = new SubjectAccessReviewBuilder(this, item);
    }
    SubjectAccessReviewAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectAccessReviewBuilder(this);
    }
    SubjectAccessReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectAccessReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class LocalResourceAccessReviewAttributeRestrictionsNestedImpl<N> extends LocalResourceAccessReviewFluentImpl<PolicyRuleFluentImpl.LocalResourceAccessReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.LocalResourceAccessReviewAttributeRestrictionsNested<N>,Nested<N>{
    LocalResourceAccessReviewAttributeRestrictionsNestedImpl(LocalResourceAccessReview item) {
      this.builder = new LocalResourceAccessReviewBuilder(this, item);
    }
    LocalResourceAccessReviewAttributeRestrictionsNestedImpl() {
      this.builder = new LocalResourceAccessReviewBuilder(this);
    }
    LocalResourceAccessReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLocalResourceAccessReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleAttributeRestrictionsNestedImpl<N> extends ClusterRoleFluentImpl<PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleAttributeRestrictionsNestedImpl(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleBuilder(this);
    }
    ClusterRoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleAttributeRestrictions() {
      return and();
    }
    
  }
  class ConnectionConfigAttributeRestrictionsNestedImpl<N> extends ConnectionConfigFluentImpl<PolicyRuleFluentImpl.ConnectionConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ConnectionConfigAttributeRestrictionsNested<N>,Nested<N>{
    ConnectionConfigAttributeRestrictionsNestedImpl(ConnectionConfig item) {
      this.builder = new ConnectionConfigBuilder(this, item);
    }
    ConnectionConfigAttributeRestrictionsNestedImpl() {
      this.builder = new ConnectionConfigBuilder(this);
    }
    ConnectionConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endConnectionConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class TagEventConditionAttributeRestrictionsNestedImpl<N> extends TagEventConditionFluentImpl<PolicyRuleFluentImpl.TagEventConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TagEventConditionAttributeRestrictionsNested<N>,Nested<N>{
    TagEventConditionAttributeRestrictionsNestedImpl(TagEventCondition item) {
      this.builder = new TagEventConditionBuilder(this, item);
    }
    TagEventConditionAttributeRestrictionsNestedImpl() {
      this.builder = new TagEventConditionBuilder(this);
    }
    TagEventConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagEventConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class LabelSelectorAttributeRestrictionsNestedImpl<N> extends LabelSelectorFluentImpl<PolicyRuleFluentImpl.LabelSelectorAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.LabelSelectorAttributeRestrictionsNested<N>,Nested<N>{
    LabelSelectorAttributeRestrictionsNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorAttributeRestrictionsNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLabelSelectorAttributeRestrictions() {
      return and();
    }
    
  }
  class NetNamespaceListAttributeRestrictionsNestedImpl<N> extends NetNamespaceListFluentImpl<PolicyRuleFluentImpl.NetNamespaceListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.NetNamespaceListAttributeRestrictionsNested<N>,Nested<N>{
    NetNamespaceListAttributeRestrictionsNestedImpl(NetNamespaceList item) {
      this.builder = new NetNamespaceListBuilder(this, item);
    }
    NetNamespaceListAttributeRestrictionsNestedImpl() {
      this.builder = new NetNamespaceListBuilder(this);
    }
    NetNamespaceListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNetNamespaceListAttributeRestrictions() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl<N> extends BrokerTemplateInstanceSpecFluentImpl<PolicyRuleFluentImpl.BrokerTemplateInstanceSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BrokerTemplateInstanceSpecAttributeRestrictionsNested<N>,Nested<N>{
    BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl(BrokerTemplateInstanceSpec item) {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this, item);
    }
    BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl() {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this);
    }
    BrokerTemplateInstanceSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBrokerTemplateInstanceSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class BinaryBuildSourceAttributeRestrictionsNestedImpl<N> extends BinaryBuildSourceFluentImpl<PolicyRuleFluentImpl.BinaryBuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BinaryBuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    BinaryBuildSourceAttributeRestrictionsNestedImpl(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryBuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new BinaryBuildSourceBuilder(this);
    }
    BinaryBuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBinaryBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationListAttributeRestrictionsNestedImpl<N> extends OAuthClientAuthorizationListFluentImpl<PolicyRuleFluentImpl.OAuthClientAuthorizationListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OAuthClientAuthorizationListAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientAuthorizationListAttributeRestrictionsNestedImpl(OAuthClientAuthorizationList item) {
      this.builder = new OAuthClientAuthorizationListBuilder(this, item);
    }
    OAuthClientAuthorizationListAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientAuthorizationListBuilder(this);
    }
    OAuthClientAuthorizationListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAuthorizationListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildSpecAttributeRestrictionsNestedImpl<N> extends BuildSpecFluentImpl<PolicyRuleFluentImpl.BuildSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildSpecAttributeRestrictionsNested<N>,Nested<N>{
    BuildSpecAttributeRestrictionsNestedImpl(BuildSpec item) {
      this.builder = new BuildSpecBuilder(this, item);
    }
    BuildSpecAttributeRestrictionsNestedImpl() {
      this.builder = new BuildSpecBuilder(this);
    }
    BuildSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectStatusAttributeRestrictionsNestedImpl<N> extends ProjectStatusFluentImpl<PolicyRuleFluentImpl.ProjectStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ProjectStatusAttributeRestrictionsNested<N>,Nested<N>{
    ProjectStatusAttributeRestrictionsNestedImpl(ProjectStatus item) {
      this.builder = new ProjectStatusBuilder(this, item);
    }
    ProjectStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectStatusBuilder(this);
    }
    ProjectStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class LocalSubjectAccessReviewAttributeRestrictionsNestedImpl<N> extends LocalSubjectAccessReviewFluentImpl<PolicyRuleFluentImpl.LocalSubjectAccessReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.LocalSubjectAccessReviewAttributeRestrictionsNested<N>,Nested<N>{
    LocalSubjectAccessReviewAttributeRestrictionsNestedImpl(LocalSubjectAccessReview item) {
      this.builder = new LocalSubjectAccessReviewBuilder(this, item);
    }
    LocalSubjectAccessReviewAttributeRestrictionsNestedImpl() {
      this.builder = new LocalSubjectAccessReviewBuilder(this);
    }
    LocalSubjectAccessReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLocalSubjectAccessReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl<N> extends RollingDeploymentStrategyParamsFluentImpl<PolicyRuleFluentImpl.RollingDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RollingDeploymentStrategyParamsAttributeRestrictionsNested<N>,Nested<N>{
    RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl(RollingDeploymentStrategyParams item) {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
    }
    RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl() {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this);
    }
    RollingDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRollingDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  }
  class GitSourceRevisionAttributeRestrictionsNestedImpl<N> extends GitSourceRevisionFluentImpl<PolicyRuleFluentImpl.GitSourceRevisionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GitSourceRevisionAttributeRestrictionsNested<N>,Nested<N>{
    GitSourceRevisionAttributeRestrictionsNestedImpl(GitSourceRevision item) {
      this.builder = new GitSourceRevisionBuilder(this, item);
    }
    GitSourceRevisionAttributeRestrictionsNestedImpl() {
      this.builder = new GitSourceRevisionBuilder(this);
    }
    GitSourceRevisionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGitSourceRevisionAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageLabelAttributeRestrictionsNestedImpl<N> extends ImageLabelFluentImpl<PolicyRuleFluentImpl.ImageLabelAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageLabelAttributeRestrictionsNested<N>,Nested<N>{
    ImageLabelAttributeRestrictionsNestedImpl(ImageLabel item) {
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelAttributeRestrictionsNestedImpl() {
      this.builder = new ImageLabelBuilder(this);
    }
    ImageLabelBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageLabelAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageChangeTriggerAttributeRestrictionsNestedImpl<N> extends ImageChangeTriggerFluentImpl<PolicyRuleFluentImpl.ImageChangeTriggerAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageChangeTriggerAttributeRestrictionsNested<N>,Nested<N>{
    ImageChangeTriggerAttributeRestrictionsNestedImpl(ImageChangeTrigger item) {
      this.builder = new ImageChangeTriggerBuilder(this, item);
    }
    ImageChangeTriggerAttributeRestrictionsNestedImpl() {
      this.builder = new ImageChangeTriggerBuilder(this);
    }
    ImageChangeTriggerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageChangeTriggerAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicyReviewSpecFluentImpl<PolicyRuleFluentImpl.PodSecurityPolicyReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodSecurityPolicyReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl(PodSecurityPolicyReviewSpec item) {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this, item);
    }
    PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this);
    }
    PodSecurityPolicyReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicyReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageTagAttributeRestrictionsNestedImpl<N> extends ImageTagFluentImpl<PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNested<N>,Nested<N>{
    ImageTagAttributeRestrictionsNestedImpl(ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagAttributeRestrictionsNestedImpl() {
      this.builder = new ImageTagBuilder(this);
    }
    ImageTagBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageTagAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImportSpecAttributeRestrictionsNestedImpl<N> extends ImageStreamImportSpecFluentImpl<PolicyRuleFluentImpl.ImageStreamImportSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamImportSpecAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImportSpecAttributeRestrictionsNestedImpl(ImageStreamImportSpec item) {
      this.builder = new ImageStreamImportSpecBuilder(this, item);
    }
    ImageStreamImportSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImportSpecBuilder(this);
    }
    ImageStreamImportSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class FSGroupStrategyOptionsAttributeRestrictionsNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<PolicyRuleFluentImpl.FSGroupStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.FSGroupStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    FSGroupStrategyOptionsAttributeRestrictionsNestedImpl(FSGroupStrategyOptions item) {
      this.builder = new FSGroupStrategyOptionsBuilder(this, item);
    }
    FSGroupStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new FSGroupStrategyOptionsBuilder(this);
    }
    FSGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endFSGroupStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicyReviewFluentImpl<PolicyRuleFluentImpl.PodSecurityPolicyReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodSecurityPolicyReviewAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicyReviewAttributeRestrictionsNestedImpl(PodSecurityPolicyReview item) {
      this.builder = new PodSecurityPolicyReviewBuilder(this, item);
    }
    PodSecurityPolicyReviewAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicyReviewBuilder(this);
    }
    PodSecurityPolicyReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicyReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl<N> extends RecreateDeploymentStrategyParamsFluentImpl<PolicyRuleFluentImpl.RecreateDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RecreateDeploymentStrategyParamsAttributeRestrictionsNested<N>,Nested<N>{
    RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl(RecreateDeploymentStrategyParams item) {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
    }
    RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl() {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this);
    }
    RecreateDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRecreateDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  }
  class DockerStrategyOptionsAttributeRestrictionsNestedImpl<N> extends DockerStrategyOptionsFluentImpl<PolicyRuleFluentImpl.DockerStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DockerStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    DockerStrategyOptionsAttributeRestrictionsNestedImpl(DockerStrategyOptions item) {
      this.builder = new DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new DockerStrategyOptionsBuilder(this);
    }
    DockerStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDockerStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageListAttributeRestrictionsNestedImpl<N> extends ImageListFluentImpl<PolicyRuleFluentImpl.ImageListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageListAttributeRestrictionsNested<N>,Nested<N>{
    ImageListAttributeRestrictionsNestedImpl(ImageList item) {
      this.builder = new ImageListBuilder(this, item);
    }
    ImageListAttributeRestrictionsNestedImpl() {
      this.builder = new ImageListBuilder(this);
    }
    ImageListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageListAttributeRestrictions() {
      return and();
    }
    
  }
  class ConfigMapBuildSourceAttributeRestrictionsNestedImpl<N> extends ConfigMapBuildSourceFluentImpl<PolicyRuleFluentImpl.ConfigMapBuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ConfigMapBuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    ConfigMapBuildSourceAttributeRestrictionsNestedImpl(ConfigMapBuildSource item) {
      this.builder = new ConfigMapBuildSourceBuilder(this, item);
    }
    ConfigMapBuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new ConfigMapBuildSourceBuilder(this);
    }
    ConfigMapBuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endConfigMapBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageTagListAttributeRestrictionsNestedImpl<N> extends ImageTagListFluentImpl<PolicyRuleFluentImpl.ImageTagListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageTagListAttributeRestrictionsNested<N>,Nested<N>{
    ImageTagListAttributeRestrictionsNestedImpl(ImageTagList item) {
      this.builder = new ImageTagListBuilder(this, item);
    }
    ImageTagListAttributeRestrictionsNestedImpl() {
      this.builder = new ImageTagListBuilder(this);
    }
    ImageTagListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageTagListAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends OAuthAccessTokenFluentImpl<PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAccessTokenAttributeRestrictionsNestedImpl(OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAccessTokenBuilder(this);
    }
    OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigAttributeRestrictionsNestedImpl<N> extends DeploymentConfigFluentImpl<PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigAttributeRestrictionsNestedImpl(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigBuilder(this);
    }
    DeploymentConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingAttributeRestrictionsNestedImpl<N> extends RoleBindingFluentImpl<PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingAttributeRestrictionsNestedImpl(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingBuilder(this);
    }
    RoleBindingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageAttributeRestrictionsNestedImpl<N> extends ImageFluentImpl<PolicyRuleFluentImpl.ImageAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageAttributeRestrictionsNested<N>,Nested<N>{
    ImageAttributeRestrictionsNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageAttributeRestrictionsNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageAttributeRestrictions() {
      return and();
    }
    
  }
  class TLSConfigAttributeRestrictionsNestedImpl<N> extends TLSConfigFluentImpl<PolicyRuleFluentImpl.TLSConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TLSConfigAttributeRestrictionsNested<N>,Nested<N>{
    TLSConfigAttributeRestrictionsNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigAttributeRestrictionsNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTLSConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildVolumeAttributeRestrictionsNestedImpl<N> extends BuildVolumeFluentImpl<PolicyRuleFluentImpl.BuildVolumeAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildVolumeAttributeRestrictionsNested<N>,Nested<N>{
    BuildVolumeAttributeRestrictionsNestedImpl(BuildVolume item) {
      this.builder = new BuildVolumeBuilder(this, item);
    }
    BuildVolumeAttributeRestrictionsNestedImpl() {
      this.builder = new BuildVolumeBuilder(this);
    }
    BuildVolumeBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildVolumeAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceSpecAttributeRestrictionsNestedImpl<N> extends TemplateInstanceSpecFluentImpl<PolicyRuleFluentImpl.TemplateInstanceSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateInstanceSpecAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceSpecAttributeRestrictionsNestedImpl(TemplateInstanceSpec item) {
      this.builder = new TemplateInstanceSpecBuilder(this, item);
    }
    TemplateInstanceSpecAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceSpecBuilder(this);
    }
    TemplateInstanceSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildStatusAttributeRestrictionsNestedImpl<N> extends BuildStatusFluentImpl<PolicyRuleFluentImpl.BuildStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildStatusAttributeRestrictionsNested<N>,Nested<N>{
    BuildStatusAttributeRestrictionsNestedImpl(BuildStatus item) {
      this.builder = new BuildStatusBuilder(this, item);
    }
    BuildStatusAttributeRestrictionsNestedImpl() {
      this.builder = new BuildStatusBuilder(this);
    }
    BuildStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageSourceAttributeRestrictionsNestedImpl<N> extends ImageSourceFluentImpl<PolicyRuleFluentImpl.ImageSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageSourceAttributeRestrictionsNested<N>,Nested<N>{
    ImageSourceAttributeRestrictionsNestedImpl(ImageSource item) {
      this.builder = new ImageSourceBuilder(this, item);
    }
    ImageSourceAttributeRestrictionsNestedImpl() {
      this.builder = new ImageSourceBuilder(this);
    }
    ImageSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class ObjectMetaAttributeRestrictionsNestedImpl<N> extends ObjectMetaFluentImpl<PolicyRuleFluentImpl.ObjectMetaAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ObjectMetaAttributeRestrictionsNested<N>,Nested<N>{
    ObjectMetaAttributeRestrictionsNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaAttributeRestrictionsNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endObjectMetaAttributeRestrictions() {
      return and();
    }
    
  }
  class PersistentVolumeClaimAttributeRestrictionsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNested<N>,Nested<N>{
    PersistentVolumeClaimAttributeRestrictionsNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimAttributeRestrictionsNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPersistentVolumeClaimAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewFluentImpl<PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl(PodSecurityPolicySelfSubjectReview item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this);
    }
    PodSecurityPolicySelfSubjectReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySelfSubjectReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class TagReferenceAttributeRestrictionsNestedImpl<N> extends TagReferenceFluentImpl<PolicyRuleFluentImpl.TagReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TagReferenceAttributeRestrictionsNested<N>,Nested<N>{
    TagReferenceAttributeRestrictionsNestedImpl(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new TagReferenceBuilder(this);
    }
    TagReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyRuleFluentImpl<PolicyRuleFluentImpl.EgressNetworkPolicyRuleAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.EgressNetworkPolicyRuleAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl(EgressNetworkPolicyRule item) {
      this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
    }
    EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyRuleBuilder(this);
    }
    EgressNetworkPolicyRuleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyRuleAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectRulesReviewStatusAttributeRestrictionsNestedImpl<N> extends SubjectRulesReviewStatusFluentImpl<PolicyRuleFluentImpl.SubjectRulesReviewStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SubjectRulesReviewStatusAttributeRestrictionsNested<N>,Nested<N>{
    SubjectRulesReviewStatusAttributeRestrictionsNestedImpl(SubjectRulesReviewStatus item) {
      this.builder = new SubjectRulesReviewStatusBuilder(this, item);
    }
    SubjectRulesReviewStatusAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectRulesReviewStatusBuilder(this);
    }
    SubjectRulesReviewStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectRulesReviewStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildVolumeMountAttributeRestrictionsNestedImpl<N> extends BuildVolumeMountFluentImpl<PolicyRuleFluentImpl.BuildVolumeMountAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildVolumeMountAttributeRestrictionsNested<N>,Nested<N>{
    BuildVolumeMountAttributeRestrictionsNestedImpl(BuildVolumeMount item) {
      this.builder = new BuildVolumeMountBuilder(this, item);
    }
    BuildVolumeMountAttributeRestrictionsNestedImpl() {
      this.builder = new BuildVolumeMountBuilder(this);
    }
    BuildVolumeMountBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildVolumeMountAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterNetworkEntryAttributeRestrictionsNestedImpl<N> extends ClusterNetworkEntryFluentImpl<PolicyRuleFluentImpl.ClusterNetworkEntryAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterNetworkEntryAttributeRestrictionsNested<N>,Nested<N>{
    ClusterNetworkEntryAttributeRestrictionsNestedImpl(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterNetworkEntryAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceObjectAttributeRestrictionsNestedImpl<N> extends TemplateInstanceObjectFluentImpl<PolicyRuleFluentImpl.TemplateInstanceObjectAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateInstanceObjectAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceObjectAttributeRestrictionsNestedImpl(TemplateInstanceObject item) {
      this.builder = new TemplateInstanceObjectBuilder(this, item);
    }
    TemplateInstanceObjectAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceObjectBuilder(this);
    }
    TemplateInstanceObjectBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceObjectAttributeRestrictions() {
      return and();
    }
    
  }
  class GenericKubernetesResourceAttributeRestrictionsNestedImpl<N> extends GenericKubernetesResourceFluentImpl<PolicyRuleFluentImpl.GenericKubernetesResourceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GenericKubernetesResourceAttributeRestrictionsNested<N>,Nested<N>{
    GenericKubernetesResourceAttributeRestrictionsNestedImpl(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceAttributeRestrictionsNestedImpl() {
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGenericKubernetesResourceAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildSourceAttributeRestrictionsNestedImpl<N> extends BuildSourceFluentImpl<PolicyRuleFluentImpl.BuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    BuildSourceAttributeRestrictionsNestedImpl(BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    BuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new BuildSourceBuilder(this);
    }
    BuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaStatusFluentImpl<PolicyRuleFluentImpl.ClusterResourceQuotaStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterResourceQuotaStatusAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl(ClusterResourceQuotaStatus item) {
      this.builder = new ClusterResourceQuotaStatusBuilder(this, item);
    }
    ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaStatusBuilder(this);
    }
    ClusterResourceQuotaStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConditionAttributeRestrictionsNestedImpl<N> extends DeploymentConditionFluentImpl<PolicyRuleFluentImpl.DeploymentConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentConditionAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConditionAttributeRestrictionsNestedImpl(DeploymentCondition item) {
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    DeploymentConditionAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConditionBuilder(this);
    }
    DeploymentConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositorySpecAttributeRestrictionsNestedImpl<N> extends HelmChartRepositorySpecFluentImpl<PolicyRuleFluentImpl.HelmChartRepositorySpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.HelmChartRepositorySpecAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositorySpecAttributeRestrictionsNestedImpl(HelmChartRepositorySpec item) {
      this.builder = new HelmChartRepositorySpecBuilder(this, item);
    }
    HelmChartRepositorySpecAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositorySpecBuilder(this);
    }
    HelmChartRepositorySpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositorySpecAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl<N> extends DeploymentCauseImageTriggerFluentImpl<PolicyRuleFluentImpl.DeploymentCauseImageTriggerAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentCauseImageTriggerAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl(DeploymentCauseImageTrigger item) {
      this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
    }
    DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentCauseImageTriggerBuilder(this);
    }
    DeploymentCauseImageTriggerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentCauseImageTriggerAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamMappingAttributeRestrictionsNestedImpl<N> extends ImageStreamMappingFluentImpl<PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamMappingAttributeRestrictionsNestedImpl(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamMappingBuilder(this);
    }
    ImageStreamMappingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamMappingAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectRulesReviewAttributeRestrictionsNestedImpl<N> extends SubjectRulesReviewFluentImpl<PolicyRuleFluentImpl.SubjectRulesReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SubjectRulesReviewAttributeRestrictionsNested<N>,Nested<N>{
    SubjectRulesReviewAttributeRestrictionsNestedImpl(SubjectRulesReview item) {
      this.builder = new SubjectRulesReviewBuilder(this, item);
    }
    SubjectRulesReviewAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectRulesReviewBuilder(this);
    }
    SubjectRulesReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectRulesReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleAttributeRestrictionsNestedImpl<N> extends RoleFluentImpl<PolicyRuleFluentImpl.RoleAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RoleAttributeRestrictionsNested<N>,Nested<N>{
    RoleAttributeRestrictionsNestedImpl(Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBuilder(this);
    }
    RoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleAttributeRestrictions() {
      return and();
    }
    
  }
  class GitBuildSourceAttributeRestrictionsNestedImpl<N> extends GitBuildSourceFluentImpl<PolicyRuleFluentImpl.GitBuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GitBuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    GitBuildSourceAttributeRestrictionsNestedImpl(GitBuildSource item) {
      this.builder = new GitBuildSourceBuilder(this, item);
    }
    GitBuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new GitBuildSourceBuilder(this);
    }
    GitBuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGitBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyListAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyListFluentImpl<PolicyRuleFluentImpl.EgressNetworkPolicyListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.EgressNetworkPolicyListAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyListAttributeRestrictionsNestedImpl(EgressNetworkPolicyList item) {
      this.builder = new EgressNetworkPolicyListBuilder(this, item);
    }
    EgressNetworkPolicyListAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyListBuilder(this);
    }
    EgressNetworkPolicyListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyListAttributeRestrictions() {
      return and();
    }
    
  }
  class SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl<N> extends SelfSubjectRulesReviewSpecFluentImpl<PolicyRuleFluentImpl.SelfSubjectRulesReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SelfSubjectRulesReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl(SelfSubjectRulesReviewSpec item) {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
    }
    SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this);
    }
    SelfSubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSelfSubjectRulesReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageSourcePathAttributeRestrictionsNestedImpl<N> extends ImageSourcePathFluentImpl<PolicyRuleFluentImpl.ImageSourcePathAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageSourcePathAttributeRestrictionsNested<N>,Nested<N>{
    ImageSourcePathAttributeRestrictionsNestedImpl(ImageSourcePath item) {
      this.builder = new ImageSourcePathBuilder(this, item);
    }
    ImageSourcePathAttributeRestrictionsNestedImpl() {
      this.builder = new ImageSourcePathBuilder(this);
    }
    ImageSourcePathBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSourcePathAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigStatusAttributeRestrictionsNestedImpl<N> extends BuildConfigStatusFluentImpl<PolicyRuleFluentImpl.BuildConfigStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildConfigStatusAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigStatusAttributeRestrictionsNestedImpl(BuildConfigStatus item) {
      this.builder = new BuildConfigStatusBuilder(this, item);
    }
    BuildConfigStatusAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigStatusBuilder(this);
    }
    BuildConfigStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl<N> extends ResourceQuotaStatusByNamespaceFluentImpl<PolicyRuleFluentImpl.ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<N>,Nested<N>{
    ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl(ResourceQuotaStatusByNamespace item) {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this, item);
    }
    ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl() {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this);
    }
    ResourceQuotaStatusByNamespaceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endResourceQuotaStatusByNamespaceAttributeRestrictions() {
      return and();
    }
    
  }
  class SourceBuildStrategyAttributeRestrictionsNestedImpl<N> extends SourceBuildStrategyFluentImpl<PolicyRuleFluentImpl.SourceBuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SourceBuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    SourceBuildStrategyAttributeRestrictionsNestedImpl(SourceBuildStrategy item) {
      this.builder = new SourceBuildStrategyBuilder(this, item);
    }
    SourceBuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new SourceBuildStrategyBuilder(this);
    }
    SourceBuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSourceBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class ParameterAttributeRestrictionsNestedImpl<N> extends ParameterFluentImpl<PolicyRuleFluentImpl.ParameterAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ParameterAttributeRestrictionsNested<N>,Nested<N>{
    ParameterAttributeRestrictionsNestedImpl(Parameter item) {
      this.builder = new ParameterBuilder(this, item);
    }
    ParameterAttributeRestrictionsNestedImpl() {
      this.builder = new ParameterBuilder(this);
    }
    ParameterBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endParameterAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingListAttributeRestrictionsNestedImpl<N> extends RoleBindingListFluentImpl<PolicyRuleFluentImpl.RoleBindingListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RoleBindingListAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingListAttributeRestrictionsNestedImpl(RoleBindingList item) {
      this.builder = new RoleBindingListBuilder(this, item);
    }
    RoleBindingListAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingListBuilder(this);
    }
    RoleBindingListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingListAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewSpecFluentImpl<PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl(PodSecurityPolicySelfSubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this);
    }
    PodSecurityPolicySelfSubjectReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceAttributeRestrictionsNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNested<N>,Nested<N>{
    BrokerTemplateInstanceAttributeRestrictionsNestedImpl(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceAttributeRestrictionsNestedImpl() {
      this.builder = new BrokerTemplateInstanceBuilder(this);
    }
    BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBrokerTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildPostCommitSpecAttributeRestrictionsNestedImpl<N> extends BuildPostCommitSpecFluentImpl<PolicyRuleFluentImpl.BuildPostCommitSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildPostCommitSpecAttributeRestrictionsNested<N>,Nested<N>{
    BuildPostCommitSpecAttributeRestrictionsNestedImpl(BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    BuildPostCommitSpecAttributeRestrictionsNestedImpl() {
      this.builder = new BuildPostCommitSpecBuilder(this);
    }
    BuildPostCommitSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildPostCommitSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl<N> extends OAuthAuthorizeTokenListFluentImpl<PolicyRuleFluentImpl.OAuthAuthorizeTokenListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OAuthAuthorizeTokenListAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl(OAuthAuthorizeTokenList item) {
      this.builder = new OAuthAuthorizeTokenListBuilder(this, item);
    }
    OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAuthorizeTokenListBuilder(this);
    }
    OAuthAuthorizeTokenListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAuthorizeTokenListAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentStrategyAttributeRestrictionsNestedImpl<N> extends DeploymentStrategyFluentImpl<PolicyRuleFluentImpl.DeploymentStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentStrategyAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentStrategyAttributeRestrictionsNestedImpl(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentStrategyBuilder(this);
    }
    DeploymentStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class SignatureSubjectAttributeRestrictionsNestedImpl<N> extends SignatureSubjectFluentImpl<PolicyRuleFluentImpl.SignatureSubjectAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SignatureSubjectAttributeRestrictionsNested<N>,Nested<N>{
    SignatureSubjectAttributeRestrictionsNestedImpl(SignatureSubject item) {
      this.builder = new SignatureSubjectBuilder(this, item);
    }
    SignatureSubjectAttributeRestrictionsNestedImpl() {
      this.builder = new SignatureSubjectBuilder(this);
    }
    SignatureSubjectBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSignatureSubjectAttributeRestrictions() {
      return and();
    }
    
  }
  class HostSubnetListAttributeRestrictionsNestedImpl<N> extends HostSubnetListFluentImpl<PolicyRuleFluentImpl.HostSubnetListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.HostSubnetListAttributeRestrictionsNested<N>,Nested<N>{
    HostSubnetListAttributeRestrictionsNestedImpl(HostSubnetList item) {
      this.builder = new HostSubnetListBuilder(this, item);
    }
    HostSubnetListAttributeRestrictionsNestedImpl() {
      this.builder = new HostSubnetListBuilder(this);
    }
    HostSubnetListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHostSubnetListAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteIngressConditionAttributeRestrictionsNestedImpl<N> extends RouteIngressConditionFluentImpl<PolicyRuleFluentImpl.RouteIngressConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RouteIngressConditionAttributeRestrictionsNested<N>,Nested<N>{
    RouteIngressConditionAttributeRestrictionsNestedImpl(RouteIngressCondition item) {
      this.builder = new RouteIngressConditionBuilder(this, item);
    }
    RouteIngressConditionAttributeRestrictionsNestedImpl() {
      this.builder = new RouteIngressConditionBuilder(this);
    }
    RouteIngressConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteIngressConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl<N> extends CustomDeploymentStrategyParamsFluentImpl<PolicyRuleFluentImpl.CustomDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.CustomDeploymentStrategyParamsAttributeRestrictionsNested<N>,Nested<N>{
    CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl(CustomDeploymentStrategyParams item) {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
    }
    CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl() {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this);
    }
    CustomDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endCustomDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageImportSpecAttributeRestrictionsNestedImpl<N> extends ImageImportSpecFluentImpl<PolicyRuleFluentImpl.ImageImportSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageImportSpecAttributeRestrictionsNested<N>,Nested<N>{
    ImageImportSpecAttributeRestrictionsNestedImpl(ImageImportSpec item) {
      this.builder = new ImageImportSpecBuilder(this, item);
    }
    ImageImportSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ImageImportSpecBuilder(this);
    }
    ImageImportSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageImportSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class StageInfoAttributeRestrictionsNestedImpl<N> extends StageInfoFluentImpl<PolicyRuleFluentImpl.StageInfoAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.StageInfoAttributeRestrictionsNested<N>,Nested<N>{
    StageInfoAttributeRestrictionsNestedImpl(StageInfo item) {
      this.builder = new StageInfoBuilder(this, item);
    }
    StageInfoAttributeRestrictionsNestedImpl() {
      this.builder = new StageInfoBuilder(this);
    }
    StageInfoBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endStageInfoAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionSpecFluentImpl<PolicyRuleFluentImpl.RoleBindingRestrictionSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RoleBindingRestrictionSpecAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl(RoleBindingRestrictionSpec item) {
      this.builder = new RoleBindingRestrictionSpecBuilder(this, item);
    }
    RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingRestrictionSpecBuilder(this);
    }
    RoleBindingRestrictionSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class IDRangeAttributeRestrictionsNestedImpl<N> extends IDRangeFluentImpl<PolicyRuleFluentImpl.IDRangeAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.IDRangeAttributeRestrictionsNested<N>,Nested<N>{
    IDRangeAttributeRestrictionsNestedImpl(IDRange item) {
      this.builder = new IDRangeBuilder(this, item);
    }
    IDRangeAttributeRestrictionsNestedImpl() {
      this.builder = new IDRangeBuilder(this);
    }
    IDRangeBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIDRangeAttributeRestrictions() {
      return and();
    }
    
  }
  class UserListAttributeRestrictionsNestedImpl<N> extends UserListFluentImpl<PolicyRuleFluentImpl.UserListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.UserListAttributeRestrictionsNested<N>,Nested<N>{
    UserListAttributeRestrictionsNestedImpl(UserList item) {
      this.builder = new UserListBuilder(this, item);
    }
    UserListAttributeRestrictionsNestedImpl() {
      this.builder = new UserListBuilder(this);
    }
    UserListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigSpecAttributeRestrictionsNestedImpl<N> extends BuildConfigSpecFluentImpl<PolicyRuleFluentImpl.BuildConfigSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildConfigSpecAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigSpecAttributeRestrictionsNestedImpl(BuildConfigSpec item) {
      this.builder = new BuildConfigSpecBuilder(this, item);
    }
    BuildConfigSpecAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigSpecBuilder(this);
    }
    BuildConfigSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class UserAttributeRestrictionsNestedImpl<N> extends UserFluentImpl<PolicyRuleFluentImpl.UserAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.UserAttributeRestrictionsNested<N>,Nested<N>{
    UserAttributeRestrictionsNestedImpl(User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserAttributeRestrictionsNestedImpl() {
      this.builder = new UserBuilder(this);
    }
    UserBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImageAttributeRestrictionsNestedImpl<N> extends ImageStreamImageFluentImpl<PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImageAttributeRestrictionsNestedImpl(ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImageBuilder(this);
    }
    ImageStreamImageBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImageAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildStatusOutputToAttributeRestrictionsNestedImpl<N> extends BuildStatusOutputToFluentImpl<PolicyRuleFluentImpl.BuildStatusOutputToAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildStatusOutputToAttributeRestrictionsNested<N>,Nested<N>{
    BuildStatusOutputToAttributeRestrictionsNestedImpl(BuildStatusOutputTo item) {
      this.builder = new BuildStatusOutputToBuilder(this, item);
    }
    BuildStatusOutputToAttributeRestrictionsNestedImpl() {
      this.builder = new BuildStatusOutputToBuilder(this);
    }
    BuildStatusOutputToBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildStatusOutputToAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConditionAttributeRestrictionsNestedImpl<N> extends BuildConditionFluentImpl<PolicyRuleFluentImpl.BuildConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildConditionAttributeRestrictionsNested<N>,Nested<N>{
    BuildConditionAttributeRestrictionsNestedImpl(BuildCondition item) {
      this.builder = new BuildConditionBuilder(this, item);
    }
    BuildConditionAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConditionBuilder(this);
    }
    BuildConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class ResourceAccessReviewResponseAttributeRestrictionsNestedImpl<N> extends ResourceAccessReviewResponseFluentImpl<PolicyRuleFluentImpl.ResourceAccessReviewResponseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ResourceAccessReviewResponseAttributeRestrictionsNested<N>,Nested<N>{
    ResourceAccessReviewResponseAttributeRestrictionsNestedImpl(ResourceAccessReviewResponse item) {
      this.builder = new ResourceAccessReviewResponseBuilder(this, item);
    }
    ResourceAccessReviewResponseAttributeRestrictionsNestedImpl() {
      this.builder = new ResourceAccessReviewResponseBuilder(this);
    }
    ResourceAccessReviewResponseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endResourceAccessReviewResponseAttributeRestrictions() {
      return and();
    }
    
  }
  class ExecNewPodHookAttributeRestrictionsNestedImpl<N> extends ExecNewPodHookFluentImpl<PolicyRuleFluentImpl.ExecNewPodHookAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ExecNewPodHookAttributeRestrictionsNested<N>,Nested<N>{
    ExecNewPodHookAttributeRestrictionsNestedImpl(ExecNewPodHook item) {
      this.builder = new ExecNewPodHookBuilder(this, item);
    }
    ExecNewPodHookAttributeRestrictionsNestedImpl() {
      this.builder = new ExecNewPodHookBuilder(this);
    }
    ExecNewPodHookBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endExecNewPodHookAttributeRestrictions() {
      return and();
    }
    
  }
  class SecretSpecAttributeRestrictionsNestedImpl<N> extends SecretSpecFluentImpl<PolicyRuleFluentImpl.SecretSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SecretSpecAttributeRestrictionsNested<N>,Nested<N>{
    SecretSpecAttributeRestrictionsNestedImpl(SecretSpec item) {
      this.builder = new SecretSpecBuilder(this, item);
    }
    SecretSpecAttributeRestrictionsNestedImpl() {
      this.builder = new SecretSpecBuilder(this);
    }
    SecretSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecretSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleBindingListAttributeRestrictionsNestedImpl<N> extends ClusterRoleBindingListFluentImpl<PolicyRuleFluentImpl.ClusterRoleBindingListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterRoleBindingListAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleBindingListAttributeRestrictionsNestedImpl(ClusterRoleBindingList item) {
      this.builder = new ClusterRoleBindingListBuilder(this, item);
    }
    ClusterRoleBindingListAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleBindingListBuilder(this);
    }
    ClusterRoleBindingListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleBindingListAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyPeerFluentImpl<PolicyRuleFluentImpl.EgressNetworkPolicyPeerAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.EgressNetworkPolicyPeerAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl(EgressNetworkPolicyPeer item) {
      this.builder = new EgressNetworkPolicyPeerBuilder(this, item);
    }
    EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyPeerBuilder(this);
    }
    EgressNetworkPolicyPeerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyPeerAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceAttributeRestrictionsNestedImpl<N> extends TemplateInstanceFluentImpl<PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceAttributeRestrictionsNestedImpl(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceBuilder(this);
    }
    TemplateInstanceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  }
  class WebHookTriggerAttributeRestrictionsNestedImpl<N> extends WebHookTriggerFluentImpl<PolicyRuleFluentImpl.WebHookTriggerAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.WebHookTriggerAttributeRestrictionsNested<N>,Nested<N>{
    WebHookTriggerAttributeRestrictionsNestedImpl(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerAttributeRestrictionsNestedImpl() {
      this.builder = new WebHookTriggerBuilder(this);
    }
    WebHookTriggerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endWebHookTriggerAttributeRestrictions() {
      return and();
    }
    
  }
  class ServiceAccountReferenceAttributeRestrictionsNestedImpl<N> extends ServiceAccountReferenceFluentImpl<PolicyRuleFluentImpl.ServiceAccountReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ServiceAccountReferenceAttributeRestrictionsNested<N>,Nested<N>{
    ServiceAccountReferenceAttributeRestrictionsNestedImpl(ServiceAccountReference item) {
      this.builder = new ServiceAccountReferenceBuilder(this, item);
    }
    ServiceAccountReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new ServiceAccountReferenceBuilder(this);
    }
    ServiceAccountReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endServiceAccountReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildAttributeRestrictionsNestedImpl<N> extends BuildFluentImpl<PolicyRuleFluentImpl.BuildAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildAttributeRestrictionsNested<N>,Nested<N>{
    BuildAttributeRestrictionsNestedImpl(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildAttributeRestrictionsNestedImpl() {
      this.builder = new BuildBuilder(this);
    }
    BuildBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingRestrictionAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionFluentImpl<PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingRestrictionAttributeRestrictionsNestedImpl(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingRestrictionBuilder(this);
    }
    RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class TagImportPolicyAttributeRestrictionsNestedImpl<N> extends TagImportPolicyFluentImpl<PolicyRuleFluentImpl.TagImportPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TagImportPolicyAttributeRestrictionsNested<N>,Nested<N>{
    TagImportPolicyAttributeRestrictionsNestedImpl(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    TagImportPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new TagImportPolicyBuilder(this);
    }
    TagImportPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagImportPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamTagAttributeRestrictionsNestedImpl<N> extends ImageStreamTagFluentImpl<PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamTagAttributeRestrictionsNestedImpl(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamTagBuilder(this);
    }
    ImageStreamTagBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildTriggerPolicyAttributeRestrictionsNestedImpl<N> extends BuildTriggerPolicyFluentImpl<PolicyRuleFluentImpl.BuildTriggerPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildTriggerPolicyAttributeRestrictionsNested<N>,Nested<N>{
    BuildTriggerPolicyAttributeRestrictionsNestedImpl(BuildTriggerPolicy item) {
      this.builder = new BuildTriggerPolicyBuilder(this, item);
    }
    BuildTriggerPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new BuildTriggerPolicyBuilder(this);
    }
    BuildTriggerPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildTriggerPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class RoutePortAttributeRestrictionsNestedImpl<N> extends RoutePortFluentImpl<PolicyRuleFluentImpl.RoutePortAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RoutePortAttributeRestrictionsNested<N>,Nested<N>{
    RoutePortAttributeRestrictionsNestedImpl(RoutePort item) {
      this.builder = new RoutePortBuilder(this, item);
    }
    RoutePortAttributeRestrictionsNestedImpl() {
      this.builder = new RoutePortBuilder(this);
    }
    RoutePortBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoutePortAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceRequesterAttributeRestrictionsNestedImpl<N> extends TemplateInstanceRequesterFluentImpl<PolicyRuleFluentImpl.TemplateInstanceRequesterAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateInstanceRequesterAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceRequesterAttributeRestrictionsNestedImpl(TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    TemplateInstanceRequesterAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceRequesterBuilder(this);
    }
    TemplateInstanceRequesterBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceRequesterAttributeRestrictions() {
      return and();
    }
    
  }
  class GroupAttributeRestrictionsNestedImpl<N> extends GroupFluentImpl<PolicyRuleFluentImpl.GroupAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GroupAttributeRestrictionsNested<N>,Nested<N>{
    GroupAttributeRestrictionsNestedImpl(Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupAttributeRestrictionsNestedImpl() {
      this.builder = new GroupBuilder(this);
    }
    GroupBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildTriggerCauseAttributeRestrictionsNestedImpl<N> extends BuildTriggerCauseFluentImpl<PolicyRuleFluentImpl.BuildTriggerCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildTriggerCauseAttributeRestrictionsNested<N>,Nested<N>{
    BuildTriggerCauseAttributeRestrictionsNestedImpl(BuildTriggerCause item) {
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    BuildTriggerCauseAttributeRestrictionsNestedImpl() {
      this.builder = new BuildTriggerCauseBuilder(this);
    }
    BuildTriggerCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildTriggerCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageSignatureAttributeRestrictionsNestedImpl<N> extends ImageSignatureFluentImpl<PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNested<N>,Nested<N>{
    ImageSignatureAttributeRestrictionsNestedImpl(ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureAttributeRestrictionsNestedImpl() {
      this.builder = new ImageSignatureBuilder(this);
    }
    ImageSignatureBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSignatureAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositoryStatusAttributeRestrictionsNestedImpl<N> extends HelmChartRepositoryStatusFluentImpl<PolicyRuleFluentImpl.HelmChartRepositoryStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.HelmChartRepositoryStatusAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositoryStatusAttributeRestrictionsNestedImpl(HelmChartRepositoryStatus item) {
      this.builder = new HelmChartRepositoryStatusBuilder(this, item);
    }
    HelmChartRepositoryStatusAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositoryStatusBuilder(this);
    }
    HelmChartRepositoryStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositoryStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigSpecAttributeRestrictionsNestedImpl<N> extends DeploymentConfigSpecFluentImpl<PolicyRuleFluentImpl.DeploymentConfigSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentConfigSpecAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigSpecAttributeRestrictionsNestedImpl(DeploymentConfigSpec item) {
      this.builder = new DeploymentConfigSpecBuilder(this, item);
    }
    DeploymentConfigSpecAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigSpecBuilder(this);
    }
    DeploymentConfigSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class HostSubnetAttributeRestrictionsNestedImpl<N> extends HostSubnetFluentImpl<PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNested<N>,Nested<N>{
    HostSubnetAttributeRestrictionsNestedImpl(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetAttributeRestrictionsNestedImpl() {
      this.builder = new HostSubnetBuilder(this);
    }
    HostSubnetBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHostSubnetAttributeRestrictions() {
      return and();
    }
    
  }
  class GroupRestrictionAttributeRestrictionsNestedImpl<N> extends GroupRestrictionFluentImpl<PolicyRuleFluentImpl.GroupRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.GroupRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    GroupRestrictionAttributeRestrictionsNestedImpl(GroupRestriction item) {
      this.builder = new GroupRestrictionBuilder(this, item);
    }
    GroupRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new GroupRestrictionBuilder(this);
    }
    GroupRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>,Nested<N>{
    AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaBuilder(this);
    }
    AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAppliedClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAccessTokenListAttributeRestrictionsNestedImpl<N> extends OAuthAccessTokenListFluentImpl<PolicyRuleFluentImpl.OAuthAccessTokenListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OAuthAccessTokenListAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAccessTokenListAttributeRestrictionsNestedImpl(OAuthAccessTokenList item) {
      this.builder = new OAuthAccessTokenListBuilder(this, item);
    }
    OAuthAccessTokenListAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAccessTokenListBuilder(this);
    }
    OAuthAccessTokenListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAccessTokenListAttributeRestrictions() {
      return and();
    }
    
  }
  class JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl<N> extends JenkinsPipelineBuildStrategyFluentImpl<PolicyRuleFluentImpl.JenkinsPipelineBuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.JenkinsPipelineBuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl(JenkinsPipelineBuildStrategy item) {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
    }
    JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this);
    }
    JenkinsPipelineBuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endJenkinsPipelineBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class SecurityContextConstraintsAttributeRestrictionsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNested<N>,Nested<N>{
    SecurityContextConstraintsAttributeRestrictionsNestedImpl(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsAttributeRestrictionsNestedImpl() {
      this.builder = new SecurityContextConstraintsBuilder(this);
    }
    SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecurityContextConstraintsAttributeRestrictions() {
      return and();
    }
    
  }
  class SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<PolicyRuleFluentImpl.SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl(SupplementalGroupsStrategyOptions item) {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
    }
    SupplementalGroupsStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSupplementalGroupsStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl<N> extends ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<PolicyRuleFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>,Nested<N>{
    ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl(ServiceAccountPodSecurityPolicyReviewStatus item) {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
    }
    ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this);
    }
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildRequestAttributeRestrictionsNestedImpl<N> extends BuildRequestFluentImpl<PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNested<N>,Nested<N>{
    BuildRequestAttributeRestrictionsNestedImpl(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestAttributeRestrictionsNestedImpl() {
      this.builder = new BuildRequestBuilder(this);
    }
    BuildRequestBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildRequestAttributeRestrictions() {
      return and();
    }
    
  }
  class SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl<N> extends SELinuxContextStrategyOptionsFluentImpl<PolicyRuleFluentImpl.SELinuxContextStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SELinuxContextStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl(SELinuxContextStrategyOptions item) {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
    }
    SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this);
    }
    SELinuxContextStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSELinuxContextStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleListAttributeRestrictionsNestedImpl<N> extends ClusterRoleListFluentImpl<PolicyRuleFluentImpl.ClusterRoleListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterRoleListAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleListAttributeRestrictionsNestedImpl(ClusterRoleList item) {
      this.builder = new ClusterRoleListBuilder(this, item);
    }
    ClusterRoleListAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleListBuilder(this);
    }
    ClusterRoleListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleListAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteListAttributeRestrictionsNestedImpl<N> extends RouteListFluentImpl<PolicyRuleFluentImpl.RouteListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RouteListAttributeRestrictionsNested<N>,Nested<N>{
    RouteListAttributeRestrictionsNestedImpl(RouteList item) {
      this.builder = new RouteListBuilder(this, item);
    }
    RouteListAttributeRestrictionsNestedImpl() {
      this.builder = new RouteListBuilder(this);
    }
    RouteListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteListAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamStatusAttributeRestrictionsNestedImpl<N> extends ImageStreamStatusFluentImpl<PolicyRuleFluentImpl.ImageStreamStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamStatusAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamStatusAttributeRestrictionsNestedImpl(ImageStreamStatus item) {
      this.builder = new ImageStreamStatusBuilder(this, item);
    }
    ImageStreamStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamStatusBuilder(this);
    }
    ImageStreamStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyFluentImpl<PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyAttributeRestrictionsNestedImpl(EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyBuilder(this);
    }
    EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class NetNamespaceAttributeRestrictionsNestedImpl<N> extends NetNamespaceFluentImpl<PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNested<N>,Nested<N>{
    NetNamespaceAttributeRestrictionsNestedImpl(NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceAttributeRestrictionsNestedImpl() {
      this.builder = new NetNamespaceBuilder(this);
    }
    NetNamespaceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNetNamespaceAttributeRestrictions() {
      return and();
    }
    
  }
  class UserIdentityMappingAttributeRestrictionsNestedImpl<N> extends UserIdentityMappingFluentImpl<PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNested<N>,Nested<N>{
    UserIdentityMappingAttributeRestrictionsNestedImpl(UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingAttributeRestrictionsNestedImpl() {
      this.builder = new UserIdentityMappingBuilder(this);
    }
    UserIdentityMappingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserIdentityMappingAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentDetailsAttributeRestrictionsNestedImpl<N> extends DeploymentDetailsFluentImpl<PolicyRuleFluentImpl.DeploymentDetailsAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.DeploymentDetailsAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentDetailsAttributeRestrictionsNestedImpl(DeploymentDetails item) {
      this.builder = new DeploymentDetailsBuilder(this, item);
    }
    DeploymentDetailsAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentDetailsBuilder(this);
    }
    DeploymentDetailsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentDetailsAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySubjectReviewStatusFluentImpl<PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl(PodSecurityPolicySubjectReviewStatus item) {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this);
    }
    PodSecurityPolicySubjectReviewStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySubjectReviewSpecFluentImpl<PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl(PodSecurityPolicySubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this);
    }
    PodSecurityPolicySubjectReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamAttributeRestrictionsNestedImpl<N> extends ImageStreamFluentImpl<PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamAttributeRestrictionsNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildListAttributeRestrictionsNestedImpl<N> extends BuildListFluentImpl<PolicyRuleFluentImpl.BuildListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildListAttributeRestrictionsNested<N>,Nested<N>{
    BuildListAttributeRestrictionsNestedImpl(BuildList item) {
      this.builder = new BuildListBuilder(this, item);
    }
    BuildListAttributeRestrictionsNestedImpl() {
      this.builder = new BuildListBuilder(this);
    }
    BuildListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildListAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateListAttributeRestrictionsNestedImpl<N> extends TemplateListFluentImpl<PolicyRuleFluentImpl.TemplateListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.TemplateListAttributeRestrictionsNested<N>,Nested<N>{
    TemplateListAttributeRestrictionsNestedImpl(TemplateList item) {
      this.builder = new TemplateListBuilder(this, item);
    }
    TemplateListAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateListBuilder(this);
    }
    TemplateListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildOutputAttributeRestrictionsNestedImpl<N> extends BuildOutputFluentImpl<PolicyRuleFluentImpl.BuildOutputAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.BuildOutputAttributeRestrictionsNested<N>,Nested<N>{
    BuildOutputAttributeRestrictionsNestedImpl(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    BuildOutputAttributeRestrictionsNestedImpl() {
      this.builder = new BuildOutputBuilder(this);
    }
    BuildOutputBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildOutputAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectSpecAttributeRestrictionsNestedImpl<N> extends ProjectSpecFluentImpl<PolicyRuleFluentImpl.ProjectSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ProjectSpecAttributeRestrictionsNested<N>,Nested<N>{
    ProjectSpecAttributeRestrictionsNestedImpl(ProjectSpec item) {
      this.builder = new ProjectSpecBuilder(this, item);
    }
    ProjectSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectSpecBuilder(this);
    }
    ProjectSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class SourceRevisionAttributeRestrictionsNestedImpl<N> extends SourceRevisionFluentImpl<PolicyRuleFluentImpl.SourceRevisionAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SourceRevisionAttributeRestrictionsNested<N>,Nested<N>{
    SourceRevisionAttributeRestrictionsNestedImpl(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    SourceRevisionAttributeRestrictionsNestedImpl() {
      this.builder = new SourceRevisionBuilder(this);
    }
    SourceRevisionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSourceRevisionAttributeRestrictions() {
      return and();
    }
    
  }
  class ObjectReferenceAttributeRestrictionsNestedImpl<N> extends ObjectReferenceFluentImpl<PolicyRuleFluentImpl.ObjectReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ObjectReferenceAttributeRestrictionsNested<N>,Nested<N>{
    ObjectReferenceAttributeRestrictionsNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endObjectReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class SignatureIssuerAttributeRestrictionsNestedImpl<N> extends SignatureIssuerFluentImpl<PolicyRuleFluentImpl.SignatureIssuerAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.SignatureIssuerAttributeRestrictionsNested<N>,Nested<N>{
    SignatureIssuerAttributeRestrictionsNestedImpl(SignatureIssuer item) {
      this.builder = new SignatureIssuerBuilder(this, item);
    }
    SignatureIssuerAttributeRestrictionsNestedImpl() {
      this.builder = new SignatureIssuerBuilder(this);
    }
    SignatureIssuerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSignatureIssuerAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageLayerAttributeRestrictionsNestedImpl<N> extends ImageLayerFluentImpl<PolicyRuleFluentImpl.ImageLayerAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageLayerAttributeRestrictionsNested<N>,Nested<N>{
    ImageLayerAttributeRestrictionsNestedImpl(ImageLayer item) {
      this.builder = new ImageLayerBuilder(this, item);
    }
    ImageLayerAttributeRestrictionsNestedImpl() {
      this.builder = new ImageLayerBuilder(this);
    }
    ImageLayerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageLayerAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaSpecFluentImpl<PolicyRuleFluentImpl.ClusterResourceQuotaSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ClusterResourceQuotaSpecAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl(ClusterResourceQuotaSpec item) {
      this.builder = new ClusterResourceQuotaSpecBuilder(this, item);
    }
    ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaSpecBuilder(this);
    }
    ClusterResourceQuotaSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamSpecAttributeRestrictionsNestedImpl<N> extends ImageStreamSpecFluentImpl<PolicyRuleFluentImpl.ImageStreamSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.ImageStreamSpecAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamSpecAttributeRestrictionsNestedImpl(ImageStreamSpec item) {
      this.builder = new ImageStreamSpecBuilder(this, item);
    }
    ImageStreamSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamSpecBuilder(this);
    }
    ImageStreamSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteIngressAttributeRestrictionsNestedImpl<N> extends RouteIngressFluentImpl<PolicyRuleFluentImpl.RouteIngressAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RouteIngressAttributeRestrictionsNested<N>,Nested<N>{
    RouteIngressAttributeRestrictionsNestedImpl(RouteIngress item) {
      this.builder = new RouteIngressBuilder(this, item);
    }
    RouteIngressAttributeRestrictionsNestedImpl() {
      this.builder = new RouteIngressBuilder(this);
    }
    RouteIngressBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteIngressAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAttributeRestrictionsNestedImpl<N> extends OAuthClientFluentImpl<PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientAttributeRestrictionsNestedImpl(OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientBuilder(this);
    }
    OAuthClientBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAttributeRestrictions() {
      return and();
    }
    
  }
  class IdentityAttributeRestrictionsNestedImpl<N> extends IdentityFluentImpl<PolicyRuleFluentImpl.IdentityAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.IdentityAttributeRestrictionsNested<N>,Nested<N>{
    IdentityAttributeRestrictionsNestedImpl(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityAttributeRestrictionsNestedImpl() {
      this.builder = new IdentityBuilder(this);
    }
    IdentityBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIdentityAttributeRestrictions() {
      return and();
    }
    
  }
  class RangeAllocationListAttributeRestrictionsNestedImpl<N> extends RangeAllocationListFluentImpl<PolicyRuleFluentImpl.RangeAllocationListAttributeRestrictionsNested<N>> implements PolicyRuleFluentImpl.RangeAllocationListAttributeRestrictionsNested<N>,Nested<N>{
    RangeAllocationListAttributeRestrictionsNestedImpl(RangeAllocationList item) {
      this.builder = new RangeAllocationListBuilder(this, item);
    }
    RangeAllocationListAttributeRestrictionsNestedImpl() {
      this.builder = new RangeAllocationListBuilder(this);
    }
    RangeAllocationListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRangeAllocationListAttributeRestrictions() {
      return and();
    }
    
  }
  
}