package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthAccessTokenListBuilder extends OAuthAccessTokenListFluentImpl<OAuthAccessTokenListBuilder> implements VisitableBuilder<OAuthAccessTokenList,OAuthAccessTokenListBuilder>{
  public OAuthAccessTokenListBuilder() {
    this(false);
  }
  public OAuthAccessTokenListBuilder(Boolean validationEnabled) {
    this(new OAuthAccessTokenList(), validationEnabled);
  }
  public OAuthAccessTokenListBuilder(OAuthAccessTokenListFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthAccessTokenListBuilder(OAuthAccessTokenListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthAccessTokenList(), validationEnabled);
  }
  public OAuthAccessTokenListBuilder(OAuthAccessTokenListFluent<?> fluent,OAuthAccessTokenList instance) {
    this(fluent, instance, false);
  }
  public OAuthAccessTokenListBuilder(OAuthAccessTokenListFluent<?> fluent,OAuthAccessTokenList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OAuthAccessTokenListBuilder(OAuthAccessTokenList instance) {
    this(instance,false);
  }
  public OAuthAccessTokenListBuilder(OAuthAccessTokenList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OAuthAccessTokenListFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthAccessTokenList build() {
    OAuthAccessTokenList buildable = new OAuthAccessTokenList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}