package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageTagFluentImpl<A extends ImageTagFluent<A>> extends BaseFluent<A> implements ImageTagFluent<A>{
  public ImageTagFluentImpl() {
  }
  public ImageTagFluentImpl(ImageTag instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withImage(instance.getImage());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private ImageBuilder image;
  private String kind;
  private ObjectMetaBuilder metadata;
  private TagReferenceBuilder spec;
  private NamedTagEventListBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public ImageTagFluentImpl.ImageNested<A> withNewImage() {
    return new ImageTagFluentImpl.ImageNestedImpl();
  }
  public ImageTagFluentImpl.ImageNested<A> withNewImageLike(Image item) {
    return new ImageTagFluentImpl.ImageNestedImpl(item);
  }
  public ImageTagFluentImpl.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public ImageTagFluentImpl.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
  }
  public ImageTagFluentImpl.ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ImageTagFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ImageTagFluentImpl.MetadataNestedImpl();
  }
  public ImageTagFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ImageTagFluentImpl.MetadataNestedImpl(item);
  }
  public ImageTagFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ImageTagFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ImageTagFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagReference getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public TagReference buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(TagReference spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new TagReferenceBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ImageTagFluentImpl.SpecNested<A> withNewSpec() {
    return new ImageTagFluentImpl.SpecNestedImpl();
  }
  public ImageTagFluentImpl.SpecNested<A> withNewSpecLike(TagReference item) {
    return new ImageTagFluentImpl.SpecNestedImpl(item);
  }
  public ImageTagFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ImageTagFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new TagReferenceBuilder().build());
  }
  public ImageTagFluentImpl.SpecNested<A> editOrNewSpecLike(TagReference item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamedTagEventList getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public NamedTagEventList buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(NamedTagEventList status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new NamedTagEventListBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ImageTagFluentImpl.StatusNested<A> withNewStatus() {
    return new ImageTagFluentImpl.StatusNestedImpl();
  }
  public ImageTagFluentImpl.StatusNested<A> withNewStatusLike(NamedTagEventList item) {
    return new ImageTagFluentImpl.StatusNestedImpl(item);
  }
  public ImageTagFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ImageTagFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new NamedTagEventListBuilder().build());
  }
  public ImageTagFluentImpl.StatusNested<A> editOrNewStatusLike(NamedTagEventList item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageTagFluentImpl that = (ImageTagFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  image,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<ImageTagFluentImpl.ImageNested<N>> implements ImageTagFluentImpl.ImageNested<N>,Nested<N>{
    ImageNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) ImageTagFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageTagFluentImpl.MetadataNested<N>> implements ImageTagFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageTagFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends TagReferenceFluentImpl<ImageTagFluentImpl.SpecNested<N>> implements ImageTagFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new TagReferenceBuilder(this);
    }
    TagReferenceBuilder builder;
    public N and() {
      return (N) ImageTagFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends NamedTagEventListFluentImpl<ImageTagFluentImpl.StatusNested<N>> implements ImageTagFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(NamedTagEventList item) {
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new NamedTagEventListBuilder(this);
    }
    NamedTagEventListBuilder builder;
    public N and() {
      return (N) ImageTagFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}