package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamStatusBuilder extends ImageStreamStatusFluentImpl<ImageStreamStatusBuilder> implements VisitableBuilder<ImageStreamStatus,ImageStreamStatusBuilder>{
  public ImageStreamStatusBuilder() {
    this(false);
  }
  public ImageStreamStatusBuilder(Boolean validationEnabled) {
    this(new ImageStreamStatus(), validationEnabled);
  }
  public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamStatus(), validationEnabled);
  }
  public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent,ImageStreamStatus instance) {
    this(fluent, instance, false);
  }
  public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent,ImageStreamStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDockerImageRepository(instance.getDockerImageRepository());
      fluent.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
      fluent.withTags(instance.getTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamStatusBuilder(ImageStreamStatus instance) {
    this(instance,false);
  }
  public ImageStreamStatusBuilder(ImageStreamStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDockerImageRepository(instance.getDockerImageRepository());
      this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
      this.withTags(instance.getTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamStatus build() {
    ImageStreamStatus buildable = new ImageStreamStatus(fluent.getDockerImageRepository(),fluent.getPublicDockerImageRepository(),fluent.getTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}