package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamMappingBuilder extends ImageStreamMappingFluentImpl<ImageStreamMappingBuilder> implements VisitableBuilder<ImageStreamMapping,ImageStreamMappingBuilder>{
  public ImageStreamMappingBuilder() {
    this(false);
  }
  public ImageStreamMappingBuilder(Boolean validationEnabled) {
    this(new ImageStreamMapping(), validationEnabled);
  }
  public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamMapping(), validationEnabled);
  }
  public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent,ImageStreamMapping instance) {
    this(fluent, instance, false);
  }
  public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent,ImageStreamMapping instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withImage(instance.getImage());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withTag(instance.getTag());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamMappingBuilder(ImageStreamMapping instance) {
    this(instance,false);
  }
  public ImageStreamMappingBuilder(ImageStreamMapping instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withImage(instance.getImage());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withTag(instance.getTag());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamMappingFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamMapping build() {
    ImageStreamMapping buildable = new ImageStreamMapping(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata(),fluent.getTag());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}