package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamImportStatusFluentImpl<A extends ImageStreamImportStatusFluent<A>> extends BaseFluent<A> implements ImageStreamImportStatusFluent<A>{
  public ImageStreamImportStatusFluentImpl() {
  }
  public ImageStreamImportStatusFluentImpl(ImageStreamImportStatus instance) {
    if (instance != null) {
      this.withImages(instance.getImages());
      this.withImport(instance.getImport());
      this.withRepository(instance.getRepository());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ImageImportStatusBuilder> images = new ArrayList<ImageImportStatusBuilder>();
  private ImageStreamBuilder _import;
  private RepositoryImportStatusBuilder repository;
  private Map<String,Object> additionalProperties;
  public A addToImages(int index,ImageImportStatus item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
    if (index < 0 || index >= images.size()) { _visitables.get("images").add(builder); images.add(builder); } else { _visitables.get("images").add(index, builder); images.add(index, builder);}
    return (A)this;
  }
  public A setToImages(int index,ImageImportStatus item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
    if (index < 0 || index >= images.size()) { _visitables.get("images").add(builder); images.add(builder); } else { _visitables.get("images").set(index, builder); images.set(index, builder);}
    return (A)this;
  }
  public A addToImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(Collection<ImageImportStatus> items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeAllFromImages(Collection<ImageImportStatus> items) {
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<ImageImportStatusBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      ImageImportStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageImportStatus> getImages() {
    return images != null ? build(images) : null;
  }
  public List<ImageImportStatus> buildImages() {
    return images != null ? build(images) : null;
  }
  public ImageImportStatus buildImage(int index) {
    return this.images.get(index).build();
  }
  public ImageImportStatus buildFirstImage() {
    return this.images.get(0).build();
  }
  public ImageImportStatus buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    for (ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    for (ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(List<ImageImportStatus> images) {
    if (this.images != null) { _visitables.get("images").clear();}
    if (images != null) {this.images = new ArrayList(); for (ImageImportStatus item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.openshift.api.model.ImageImportStatus... images) {
    if (this.images != null) {this.images.clear(); _visitables.remove("images"); }
    if (images != null) {for (ImageImportStatus item :images){ this.addToImages(item);}} return (A) this;
  }
  public Boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public ImageStreamImportStatusFluentImpl.ImagesNested<A> addNewImage() {
    return new ImageStreamImportStatusFluentImpl.ImagesNestedImpl();
  }
  public ImageStreamImportStatusFluentImpl.ImagesNested<A> addNewImageLike(ImageImportStatus item) {
    return new ImageStreamImportStatusFluentImpl.ImagesNestedImpl(-1, item);
  }
  public ImageStreamImportStatusFluentImpl.ImagesNested<A> setNewImageLike(int index,ImageImportStatus item) {
    return new ImageStreamImportStatusFluentImpl.ImagesNestedImpl(index, item);
  }
  public ImageStreamImportStatusFluentImpl.ImagesNested<A> editImage(int index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public ImageStreamImportStatusFluentImpl.ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public ImageStreamImportStatusFluentImpl.ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public ImageStreamImportStatusFluentImpl.ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  
  /**
   * This method has been deprecated, please use method buildImport instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageStream getImport() {
    return this._import!=null ?this._import.build():null;
  }
  public ImageStream buildImport() {
    return this._import!=null ?this._import.build():null;
  }
  public A withImport(ImageStream _import) {
    _visitables.get("_import").remove(this._import);
    if (_import!=null){ this._import= new ImageStreamBuilder(_import); _visitables.get("_import").add(this._import);} else { this._import = null; _visitables.get("_import").remove(this._import); } return (A) this;
  }
  public Boolean hasImport() {
    return this._import != null;
  }
  public ImageStreamImportStatusFluentImpl.ImportNested<A> withNewImport() {
    return new ImageStreamImportStatusFluentImpl.ImportNestedImpl();
  }
  public ImageStreamImportStatusFluentImpl.ImportNested<A> withNewImportLike(ImageStream item) {
    return new ImageStreamImportStatusFluentImpl.ImportNestedImpl(item);
  }
  public ImageStreamImportStatusFluentImpl.ImportNested<A> editImport() {
    return withNewImportLike(getImport());
  }
  public ImageStreamImportStatusFluentImpl.ImportNested<A> editOrNewImport() {
    return withNewImportLike(getImport() != null ? getImport(): new ImageStreamBuilder().build());
  }
  public ImageStreamImportStatusFluentImpl.ImportNested<A> editOrNewImportLike(ImageStream item) {
    return withNewImportLike(getImport() != null ? getImport(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRepository instead.
   * @return The buildable object.
   */
  @Deprecated
  public RepositoryImportStatus getRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  public RepositoryImportStatus buildRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  public A withRepository(RepositoryImportStatus repository) {
    _visitables.get("repository").remove(this.repository);
    if (repository!=null){ this.repository= new RepositoryImportStatusBuilder(repository); _visitables.get("repository").add(this.repository);} else { this.repository = null; _visitables.get("repository").remove(this.repository); } return (A) this;
  }
  public Boolean hasRepository() {
    return this.repository != null;
  }
  public ImageStreamImportStatusFluentImpl.RepositoryNested<A> withNewRepository() {
    return new ImageStreamImportStatusFluentImpl.RepositoryNestedImpl();
  }
  public ImageStreamImportStatusFluentImpl.RepositoryNested<A> withNewRepositoryLike(RepositoryImportStatus item) {
    return new ImageStreamImportStatusFluentImpl.RepositoryNestedImpl(item);
  }
  public ImageStreamImportStatusFluentImpl.RepositoryNested<A> editRepository() {
    return withNewRepositoryLike(getRepository());
  }
  public ImageStreamImportStatusFluentImpl.RepositoryNested<A> editOrNewRepository() {
    return withNewRepositoryLike(getRepository() != null ? getRepository(): new RepositoryImportStatusBuilder().build());
  }
  public ImageStreamImportStatusFluentImpl.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportStatus item) {
    return withNewRepositoryLike(getRepository() != null ? getRepository(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamImportStatusFluentImpl that = (ImageStreamImportStatusFluentImpl) o;
    if (!java.util.Objects.equals(images, that.images)) return false;

    if (!java.util.Objects.equals(_import, that._import)) return false;

    if (!java.util.Objects.equals(repository, that.repository)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(images,  _import,  repository,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (_import != null) { sb.append("_import:"); sb.append(_import + ","); }
    if (repository != null) { sb.append("repository:"); sb.append(repository + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImagesNestedImpl<N> extends ImageImportStatusFluentImpl<ImageStreamImportStatusFluentImpl.ImagesNested<N>> implements ImageStreamImportStatusFluentImpl.ImagesNested<N>,Nested<N>{
    ImagesNestedImpl(int index,ImageImportStatus item) {
      this.index = index;
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImagesNestedImpl() {
      this.index = -1;
      this.builder = new ImageImportStatusBuilder(this);
    }
    ImageImportStatusBuilder builder;
    int index;
    public N and() {
      return (N) ImageStreamImportStatusFluentImpl.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class ImportNestedImpl<N> extends ImageStreamFluentImpl<ImageStreamImportStatusFluentImpl.ImportNested<N>> implements ImageStreamImportStatusFluentImpl.ImportNested<N>,Nested<N>{
    ImportNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImportNestedImpl() {
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    public N and() {
      return (N) ImageStreamImportStatusFluentImpl.this.withImport(builder.build());
    }
    public N endImport() {
      return and();
    }
    
  }
  class RepositoryNestedImpl<N> extends RepositoryImportStatusFluentImpl<ImageStreamImportStatusFluentImpl.RepositoryNested<N>> implements ImageStreamImportStatusFluentImpl.RepositoryNested<N>,Nested<N>{
    RepositoryNestedImpl(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryNestedImpl() {
      this.builder = new RepositoryImportStatusBuilder(this);
    }
    RepositoryImportStatusBuilder builder;
    public N and() {
      return (N) ImageStreamImportStatusFluentImpl.this.withRepository(builder.build());
    }
    public N endRepository() {
      return and();
    }
    
  }
  
}