package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Status;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageImportStatusFluentImpl<A extends ImageImportStatusFluent<A>> extends BaseFluent<A> implements ImageImportStatusFluent<A>{
  public ImageImportStatusFluentImpl() {
  }
  public ImageImportStatusFluentImpl(ImageImportStatus instance) {
    if (instance != null) {
      this.withImage(instance.getImage());
      this.withStatus(instance.getStatus());
      this.withTag(instance.getTag());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ImageBuilder image;
  private Status status;
  private String tag;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public ImageImportStatusFluentImpl.ImageNested<A> withNewImage() {
    return new ImageImportStatusFluentImpl.ImageNestedImpl();
  }
  public ImageImportStatusFluentImpl.ImageNested<A> withNewImageLike(Image item) {
    return new ImageImportStatusFluentImpl.ImageNestedImpl(item);
  }
  public ImageImportStatusFluentImpl.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public ImageImportStatusFluentImpl.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
  }
  public ImageImportStatusFluentImpl.ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  public Status getStatus() {
    return this.status;
  }
  public A withStatus(Status status) {
    this.status=status; return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public String getTag() {
    return this.tag;
  }
  public A withTag(String tag) {
    this.tag=tag; return (A) this;
  }
  public Boolean hasTag() {
    return this.tag != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageImportStatusFluentImpl that = (ImageImportStatusFluentImpl) o;
    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(tag, that.tag)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(image,  status,  tag,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<ImageImportStatusFluentImpl.ImageNested<N>> implements ImageImportStatusFluentImpl.ImageNested<N>,Nested<N>{
    ImageNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) ImageImportStatusFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  
}