package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageImportSpecFluentImpl<A extends ImageImportSpecFluent<A>> extends BaseFluent<A> implements ImageImportSpecFluent<A>{
  public ImageImportSpecFluentImpl() {
  }
  public ImageImportSpecFluentImpl(ImageImportSpec instance) {
    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withImportPolicy(instance.getImportPolicy());
      this.withIncludeManifest(instance.getIncludeManifest());
      this.withReferencePolicy(instance.getReferencePolicy());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ObjectReferenceBuilder from;
  private TagImportPolicyBuilder importPolicy;
  private Boolean includeManifest;
  private TagReferencePolicyBuilder referencePolicy;
  private LocalObjectReferenceBuilder to;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} else { this.from = null; _visitables.get("from").remove(this.from); } return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public ImageImportSpecFluentImpl.FromNested<A> withNewFrom() {
    return new ImageImportSpecFluentImpl.FromNestedImpl();
  }
  public ImageImportSpecFluentImpl.FromNested<A> withNewFromLike(ObjectReference item) {
    return new ImageImportSpecFluentImpl.FromNestedImpl(item);
  }
  public ImageImportSpecFluentImpl.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public ImageImportSpecFluentImpl.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
  }
  public ImageImportSpecFluentImpl.FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildImportPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagImportPolicy getImportPolicy() {
    return this.importPolicy!=null ?this.importPolicy.build():null;
  }
  public TagImportPolicy buildImportPolicy() {
    return this.importPolicy!=null ?this.importPolicy.build():null;
  }
  public A withImportPolicy(TagImportPolicy importPolicy) {
    _visitables.get("importPolicy").remove(this.importPolicy);
    if (importPolicy!=null){ this.importPolicy= new TagImportPolicyBuilder(importPolicy); _visitables.get("importPolicy").add(this.importPolicy);} else { this.importPolicy = null; _visitables.get("importPolicy").remove(this.importPolicy); } return (A) this;
  }
  public Boolean hasImportPolicy() {
    return this.importPolicy != null;
  }
  public A withNewImportPolicy(Boolean insecure,Boolean scheduled) {
    return (A)withImportPolicy(new TagImportPolicy(insecure, scheduled));
  }
  public ImageImportSpecFluentImpl.ImportPolicyNested<A> withNewImportPolicy() {
    return new ImageImportSpecFluentImpl.ImportPolicyNestedImpl();
  }
  public ImageImportSpecFluentImpl.ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item) {
    return new ImageImportSpecFluentImpl.ImportPolicyNestedImpl(item);
  }
  public ImageImportSpecFluentImpl.ImportPolicyNested<A> editImportPolicy() {
    return withNewImportPolicyLike(getImportPolicy());
  }
  public ImageImportSpecFluentImpl.ImportPolicyNested<A> editOrNewImportPolicy() {
    return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): new TagImportPolicyBuilder().build());
  }
  public ImageImportSpecFluentImpl.ImportPolicyNested<A> editOrNewImportPolicyLike(TagImportPolicy item) {
    return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): item);
  }
  public Boolean getIncludeManifest() {
    return this.includeManifest;
  }
  public A withIncludeManifest(Boolean includeManifest) {
    this.includeManifest=includeManifest; return (A) this;
  }
  public Boolean hasIncludeManifest() {
    return this.includeManifest != null;
  }
  
  /**
   * This method has been deprecated, please use method buildReferencePolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagReferencePolicy getReferencePolicy() {
    return this.referencePolicy!=null ?this.referencePolicy.build():null;
  }
  public TagReferencePolicy buildReferencePolicy() {
    return this.referencePolicy!=null ?this.referencePolicy.build():null;
  }
  public A withReferencePolicy(TagReferencePolicy referencePolicy) {
    _visitables.get("referencePolicy").remove(this.referencePolicy);
    if (referencePolicy!=null){ this.referencePolicy= new TagReferencePolicyBuilder(referencePolicy); _visitables.get("referencePolicy").add(this.referencePolicy);} else { this.referencePolicy = null; _visitables.get("referencePolicy").remove(this.referencePolicy); } return (A) this;
  }
  public Boolean hasReferencePolicy() {
    return this.referencePolicy != null;
  }
  public A withNewReferencePolicy(String type) {
    return (A)withReferencePolicy(new TagReferencePolicy(type));
  }
  public ImageImportSpecFluentImpl.ReferencePolicyNested<A> withNewReferencePolicy() {
    return new ImageImportSpecFluentImpl.ReferencePolicyNestedImpl();
  }
  public ImageImportSpecFluentImpl.ReferencePolicyNested<A> withNewReferencePolicyLike(TagReferencePolicy item) {
    return new ImageImportSpecFluentImpl.ReferencePolicyNestedImpl(item);
  }
  public ImageImportSpecFluentImpl.ReferencePolicyNested<A> editReferencePolicy() {
    return withNewReferencePolicyLike(getReferencePolicy());
  }
  public ImageImportSpecFluentImpl.ReferencePolicyNested<A> editOrNewReferencePolicy() {
    return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): new TagReferencePolicyBuilder().build());
  }
  public ImageImportSpecFluentImpl.ReferencePolicyNested<A> editOrNewReferencePolicyLike(TagReferencePolicy item) {
    return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTo instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getTo() {
    return this.to!=null ?this.to.build():null;
  }
  public LocalObjectReference buildTo() {
    return this.to!=null ?this.to.build():null;
  }
  public A withTo(LocalObjectReference to) {
    _visitables.get("to").remove(this.to);
    if (to!=null){ this.to= new LocalObjectReferenceBuilder(to); _visitables.get("to").add(this.to);} else { this.to = null; _visitables.get("to").remove(this.to); } return (A) this;
  }
  public Boolean hasTo() {
    return this.to != null;
  }
  public A withNewTo(String name) {
    return (A)withTo(new LocalObjectReference(name));
  }
  public ImageImportSpecFluentImpl.ToNested<A> withNewTo() {
    return new ImageImportSpecFluentImpl.ToNestedImpl();
  }
  public ImageImportSpecFluentImpl.ToNested<A> withNewToLike(LocalObjectReference item) {
    return new ImageImportSpecFluentImpl.ToNestedImpl(item);
  }
  public ImageImportSpecFluentImpl.ToNested<A> editTo() {
    return withNewToLike(getTo());
  }
  public ImageImportSpecFluentImpl.ToNested<A> editOrNewTo() {
    return withNewToLike(getTo() != null ? getTo(): new LocalObjectReferenceBuilder().build());
  }
  public ImageImportSpecFluentImpl.ToNested<A> editOrNewToLike(LocalObjectReference item) {
    return withNewToLike(getTo() != null ? getTo(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageImportSpecFluentImpl that = (ImageImportSpecFluentImpl) o;
    if (!java.util.Objects.equals(from, that.from)) return false;

    if (!java.util.Objects.equals(importPolicy, that.importPolicy)) return false;

    if (!java.util.Objects.equals(includeManifest, that.includeManifest)) return false;

    if (!java.util.Objects.equals(referencePolicy, that.referencePolicy)) return false;

    if (!java.util.Objects.equals(to, that.to)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(from,  importPolicy,  includeManifest,  referencePolicy,  to,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (importPolicy != null) { sb.append("importPolicy:"); sb.append(importPolicy + ","); }
    if (includeManifest != null) { sb.append("includeManifest:"); sb.append(includeManifest + ","); }
    if (referencePolicy != null) { sb.append("referencePolicy:"); sb.append(referencePolicy + ","); }
    if (to != null) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withIncludeManifest() {
    return withIncludeManifest(true);
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<ImageImportSpecFluentImpl.FromNested<N>> implements ImageImportSpecFluentImpl.FromNested<N>,Nested<N>{
    FromNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) ImageImportSpecFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  class ImportPolicyNestedImpl<N> extends TagImportPolicyFluentImpl<ImageImportSpecFluentImpl.ImportPolicyNested<N>> implements ImageImportSpecFluentImpl.ImportPolicyNested<N>,Nested<N>{
    ImportPolicyNestedImpl(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    ImportPolicyNestedImpl() {
      this.builder = new TagImportPolicyBuilder(this);
    }
    TagImportPolicyBuilder builder;
    public N and() {
      return (N) ImageImportSpecFluentImpl.this.withImportPolicy(builder.build());
    }
    public N endImportPolicy() {
      return and();
    }
    
  }
  class ReferencePolicyNestedImpl<N> extends TagReferencePolicyFluentImpl<ImageImportSpecFluentImpl.ReferencePolicyNested<N>> implements ImageImportSpecFluentImpl.ReferencePolicyNested<N>,Nested<N>{
    ReferencePolicyNestedImpl(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    ReferencePolicyNestedImpl() {
      this.builder = new TagReferencePolicyBuilder(this);
    }
    TagReferencePolicyBuilder builder;
    public N and() {
      return (N) ImageImportSpecFluentImpl.this.withReferencePolicy(builder.build());
    }
    public N endReferencePolicy() {
      return and();
    }
    
  }
  class ToNestedImpl<N> extends LocalObjectReferenceFluentImpl<ImageImportSpecFluentImpl.ToNested<N>> implements ImageImportSpecFluentImpl.ToNested<N>,Nested<N>{
    ToNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ToNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ImageImportSpecFluentImpl.this.withTo(builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}