package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmChartRepositoryBuilder extends HelmChartRepositoryFluentImpl<HelmChartRepositoryBuilder> implements VisitableBuilder<HelmChartRepository,HelmChartRepositoryBuilder>{
  public HelmChartRepositoryBuilder() {
    this(false);
  }
  public HelmChartRepositoryBuilder(Boolean validationEnabled) {
    this(new HelmChartRepository(), validationEnabled);
  }
  public HelmChartRepositoryBuilder(HelmChartRepositoryFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmChartRepositoryBuilder(HelmChartRepositoryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmChartRepository(), validationEnabled);
  }
  public HelmChartRepositoryBuilder(HelmChartRepositoryFluent<?> fluent,HelmChartRepository instance) {
    this(fluent, instance, false);
  }
  public HelmChartRepositoryBuilder(HelmChartRepositoryFluent<?> fluent,HelmChartRepository instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HelmChartRepositoryBuilder(HelmChartRepository instance) {
    this(instance,false);
  }
  public HelmChartRepositoryBuilder(HelmChartRepository instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HelmChartRepositoryFluent<?> fluent;
  Boolean validationEnabled;
  public HelmChartRepository build() {
    HelmChartRepository buildable = new HelmChartRepository(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}