package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitSourceRevisionFluentImpl<A extends GitSourceRevisionFluent<A>> extends BaseFluent<A> implements GitSourceRevisionFluent<A>{
  public GitSourceRevisionFluentImpl() {
  }
  public GitSourceRevisionFluentImpl(GitSourceRevision instance) {
    if (instance != null) {
      this.withAuthor(instance.getAuthor());
      this.withCommit(instance.getCommit());
      this.withCommitter(instance.getCommitter());
      this.withMessage(instance.getMessage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SourceControlUserBuilder author;
  private String commit;
  private SourceControlUserBuilder committer;
  private String message;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthor instead.
   * @return The buildable object.
   */
  @Deprecated
  public SourceControlUser getAuthor() {
    return this.author!=null ?this.author.build():null;
  }
  public SourceControlUser buildAuthor() {
    return this.author!=null ?this.author.build():null;
  }
  public A withAuthor(SourceControlUser author) {
    _visitables.get("author").remove(this.author);
    if (author!=null){ this.author= new SourceControlUserBuilder(author); _visitables.get("author").add(this.author);} else { this.author = null; _visitables.get("author").remove(this.author); } return (A) this;
  }
  public Boolean hasAuthor() {
    return this.author != null;
  }
  public A withNewAuthor(String email,String name) {
    return (A)withAuthor(new SourceControlUser(email, name));
  }
  public GitSourceRevisionFluentImpl.AuthorNested<A> withNewAuthor() {
    return new GitSourceRevisionFluentImpl.AuthorNestedImpl();
  }
  public GitSourceRevisionFluentImpl.AuthorNested<A> withNewAuthorLike(SourceControlUser item) {
    return new GitSourceRevisionFluentImpl.AuthorNestedImpl(item);
  }
  public GitSourceRevisionFluentImpl.AuthorNested<A> editAuthor() {
    return withNewAuthorLike(getAuthor());
  }
  public GitSourceRevisionFluentImpl.AuthorNested<A> editOrNewAuthor() {
    return withNewAuthorLike(getAuthor() != null ? getAuthor(): new SourceControlUserBuilder().build());
  }
  public GitSourceRevisionFluentImpl.AuthorNested<A> editOrNewAuthorLike(SourceControlUser item) {
    return withNewAuthorLike(getAuthor() != null ? getAuthor(): item);
  }
  public String getCommit() {
    return this.commit;
  }
  public A withCommit(String commit) {
    this.commit=commit; return (A) this;
  }
  public Boolean hasCommit() {
    return this.commit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCommitter instead.
   * @return The buildable object.
   */
  @Deprecated
  public SourceControlUser getCommitter() {
    return this.committer!=null ?this.committer.build():null;
  }
  public SourceControlUser buildCommitter() {
    return this.committer!=null ?this.committer.build():null;
  }
  public A withCommitter(SourceControlUser committer) {
    _visitables.get("committer").remove(this.committer);
    if (committer!=null){ this.committer= new SourceControlUserBuilder(committer); _visitables.get("committer").add(this.committer);} else { this.committer = null; _visitables.get("committer").remove(this.committer); } return (A) this;
  }
  public Boolean hasCommitter() {
    return this.committer != null;
  }
  public A withNewCommitter(String email,String name) {
    return (A)withCommitter(new SourceControlUser(email, name));
  }
  public GitSourceRevisionFluentImpl.CommitterNested<A> withNewCommitter() {
    return new GitSourceRevisionFluentImpl.CommitterNestedImpl();
  }
  public GitSourceRevisionFluentImpl.CommitterNested<A> withNewCommitterLike(SourceControlUser item) {
    return new GitSourceRevisionFluentImpl.CommitterNestedImpl(item);
  }
  public GitSourceRevisionFluentImpl.CommitterNested<A> editCommitter() {
    return withNewCommitterLike(getCommitter());
  }
  public GitSourceRevisionFluentImpl.CommitterNested<A> editOrNewCommitter() {
    return withNewCommitterLike(getCommitter() != null ? getCommitter(): new SourceControlUserBuilder().build());
  }
  public GitSourceRevisionFluentImpl.CommitterNested<A> editOrNewCommitterLike(SourceControlUser item) {
    return withNewCommitterLike(getCommitter() != null ? getCommitter(): item);
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitSourceRevisionFluentImpl that = (GitSourceRevisionFluentImpl) o;
    if (!java.util.Objects.equals(author, that.author)) return false;

    if (!java.util.Objects.equals(commit, that.commit)) return false;

    if (!java.util.Objects.equals(committer, that.committer)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(author,  commit,  committer,  message,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (author != null) { sb.append("author:"); sb.append(author + ","); }
    if (commit != null) { sb.append("commit:"); sb.append(commit + ","); }
    if (committer != null) { sb.append("committer:"); sb.append(committer + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorNestedImpl<N> extends SourceControlUserFluentImpl<GitSourceRevisionFluentImpl.AuthorNested<N>> implements GitSourceRevisionFluentImpl.AuthorNested<N>,Nested<N>{
    AuthorNestedImpl(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    AuthorNestedImpl() {
      this.builder = new SourceControlUserBuilder(this);
    }
    SourceControlUserBuilder builder;
    public N and() {
      return (N) GitSourceRevisionFluentImpl.this.withAuthor(builder.build());
    }
    public N endAuthor() {
      return and();
    }
    
  }
  class CommitterNestedImpl<N> extends SourceControlUserFluentImpl<GitSourceRevisionFluentImpl.CommitterNested<N>> implements GitSourceRevisionFluentImpl.CommitterNested<N>,Nested<N>{
    CommitterNestedImpl(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    CommitterNestedImpl() {
      this.builder = new SourceControlUserBuilder(this);
    }
    SourceControlUserBuilder builder;
    public N and() {
      return (N) GitSourceRevisionFluentImpl.this.withCommitter(builder.build());
    }
    public N endCommitter() {
      return and();
    }
    
  }
  
}