package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitSourceRevisionBuilder extends GitSourceRevisionFluentImpl<GitSourceRevisionBuilder> implements VisitableBuilder<GitSourceRevision,GitSourceRevisionBuilder>{
  public GitSourceRevisionBuilder() {
    this(false);
  }
  public GitSourceRevisionBuilder(Boolean validationEnabled) {
    this(new GitSourceRevision(), validationEnabled);
  }
  public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent) {
    this(fluent, false);
  }
  public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitSourceRevision(), validationEnabled);
  }
  public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent,GitSourceRevision instance) {
    this(fluent, instance, false);
  }
  public GitSourceRevisionBuilder(GitSourceRevisionFluent<?> fluent,GitSourceRevision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAuthor(instance.getAuthor());
      fluent.withCommit(instance.getCommit());
      fluent.withCommitter(instance.getCommitter());
      fluent.withMessage(instance.getMessage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitSourceRevisionBuilder(GitSourceRevision instance) {
    this(instance,false);
  }
  public GitSourceRevisionBuilder(GitSourceRevision instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAuthor(instance.getAuthor());
      this.withCommit(instance.getCommit());
      this.withCommitter(instance.getCommitter());
      this.withMessage(instance.getMessage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitSourceRevisionFluent<?> fluent;
  Boolean validationEnabled;
  public GitSourceRevision build() {
    GitSourceRevision buildable = new GitSourceRevision(fluent.getAuthor(),fluent.getCommit(),fluent.getCommitter(),fluent.getMessage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}