package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DockerBuildStrategyFluentImpl<A extends DockerBuildStrategyFluent<A>> extends BaseFluent<A> implements DockerBuildStrategyFluent<A>{
  public DockerBuildStrategyFluentImpl() {
  }
  public DockerBuildStrategyFluentImpl(DockerBuildStrategy instance) {
    if (instance != null) {
      this.withBuildArgs(instance.getBuildArgs());
      this.withDockerfilePath(instance.getDockerfilePath());
      this.withEnv(instance.getEnv());
      this.withForcePull(instance.getForcePull());
      this.withFrom(instance.getFrom());
      this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy());
      this.withNoCache(instance.getNoCache());
      this.withPullSecret(instance.getPullSecret());
      this.withVolumes(instance.getVolumes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<EnvVar> buildArgs = new ArrayList<EnvVar>();
  private String dockerfilePath;
  private List<EnvVar> env = new ArrayList<EnvVar>();
  private Boolean forcePull;
  private ObjectReferenceBuilder from;
  private String imageOptimizationPolicy;
  private Boolean noCache;
  private LocalObjectReferenceBuilder pullSecret;
  private ArrayList<BuildVolumeBuilder> volumes = new ArrayList<BuildVolumeBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToBuildArgs(int index,EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
    this.buildArgs.add(index, item);
    return (A)this;
  }
  public A setToBuildArgs(int index,EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
    this.buildArgs.set(index, item); return (A)this;
  }
  public A addToBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
  }
  public A addAllToBuildArgs(Collection<EnvVar> items) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
  }
  public A removeFromBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
  }
  public A removeAllFromBuildArgs(Collection<EnvVar> items) {
    for (EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
  }
  public List<EnvVar> getBuildArgs() {
    return this.buildArgs;
  }
  public EnvVar getBuildArg(int index) {
    return this.buildArgs.get(index);
  }
  public EnvVar getFirstBuildArg() {
    return this.buildArgs.get(0);
  }
  public EnvVar getLastBuildArg() {
    return this.buildArgs.get(buildArgs.size() - 1);
  }
  public EnvVar getMatchingBuildArg(Predicate<EnvVar> predicate) {
    for (EnvVar item: buildArgs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingBuildArg(Predicate<EnvVar> predicate) {
    for (EnvVar item: buildArgs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBuildArgs(List<EnvVar> buildArgs) {
    if (buildArgs != null) {this.buildArgs = new ArrayList(); for (EnvVar item : buildArgs){this.addToBuildArgs(item);}} else { this.buildArgs = null;} return (A) this;
  }
  public A withBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... buildArgs) {
    if (this.buildArgs != null) {this.buildArgs.clear(); _visitables.remove("buildArgs"); }
    if (buildArgs != null) {for (EnvVar item :buildArgs){ this.addToBuildArgs(item);}} return (A) this;
  }
  public Boolean hasBuildArgs() {
    return buildArgs != null && !buildArgs.isEmpty();
  }
  public String getDockerfilePath() {
    return this.dockerfilePath;
  }
  public A withDockerfilePath(String dockerfilePath) {
    this.dockerfilePath=dockerfilePath; return (A) this;
  }
  public Boolean hasDockerfilePath() {
    return this.dockerfilePath != null;
  }
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public List<EnvVar> getEnv() {
    return this.env;
  }
  public EnvVar getEnv(int index) {
    return this.env.get(index);
  }
  public EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<EnvVar> env) {
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public Boolean getForcePull() {
    return this.forcePull;
  }
  public A withForcePull(Boolean forcePull) {
    this.forcePull=forcePull; return (A) this;
  }
  public Boolean hasForcePull() {
    return this.forcePull != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} else { this.from = null; _visitables.get("from").remove(this.from); } return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public DockerBuildStrategyFluentImpl.FromNested<A> withNewFrom() {
    return new DockerBuildStrategyFluentImpl.FromNestedImpl();
  }
  public DockerBuildStrategyFluentImpl.FromNested<A> withNewFromLike(ObjectReference item) {
    return new DockerBuildStrategyFluentImpl.FromNestedImpl(item);
  }
  public DockerBuildStrategyFluentImpl.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public DockerBuildStrategyFluentImpl.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
  }
  public DockerBuildStrategyFluentImpl.FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public String getImageOptimizationPolicy() {
    return this.imageOptimizationPolicy;
  }
  public A withImageOptimizationPolicy(String imageOptimizationPolicy) {
    this.imageOptimizationPolicy=imageOptimizationPolicy; return (A) this;
  }
  public Boolean hasImageOptimizationPolicy() {
    return this.imageOptimizationPolicy != null;
  }
  public Boolean getNoCache() {
    return this.noCache;
  }
  public A withNoCache(Boolean noCache) {
    this.noCache=noCache; return (A) this;
  }
  public Boolean hasNoCache() {
    return this.noCache != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPullSecret() {
    return this.pullSecret!=null ?this.pullSecret.build():null;
  }
  public LocalObjectReference buildPullSecret() {
    return this.pullSecret!=null ?this.pullSecret.build():null;
  }
  public A withPullSecret(LocalObjectReference pullSecret) {
    _visitables.get("pullSecret").remove(this.pullSecret);
    if (pullSecret!=null){ this.pullSecret= new LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} else { this.pullSecret = null; _visitables.get("pullSecret").remove(this.pullSecret); } return (A) this;
  }
  public Boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  public A withNewPullSecret(String name) {
    return (A)withPullSecret(new LocalObjectReference(name));
  }
  public DockerBuildStrategyFluentImpl.PullSecretNested<A> withNewPullSecret() {
    return new DockerBuildStrategyFluentImpl.PullSecretNestedImpl();
  }
  public DockerBuildStrategyFluentImpl.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
    return new DockerBuildStrategyFluentImpl.PullSecretNestedImpl(item);
  }
  public DockerBuildStrategyFluentImpl.PullSecretNested<A> editPullSecret() {
    return withNewPullSecretLike(getPullSecret());
  }
  public DockerBuildStrategyFluentImpl.PullSecretNested<A> editOrNewPullSecret() {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new LocalObjectReferenceBuilder().build());
  }
  public DockerBuildStrategyFluentImpl.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
  }
  public A addToVolumes(int index,BuildVolume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<BuildVolumeBuilder>();}
    BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").add(index, builder); volumes.add(index, builder);}
    return (A)this;
  }
  public A setToVolumes(int index,BuildVolume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<BuildVolumeBuilder>();}
    BuildVolumeBuilder builder = new BuildVolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").set(index, builder); volumes.set(index, builder);}
    return (A)this;
  }
  public A addToVolumes(io.fabric8.openshift.api.model.BuildVolume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<BuildVolumeBuilder>();}
    for (BuildVolume item : items) {BuildVolumeBuilder builder = new BuildVolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(Collection<BuildVolume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<BuildVolumeBuilder>();}
    for (BuildVolume item : items) {BuildVolumeBuilder builder = new BuildVolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.openshift.api.model.BuildVolume... items) {
    for (BuildVolume item : items) {BuildVolumeBuilder builder = new BuildVolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<BuildVolume> items) {
    for (BuildVolume item : items) {BuildVolumeBuilder builder = new BuildVolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(Predicate<BuildVolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<BuildVolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      BuildVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildVolume> getVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public List<BuildVolume> buildVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public BuildVolume buildVolume(int index) {
    return this.volumes.get(index).build();
  }
  public BuildVolume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public BuildVolume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public BuildVolume buildMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
    for (BuildVolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
    for (BuildVolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<BuildVolume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").clear();}
    if (volumes != null) {this.volumes = new ArrayList(); for (BuildVolume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.openshift.api.model.BuildVolume... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (BuildVolume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public DockerBuildStrategyFluentImpl.VolumesNested<A> addNewVolume() {
    return new DockerBuildStrategyFluentImpl.VolumesNestedImpl();
  }
  public DockerBuildStrategyFluentImpl.VolumesNested<A> addNewVolumeLike(BuildVolume item) {
    return new DockerBuildStrategyFluentImpl.VolumesNestedImpl(-1, item);
  }
  public DockerBuildStrategyFluentImpl.VolumesNested<A> setNewVolumeLike(int index,BuildVolume item) {
    return new DockerBuildStrategyFluentImpl.VolumesNestedImpl(index, item);
  }
  public DockerBuildStrategyFluentImpl.VolumesNested<A> editVolume(int index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public DockerBuildStrategyFluentImpl.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public DockerBuildStrategyFluentImpl.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public DockerBuildStrategyFluentImpl.VolumesNested<A> editMatchingVolume(Predicate<BuildVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl) o;
    if (!java.util.Objects.equals(buildArgs, that.buildArgs)) return false;

    if (!java.util.Objects.equals(dockerfilePath, that.dockerfilePath)) return false;

    if (!java.util.Objects.equals(env, that.env)) return false;

    if (!java.util.Objects.equals(forcePull, that.forcePull)) return false;

    if (!java.util.Objects.equals(from, that.from)) return false;

    if (!java.util.Objects.equals(imageOptimizationPolicy, that.imageOptimizationPolicy)) return false;

    if (!java.util.Objects.equals(noCache, that.noCache)) return false;

    if (!java.util.Objects.equals(pullSecret, that.pullSecret)) return false;

    if (!java.util.Objects.equals(volumes, that.volumes)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(buildArgs,  dockerfilePath,  env,  forcePull,  from,  imageOptimizationPolicy,  noCache,  pullSecret,  volumes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildArgs != null && !buildArgs.isEmpty()) { sb.append("buildArgs:"); sb.append(buildArgs + ","); }
    if (dockerfilePath != null) { sb.append("dockerfilePath:"); sb.append(dockerfilePath + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (forcePull != null) { sb.append("forcePull:"); sb.append(forcePull + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (imageOptimizationPolicy != null) { sb.append("imageOptimizationPolicy:"); sb.append(imageOptimizationPolicy + ","); }
    if (noCache != null) { sb.append("noCache:"); sb.append(noCache + ","); }
    if (pullSecret != null) { sb.append("pullSecret:"); sb.append(pullSecret + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withForcePull() {
    return withForcePull(true);
  }
  public A withNoCache() {
    return withNoCache(true);
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<DockerBuildStrategyFluentImpl.FromNested<N>> implements DockerBuildStrategyFluentImpl.FromNested<N>,Nested<N>{
    FromNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) DockerBuildStrategyFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<DockerBuildStrategyFluentImpl.PullSecretNested<N>> implements DockerBuildStrategyFluentImpl.PullSecretNested<N>,Nested<N>{
    PullSecretNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    PullSecretNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) DockerBuildStrategyFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret() {
      return and();
    }
    
  }
  class VolumesNestedImpl<N> extends BuildVolumeFluentImpl<DockerBuildStrategyFluentImpl.VolumesNested<N>> implements DockerBuildStrategyFluentImpl.VolumesNested<N>,Nested<N>{
    VolumesNestedImpl(int index,BuildVolume item) {
      this.index = index;
      this.builder = new BuildVolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new BuildVolumeBuilder(this);
    }
    BuildVolumeBuilder builder;
    int index;
    public N and() {
      return (N) DockerBuildStrategyFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}