package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeploymentTriggerImageChangeParamsFluentImpl<A extends DeploymentTriggerImageChangeParamsFluent<A>> extends BaseFluent<A> implements DeploymentTriggerImageChangeParamsFluent<A>{
  public DeploymentTriggerImageChangeParamsFluentImpl() {
  }
  public DeploymentTriggerImageChangeParamsFluentImpl(DeploymentTriggerImageChangeParams instance) {
    if (instance != null) {
      this.withAutomatic(instance.getAutomatic());
      this.withContainerNames(instance.getContainerNames());
      this.withFrom(instance.getFrom());
      this.withLastTriggeredImage(instance.getLastTriggeredImage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Boolean automatic;
  private List<String> containerNames = new ArrayList<String>();
  private ObjectReferenceBuilder from;
  private String lastTriggeredImage;
  private Map<String,Object> additionalProperties;
  public Boolean getAutomatic() {
    return this.automatic;
  }
  public A withAutomatic(Boolean automatic) {
    this.automatic=automatic; return (A) this;
  }
  public Boolean hasAutomatic() {
    return this.automatic != null;
  }
  public A addToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  public A setToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A removeFromContainerNames(java.lang.String... items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public A removeAllFromContainerNames(Collection<String> items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  public String getContainerName(int index) {
    return this.containerNames.get(index);
  }
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  public String getMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {this.containerNames = new ArrayList(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
  }
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear(); _visitables.remove("containerNames"); }
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  public Boolean hasContainerNames() {
    return containerNames != null && !containerNames.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} else { this.from = null; _visitables.get("from").remove(this.from); } return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public DeploymentTriggerImageChangeParamsFluentImpl.FromNested<A> withNewFrom() {
    return new DeploymentTriggerImageChangeParamsFluentImpl.FromNestedImpl();
  }
  public DeploymentTriggerImageChangeParamsFluentImpl.FromNested<A> withNewFromLike(ObjectReference item) {
    return new DeploymentTriggerImageChangeParamsFluentImpl.FromNestedImpl(item);
  }
  public DeploymentTriggerImageChangeParamsFluentImpl.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public DeploymentTriggerImageChangeParamsFluentImpl.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
  }
  public DeploymentTriggerImageChangeParamsFluentImpl.FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public String getLastTriggeredImage() {
    return this.lastTriggeredImage;
  }
  public A withLastTriggeredImage(String lastTriggeredImage) {
    this.lastTriggeredImage=lastTriggeredImage; return (A) this;
  }
  public Boolean hasLastTriggeredImage() {
    return this.lastTriggeredImage != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentTriggerImageChangeParamsFluentImpl that = (DeploymentTriggerImageChangeParamsFluentImpl) o;
    if (!java.util.Objects.equals(automatic, that.automatic)) return false;

    if (!java.util.Objects.equals(containerNames, that.containerNames)) return false;

    if (!java.util.Objects.equals(from, that.from)) return false;

    if (!java.util.Objects.equals(lastTriggeredImage, that.lastTriggeredImage)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(automatic,  containerNames,  from,  lastTriggeredImage,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (automatic != null) { sb.append("automatic:"); sb.append(automatic + ","); }
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (lastTriggeredImage != null) { sb.append("lastTriggeredImage:"); sb.append(lastTriggeredImage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAutomatic() {
    return withAutomatic(true);
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<DeploymentTriggerImageChangeParamsFluentImpl.FromNested<N>> implements DeploymentTriggerImageChangeParamsFluentImpl.FromNested<N>,Nested<N>{
    FromNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) DeploymentTriggerImageChangeParamsFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  
}