package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentStrategyBuilder extends DeploymentStrategyFluentImpl<DeploymentStrategyBuilder> implements VisitableBuilder<DeploymentStrategy,DeploymentStrategyBuilder>{
  public DeploymentStrategyBuilder() {
    this(false);
  }
  public DeploymentStrategyBuilder(Boolean validationEnabled) {
    this(new DeploymentStrategy(), validationEnabled);
  }
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentStrategy(), validationEnabled);
  }
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent,DeploymentStrategy instance) {
    this(fluent, instance, false);
  }
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent,DeploymentStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCustomParams(instance.getCustomParams());
      fluent.withLabels(instance.getLabels());
      fluent.withRecreateParams(instance.getRecreateParams());
      fluent.withResources(instance.getResources());
      fluent.withRollingParams(instance.getRollingParams());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentStrategyBuilder(DeploymentStrategy instance) {
    this(instance,false);
  }
  public DeploymentStrategyBuilder(DeploymentStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      this.withAnnotations(instance.getAnnotations());
      this.withCustomParams(instance.getCustomParams());
      this.withLabels(instance.getLabels());
      this.withRecreateParams(instance.getRecreateParams());
      this.withResources(instance.getResources());
      this.withRollingParams(instance.getRollingParams());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentStrategy build() {
    DeploymentStrategy buildable = new DeploymentStrategy(fluent.getActiveDeadlineSeconds(),fluent.getAnnotations(),fluent.getCustomParams(),fluent.getLabels(),fluent.getRecreateParams(),fluent.getResources(),fluent.getRollingParams(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}