package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomBuildStrategyBuilder extends CustomBuildStrategyFluentImpl<CustomBuildStrategyBuilder> implements VisitableBuilder<CustomBuildStrategy,CustomBuildStrategyBuilder>{
  public CustomBuildStrategyBuilder() {
    this(false);
  }
  public CustomBuildStrategyBuilder(Boolean validationEnabled) {
    this(new CustomBuildStrategy(), validationEnabled);
  }
  public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomBuildStrategy(), validationEnabled);
  }
  public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent,CustomBuildStrategy instance) {
    this(fluent, instance, false);
  }
  public CustomBuildStrategyBuilder(CustomBuildStrategyFluent<?> fluent,CustomBuildStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBuildAPIVersion(instance.getBuildAPIVersion());
      fluent.withEnv(instance.getEnv());
      fluent.withExposeDockerSocket(instance.getExposeDockerSocket());
      fluent.withForcePull(instance.getForcePull());
      fluent.withFrom(instance.getFrom());
      fluent.withPullSecret(instance.getPullSecret());
      fluent.withSecrets(instance.getSecrets());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomBuildStrategyBuilder(CustomBuildStrategy instance) {
    this(instance,false);
  }
  public CustomBuildStrategyBuilder(CustomBuildStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBuildAPIVersion(instance.getBuildAPIVersion());
      this.withEnv(instance.getEnv());
      this.withExposeDockerSocket(instance.getExposeDockerSocket());
      this.withForcePull(instance.getForcePull());
      this.withFrom(instance.getFrom());
      this.withPullSecret(instance.getPullSecret());
      this.withSecrets(instance.getSecrets());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomBuildStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public CustomBuildStrategy build() {
    CustomBuildStrategy buildable = new CustomBuildStrategy(fluent.getBuildAPIVersion(),fluent.getEnv(),fluent.getExposeDockerSocket(),fluent.getForcePull(),fluent.getFrom(),fluent.getPullSecret(),fluent.getSecrets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}