package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterNetworkListBuilder extends ClusterNetworkListFluentImpl<ClusterNetworkListBuilder> implements VisitableBuilder<ClusterNetworkList,ClusterNetworkListBuilder>{
  public ClusterNetworkListBuilder() {
    this(false);
  }
  public ClusterNetworkListBuilder(Boolean validationEnabled) {
    this(new ClusterNetworkList(), validationEnabled);
  }
  public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterNetworkList(), validationEnabled);
  }
  public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent,ClusterNetworkList instance) {
    this(fluent, instance, false);
  }
  public ClusterNetworkListBuilder(ClusterNetworkListFluent<?> fluent,ClusterNetworkList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterNetworkListBuilder(ClusterNetworkList instance) {
    this(instance,false);
  }
  public ClusterNetworkListBuilder(ClusterNetworkList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterNetworkListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterNetworkList build() {
    ClusterNetworkList buildable = new ClusterNetworkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}