package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildConfigBuilder extends BuildConfigFluentImpl<BuildConfigBuilder> implements VisitableBuilder<BuildConfig,BuildConfigBuilder>{
  public BuildConfigBuilder() {
    this(false);
  }
  public BuildConfigBuilder(Boolean validationEnabled) {
    this(new BuildConfig(), validationEnabled);
  }
  public BuildConfigBuilder(BuildConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildConfigBuilder(BuildConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildConfig(), validationEnabled);
  }
  public BuildConfigBuilder(BuildConfigFluent<?> fluent,BuildConfig instance) {
    this(fluent, instance, false);
  }
  public BuildConfigBuilder(BuildConfigFluent<?> fluent,BuildConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildConfigBuilder(BuildConfig instance) {
    this(instance,false);
  }
  public BuildConfigBuilder(BuildConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildConfigFluent<?> fluent;
  Boolean validationEnabled;
  public BuildConfig build() {
    BuildConfig buildable = new BuildConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}