package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TemplateInstanceSpecFluentImpl<A extends TemplateInstanceSpecFluent<A>> extends BaseFluent<A> implements TemplateInstanceSpecFluent<A>{
  public TemplateInstanceSpecFluentImpl() {
  }
  public TemplateInstanceSpecFluentImpl(TemplateInstanceSpec instance) {
    if (instance != null) {
      this.withRequester(instance.getRequester());
      this.withSecret(instance.getSecret());
      this.withTemplate(instance.getTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private TemplateInstanceRequesterBuilder requester;
  private LocalObjectReferenceBuilder secret;
  private TemplateBuilder template;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildRequester instead.
   * @return The buildable object.
   */
  @Deprecated
  public TemplateInstanceRequester getRequester() {
    return this.requester!=null ?this.requester.build():null;
  }
  public TemplateInstanceRequester buildRequester() {
    return this.requester!=null ?this.requester.build():null;
  }
  public A withRequester(TemplateInstanceRequester requester) {
    _visitables.get("requester").remove(this.requester);
    if (requester!=null){ this.requester= new TemplateInstanceRequesterBuilder(requester); _visitables.get("requester").add(this.requester);} else { this.requester = null; _visitables.get("requester").remove(this.requester); } return (A) this;
  }
  public Boolean hasRequester() {
    return this.requester != null;
  }
  public TemplateInstanceSpecFluentImpl.RequesterNested<A> withNewRequester() {
    return new TemplateInstanceSpecFluentImpl.RequesterNestedImpl();
  }
  public TemplateInstanceSpecFluentImpl.RequesterNested<A> withNewRequesterLike(TemplateInstanceRequester item) {
    return new TemplateInstanceSpecFluentImpl.RequesterNestedImpl(item);
  }
  public TemplateInstanceSpecFluentImpl.RequesterNested<A> editRequester() {
    return withNewRequesterLike(getRequester());
  }
  public TemplateInstanceSpecFluentImpl.RequesterNested<A> editOrNewRequester() {
    return withNewRequesterLike(getRequester() != null ? getRequester(): new TemplateInstanceRequesterBuilder().build());
  }
  public TemplateInstanceSpecFluentImpl.RequesterNested<A> editOrNewRequesterLike(TemplateInstanceRequester item) {
    return withNewRequesterLike(getRequester() != null ? getRequester(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public LocalObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(LocalObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new LocalObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public A withNewSecret(String name) {
    return (A)withSecret(new LocalObjectReference(name));
  }
  public TemplateInstanceSpecFluentImpl.SecretNested<A> withNewSecret() {
    return new TemplateInstanceSpecFluentImpl.SecretNestedImpl();
  }
  public TemplateInstanceSpecFluentImpl.SecretNested<A> withNewSecretLike(LocalObjectReference item) {
    return new TemplateInstanceSpecFluentImpl.SecretNestedImpl(item);
  }
  public TemplateInstanceSpecFluentImpl.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public TemplateInstanceSpecFluentImpl.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new LocalObjectReferenceBuilder().build());
  }
  public TemplateInstanceSpecFluentImpl.SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public Template getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public Template buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(Template template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new TemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateInstanceSpecFluentImpl.TemplateNested<A> withNewTemplate() {
    return new TemplateInstanceSpecFluentImpl.TemplateNestedImpl();
  }
  public TemplateInstanceSpecFluentImpl.TemplateNested<A> withNewTemplateLike(Template item) {
    return new TemplateInstanceSpecFluentImpl.TemplateNestedImpl(item);
  }
  public TemplateInstanceSpecFluentImpl.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public TemplateInstanceSpecFluentImpl.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new TemplateBuilder().build());
  }
  public TemplateInstanceSpecFluentImpl.TemplateNested<A> editOrNewTemplateLike(Template item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TemplateInstanceSpecFluentImpl that = (TemplateInstanceSpecFluentImpl) o;
    if (!java.util.Objects.equals(requester, that.requester)) return false;

    if (!java.util.Objects.equals(secret, that.secret)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(requester,  secret,  template,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (requester != null) { sb.append("requester:"); sb.append(requester + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RequesterNestedImpl<N> extends TemplateInstanceRequesterFluentImpl<TemplateInstanceSpecFluentImpl.RequesterNested<N>> implements TemplateInstanceSpecFluentImpl.RequesterNested<N>,Nested<N>{
    RequesterNestedImpl(TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    RequesterNestedImpl() {
      this.builder = new TemplateInstanceRequesterBuilder(this);
    }
    TemplateInstanceRequesterBuilder builder;
    public N and() {
      return (N) TemplateInstanceSpecFluentImpl.this.withRequester(builder.build());
    }
    public N endRequester() {
      return and();
    }
    
  }
  class SecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<TemplateInstanceSpecFluentImpl.SecretNested<N>> implements TemplateInstanceSpecFluentImpl.SecretNested<N>,Nested<N>{
    SecretNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) TemplateInstanceSpecFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends TemplateFluentImpl<TemplateInstanceSpecFluentImpl.TemplateNested<N>> implements TemplateInstanceSpecFluentImpl.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) TemplateInstanceSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}