package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TagReferenceFluentImpl<A extends TagReferenceFluent<A>> extends BaseFluent<A> implements TagReferenceFluent<A>{
  public TagReferenceFluentImpl() {
  }
  public TagReferenceFluentImpl(TagReference instance) {
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withFrom(instance.getFrom());
      this.withGeneration(instance.getGeneration());
      this.withImportPolicy(instance.getImportPolicy());
      this.withName(instance.getName());
      this.withReference(instance.getReference());
      this.withReferencePolicy(instance.getReferencePolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Map<String,String> annotations;
  private ObjectReferenceBuilder from;
  private Long generation;
  private TagImportPolicyBuilder importPolicy;
  private String name;
  private Boolean reference;
  private TagReferencePolicyBuilder referencePolicy;
  private Map<String,Object> additionalProperties;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} else { this.from = null; _visitables.get("from").remove(this.from); } return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public TagReferenceFluentImpl.FromNested<A> withNewFrom() {
    return new TagReferenceFluentImpl.FromNestedImpl();
  }
  public TagReferenceFluentImpl.FromNested<A> withNewFromLike(ObjectReference item) {
    return new TagReferenceFluentImpl.FromNestedImpl(item);
  }
  public TagReferenceFluentImpl.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public TagReferenceFluentImpl.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new ObjectReferenceBuilder().build());
  }
  public TagReferenceFluentImpl.FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public Long getGeneration() {
    return this.generation;
  }
  public A withGeneration(Long generation) {
    this.generation=generation; return (A) this;
  }
  public Boolean hasGeneration() {
    return this.generation != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImportPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagImportPolicy getImportPolicy() {
    return this.importPolicy!=null ?this.importPolicy.build():null;
  }
  public TagImportPolicy buildImportPolicy() {
    return this.importPolicy!=null ?this.importPolicy.build():null;
  }
  public A withImportPolicy(TagImportPolicy importPolicy) {
    _visitables.get("importPolicy").remove(this.importPolicy);
    if (importPolicy!=null){ this.importPolicy= new TagImportPolicyBuilder(importPolicy); _visitables.get("importPolicy").add(this.importPolicy);} else { this.importPolicy = null; _visitables.get("importPolicy").remove(this.importPolicy); } return (A) this;
  }
  public Boolean hasImportPolicy() {
    return this.importPolicy != null;
  }
  public A withNewImportPolicy(Boolean insecure,Boolean scheduled) {
    return (A)withImportPolicy(new TagImportPolicy(insecure, scheduled));
  }
  public TagReferenceFluentImpl.ImportPolicyNested<A> withNewImportPolicy() {
    return new TagReferenceFluentImpl.ImportPolicyNestedImpl();
  }
  public TagReferenceFluentImpl.ImportPolicyNested<A> withNewImportPolicyLike(TagImportPolicy item) {
    return new TagReferenceFluentImpl.ImportPolicyNestedImpl(item);
  }
  public TagReferenceFluentImpl.ImportPolicyNested<A> editImportPolicy() {
    return withNewImportPolicyLike(getImportPolicy());
  }
  public TagReferenceFluentImpl.ImportPolicyNested<A> editOrNewImportPolicy() {
    return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): new TagImportPolicyBuilder().build());
  }
  public TagReferenceFluentImpl.ImportPolicyNested<A> editOrNewImportPolicyLike(TagImportPolicy item) {
    return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public Boolean getReference() {
    return this.reference;
  }
  public A withReference(Boolean reference) {
    this.reference=reference; return (A) this;
  }
  public Boolean hasReference() {
    return this.reference != null;
  }
  
  /**
   * This method has been deprecated, please use method buildReferencePolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagReferencePolicy getReferencePolicy() {
    return this.referencePolicy!=null ?this.referencePolicy.build():null;
  }
  public TagReferencePolicy buildReferencePolicy() {
    return this.referencePolicy!=null ?this.referencePolicy.build():null;
  }
  public A withReferencePolicy(TagReferencePolicy referencePolicy) {
    _visitables.get("referencePolicy").remove(this.referencePolicy);
    if (referencePolicy!=null){ this.referencePolicy= new TagReferencePolicyBuilder(referencePolicy); _visitables.get("referencePolicy").add(this.referencePolicy);} else { this.referencePolicy = null; _visitables.get("referencePolicy").remove(this.referencePolicy); } return (A) this;
  }
  public Boolean hasReferencePolicy() {
    return this.referencePolicy != null;
  }
  public A withNewReferencePolicy(String type) {
    return (A)withReferencePolicy(new TagReferencePolicy(type));
  }
  public TagReferenceFluentImpl.ReferencePolicyNested<A> withNewReferencePolicy() {
    return new TagReferenceFluentImpl.ReferencePolicyNestedImpl();
  }
  public TagReferenceFluentImpl.ReferencePolicyNested<A> withNewReferencePolicyLike(TagReferencePolicy item) {
    return new TagReferenceFluentImpl.ReferencePolicyNestedImpl(item);
  }
  public TagReferenceFluentImpl.ReferencePolicyNested<A> editReferencePolicy() {
    return withNewReferencePolicyLike(getReferencePolicy());
  }
  public TagReferenceFluentImpl.ReferencePolicyNested<A> editOrNewReferencePolicy() {
    return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): new TagReferencePolicyBuilder().build());
  }
  public TagReferenceFluentImpl.ReferencePolicyNested<A> editOrNewReferencePolicyLike(TagReferencePolicy item) {
    return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TagReferenceFluentImpl that = (TagReferenceFluentImpl) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(from, that.from)) return false;

    if (!java.util.Objects.equals(generation, that.generation)) return false;

    if (!java.util.Objects.equals(importPolicy, that.importPolicy)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(reference, that.reference)) return false;

    if (!java.util.Objects.equals(referencePolicy, that.referencePolicy)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  from,  generation,  importPolicy,  name,  reference,  referencePolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (generation != null) { sb.append("generation:"); sb.append(generation + ","); }
    if (importPolicy != null) { sb.append("importPolicy:"); sb.append(importPolicy + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (reference != null) { sb.append("reference:"); sb.append(reference + ","); }
    if (referencePolicy != null) { sb.append("referencePolicy:"); sb.append(referencePolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReference() {
    return withReference(true);
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<TagReferenceFluentImpl.FromNested<N>> implements TagReferenceFluentImpl.FromNested<N>,Nested<N>{
    FromNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) TagReferenceFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  class ImportPolicyNestedImpl<N> extends TagImportPolicyFluentImpl<TagReferenceFluentImpl.ImportPolicyNested<N>> implements TagReferenceFluentImpl.ImportPolicyNested<N>,Nested<N>{
    ImportPolicyNestedImpl(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    ImportPolicyNestedImpl() {
      this.builder = new TagImportPolicyBuilder(this);
    }
    TagImportPolicyBuilder builder;
    public N and() {
      return (N) TagReferenceFluentImpl.this.withImportPolicy(builder.build());
    }
    public N endImportPolicy() {
      return and();
    }
    
  }
  class ReferencePolicyNestedImpl<N> extends TagReferencePolicyFluentImpl<TagReferenceFluentImpl.ReferencePolicyNested<N>> implements TagReferenceFluentImpl.ReferencePolicyNested<N>,Nested<N>{
    ReferencePolicyNestedImpl(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    ReferencePolicyNestedImpl() {
      this.builder = new TagReferencePolicyBuilder(this);
    }
    TagReferencePolicyBuilder builder;
    public N and() {
      return (N) TagReferenceFluentImpl.this.withReferencePolicy(builder.build());
    }
    public N endReferencePolicy() {
      return and();
    }
    
  }
  
}