package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectAccessReviewBuilder extends SubjectAccessReviewFluentImpl<SubjectAccessReviewBuilder> implements VisitableBuilder<SubjectAccessReview,SubjectAccessReviewBuilder>{
  public SubjectAccessReviewBuilder() {
    this(false);
  }
  public SubjectAccessReviewBuilder(Boolean validationEnabled) {
    this(new SubjectAccessReview(), validationEnabled);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectAccessReview(), validationEnabled);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,SubjectAccessReview instance) {
    this(fluent, instance, false);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,SubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withContent(instance.getContent());
      fluent.withGroups(instance.getGroups());
      fluent.withIsNonResourceURL(instance.getIsNonResourceURL());
      fluent.withKind(instance.getKind());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPath(instance.getPath());
      fluent.withResource(instance.getResource());
      fluent.withResourceAPIGroup(instance.getResourceAPIGroup());
      fluent.withResourceAPIVersion(instance.getResourceAPIVersion());
      fluent.withResourceName(instance.getResourceName());
      fluent.withScopes(instance.getScopes());
      fluent.withUser(instance.getUser());
      fluent.withVerb(instance.getVerb());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectAccessReviewBuilder(SubjectAccessReview instance) {
    this(instance,false);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withContent(instance.getContent());
      this.withGroups(instance.getGroups());
      this.withIsNonResourceURL(instance.getIsNonResourceURL());
      this.withKind(instance.getKind());
      this.withNamespace(instance.getNamespace());
      this.withPath(instance.getPath());
      this.withResource(instance.getResource());
      this.withResourceAPIGroup(instance.getResourceAPIGroup());
      this.withResourceAPIVersion(instance.getResourceAPIVersion());
      this.withResourceName(instance.getResourceName());
      this.withScopes(instance.getScopes());
      this.withUser(instance.getUser());
      this.withVerb(instance.getVerb());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectAccessReviewFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectAccessReview build() {
    SubjectAccessReview buildable = new SubjectAccessReview(fluent.getApiVersion(),fluent.getContent(),fluent.getGroups(),fluent.getIsNonResourceURL(),fluent.getKind(),fluent.getNamespace(),fluent.getPath(),fluent.getResource(),fluent.getResourceAPIGroup(),fluent.getResourceAPIVersion(),fluent.getResourceName(),fluent.getScopes(),fluent.getUser(),fluent.getVerb());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}