package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleBindingRestrictionSpecBuilder extends RoleBindingRestrictionSpecFluentImpl<RoleBindingRestrictionSpecBuilder> implements VisitableBuilder<RoleBindingRestrictionSpec,RoleBindingRestrictionSpecBuilder>{
  public RoleBindingRestrictionSpecBuilder() {
    this(false);
  }
  public RoleBindingRestrictionSpecBuilder(Boolean validationEnabled) {
    this(new RoleBindingRestrictionSpec(), validationEnabled);
  }
  public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RoleBindingRestrictionSpec(), validationEnabled);
  }
  public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent,RoleBindingRestrictionSpec instance) {
    this(fluent, instance, false);
  }
  public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent,RoleBindingRestrictionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGrouprestriction(instance.getGrouprestriction());
      fluent.withServiceaccountrestriction(instance.getServiceaccountrestriction());
      fluent.withUserrestriction(instance.getUserrestriction());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpec instance) {
    this(instance,false);
  }
  public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGrouprestriction(instance.getGrouprestriction());
      this.withServiceaccountrestriction(instance.getServiceaccountrestriction());
      this.withUserrestriction(instance.getUserrestriction());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RoleBindingRestrictionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RoleBindingRestrictionSpec build() {
    RoleBindingRestrictionSpec buildable = new RoleBindingRestrictionSpec(fluent.getGrouprestriction(),fluent.getServiceaccountrestriction(),fluent.getUserrestriction());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}