package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface OAuthAuthorizeTokenFluent<A extends OAuthAuthorizeTokenFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getClientName();
  public A withClientName(String clientName);
  public Boolean hasClientName();
  public String getCodeChallenge();
  public A withCodeChallenge(String codeChallenge);
  public Boolean hasCodeChallenge();
  public String getCodeChallengeMethod();
  public A withCodeChallengeMethod(String codeChallengeMethod);
  public Boolean hasCodeChallengeMethod();
  public Long getExpiresIn();
  public A withExpiresIn(Long expiresIn);
  public Boolean hasExpiresIn();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadata();
  public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public OAuthAuthorizeTokenFluent.MetadataNested<A> editMetadata();
  public OAuthAuthorizeTokenFluent.MetadataNested<A> editOrNewMetadata();
  public OAuthAuthorizeTokenFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public String getRedirectURI();
  public A withRedirectURI(String redirectURI);
  public Boolean hasRedirectURI();
  public A addToScopes(int index,String item);
  public A setToScopes(int index,String item);
  public A addToScopes(java.lang.String... items);
  public A addAllToScopes(Collection<String> items);
  public A removeFromScopes(java.lang.String... items);
  public A removeAllFromScopes(Collection<String> items);
  public List<String> getScopes();
  public String getScope(int index);
  public String getFirstScope();
  public String getLastScope();
  public String getMatchingScope(Predicate<String> predicate);
  public Boolean hasMatchingScope(Predicate<String> predicate);
  public A withScopes(List<String> scopes);
  public A withScopes(java.lang.String... scopes);
  public Boolean hasScopes();
  public String getState();
  public A withState(String state);
  public Boolean hasState();
  public String getUserName();
  public A withUserName(String userName);
  public Boolean hasUserName();
  public String getUserUID();
  public A withUserUID(String userUID);
  public Boolean hasUserUID();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OAuthAuthorizeTokenFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}