package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetNamespaceFluentImpl<A extends NetNamespaceFluent<A>> extends BaseFluent<A> implements NetNamespaceFluent<A>{
  public NetNamespaceFluentImpl() {
  }
  public NetNamespaceFluentImpl(NetNamespace instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withEgressIPs(instance.getEgressIPs());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withNetid(instance.getNetid());
      this.withNetname(instance.getNetname());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private List<String> egressIPs = new ArrayList<String>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private Integer netid;
  private String netname;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToEgressIPs(int index,String item) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    this.egressIPs.add(index, item);
    return (A)this;
  }
  public A setToEgressIPs(int index,String item) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    this.egressIPs.set(index, item); return (A)this;
  }
  public A addToEgressIPs(java.lang.String... items) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    for (String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  public A addAllToEgressIPs(Collection<String> items) {
    if (this.egressIPs == null) {this.egressIPs = new ArrayList<String>();}
    for (String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  public A removeFromEgressIPs(java.lang.String... items) {
    for (String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
  }
  public A removeAllFromEgressIPs(Collection<String> items) {
    for (String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
  }
  public List<String> getEgressIPs() {
    return this.egressIPs;
  }
  public String getEgressIP(int index) {
    return this.egressIPs.get(index);
  }
  public String getFirstEgressIP() {
    return this.egressIPs.get(0);
  }
  public String getLastEgressIP() {
    return this.egressIPs.get(egressIPs.size() - 1);
  }
  public String getMatchingEgressIP(Predicate<String> predicate) {
    for (String item: egressIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEgressIP(Predicate<String> predicate) {
    for (String item: egressIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgressIPs(List<String> egressIPs) {
    if (egressIPs != null) {this.egressIPs = new ArrayList(); for (String item : egressIPs){this.addToEgressIPs(item);}} else { this.egressIPs = null;} return (A) this;
  }
  public A withEgressIPs(java.lang.String... egressIPs) {
    if (this.egressIPs != null) {this.egressIPs.clear(); _visitables.remove("egressIPs"); }
    if (egressIPs != null) {for (String item :egressIPs){ this.addToEgressIPs(item);}} return (A) this;
  }
  public Boolean hasEgressIPs() {
    return egressIPs != null && !egressIPs.isEmpty();
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public NetNamespaceFluentImpl.MetadataNested<A> withNewMetadata() {
    return new NetNamespaceFluentImpl.MetadataNestedImpl();
  }
  public NetNamespaceFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new NetNamespaceFluentImpl.MetadataNestedImpl(item);
  }
  public NetNamespaceFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public NetNamespaceFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public NetNamespaceFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public Integer getNetid() {
    return this.netid;
  }
  public A withNetid(Integer netid) {
    this.netid=netid; return (A) this;
  }
  public Boolean hasNetid() {
    return this.netid != null;
  }
  public String getNetname() {
    return this.netname;
  }
  public A withNetname(String netname) {
    this.netname=netname; return (A) this;
  }
  public Boolean hasNetname() {
    return this.netname != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetNamespaceFluentImpl that = (NetNamespaceFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(egressIPs, that.egressIPs)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(netid, that.netid)) return false;

    if (!java.util.Objects.equals(netname, that.netname)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  egressIPs,  kind,  metadata,  netid,  netname,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (egressIPs != null && !egressIPs.isEmpty()) { sb.append("egressIPs:"); sb.append(egressIPs + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (netid != null) { sb.append("netid:"); sb.append(netid + ","); }
    if (netname != null) { sb.append("netname:"); sb.append(netname + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<NetNamespaceFluentImpl.MetadataNested<N>> implements NetNamespaceFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) NetNamespaceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}