package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamTagListBuilder extends ImageStreamTagListFluentImpl<ImageStreamTagListBuilder> implements VisitableBuilder<ImageStreamTagList,ImageStreamTagListBuilder>{
  public ImageStreamTagListBuilder() {
    this(false);
  }
  public ImageStreamTagListBuilder(Boolean validationEnabled) {
    this(new ImageStreamTagList(), validationEnabled);
  }
  public ImageStreamTagListBuilder(ImageStreamTagListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamTagListBuilder(ImageStreamTagListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamTagList(), validationEnabled);
  }
  public ImageStreamTagListBuilder(ImageStreamTagListFluent<?> fluent,ImageStreamTagList instance) {
    this(fluent, instance, false);
  }
  public ImageStreamTagListBuilder(ImageStreamTagListFluent<?> fluent,ImageStreamTagList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamTagListBuilder(ImageStreamTagList instance) {
    this(instance,false);
  }
  public ImageStreamTagListBuilder(ImageStreamTagList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamTagListFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamTagList build() {
    ImageStreamTagList buildable = new ImageStreamTagList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}