package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageSourceFluent<A extends ImageSourceFluent<A>> extends Fluent<A>{
  public A addToAs(int index,String item);
  public A setToAs(int index,String item);
  public A addToAs(java.lang.String... items);
  public A addAllToAs(Collection<String> items);
  public A removeFromAs(java.lang.String... items);
  public A removeAllFromAs(Collection<String> items);
  public List<String> getAs();
  public String getA(int index);
  public String getFirstA();
  public String getLastA();
  public String getMatchingA(Predicate<String> predicate);
  public Boolean hasMatchingA(Predicate<String> predicate);
  public A withAs(List<String> as);
  public A withAs(java.lang.String... as);
  public Boolean hasAs();
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getFrom();
  public ObjectReference buildFrom();
  public A withFrom(ObjectReference from);
  public Boolean hasFrom();
  public ImageSourceFluent.FromNested<A> withNewFrom();
  public ImageSourceFluent.FromNested<A> withNewFromLike(ObjectReference item);
  public ImageSourceFluent.FromNested<A> editFrom();
  public ImageSourceFluent.FromNested<A> editOrNewFrom();
  public ImageSourceFluent.FromNested<A> editOrNewFromLike(ObjectReference item);
  public A addToPaths(int index,ImageSourcePath item);
  public A setToPaths(int index,ImageSourcePath item);
  public A addToPaths(io.fabric8.openshift.api.model.ImageSourcePath... items);
  public A addAllToPaths(Collection<ImageSourcePath> items);
  public A removeFromPaths(io.fabric8.openshift.api.model.ImageSourcePath... items);
  public A removeAllFromPaths(Collection<ImageSourcePath> items);
  public A removeMatchingFromPaths(Predicate<ImageSourcePathBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPaths instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageSourcePath> getPaths();
  public List<ImageSourcePath> buildPaths();
  public ImageSourcePath buildPath(int index);
  public ImageSourcePath buildFirstPath();
  public ImageSourcePath buildLastPath();
  public ImageSourcePath buildMatchingPath(Predicate<ImageSourcePathBuilder> predicate);
  public Boolean hasMatchingPath(Predicate<ImageSourcePathBuilder> predicate);
  public A withPaths(List<ImageSourcePath> paths);
  public A withPaths(io.fabric8.openshift.api.model.ImageSourcePath... paths);
  public Boolean hasPaths();
  public A addNewPath(String destinationDir,String sourcePath);
  public ImageSourceFluent.PathsNested<A> addNewPath();
  public ImageSourceFluent.PathsNested<A> addNewPathLike(ImageSourcePath item);
  public ImageSourceFluent.PathsNested<A> setNewPathLike(int index,ImageSourcePath item);
  public ImageSourceFluent.PathsNested<A> editPath(int index);
  public ImageSourceFluent.PathsNested<A> editFirstPath();
  public ImageSourceFluent.PathsNested<A> editLastPath();
  public ImageSourceFluent.PathsNested<A> editMatchingPath(Predicate<ImageSourcePathBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPullSecret();
  public LocalObjectReference buildPullSecret();
  public A withPullSecret(LocalObjectReference pullSecret);
  public Boolean hasPullSecret();
  public A withNewPullSecret(String name);
  public ImageSourceFluent.PullSecretNested<A> withNewPullSecret();
  public ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
  public ImageSourceFluent.PullSecretNested<A> editPullSecret();
  public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecret();
  public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<ImageSourceFluent.FromNested<N>>{
    public N and();
    public N endFrom();
    
  }
  public interface PathsNested<N> extends Nested<N>,ImageSourcePathFluent<ImageSourceFluent.PathsNested<N>>{
    public N and();
    public N endPath();
    
  }
  public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<ImageSourceFluent.PullSecretNested<N>>{
    public N and();
    public N endPullSecret();
    
  }
  
}