package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupListBuilder extends GroupListFluentImpl<GroupListBuilder> implements VisitableBuilder<GroupList,GroupListBuilder>{
  public GroupListBuilder() {
    this(false);
  }
  public GroupListBuilder(Boolean validationEnabled) {
    this(new GroupList(), validationEnabled);
  }
  public GroupListBuilder(GroupListFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupListBuilder(GroupListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GroupList(), validationEnabled);
  }
  public GroupListBuilder(GroupListFluent<?> fluent,GroupList instance) {
    this(fluent, instance, false);
  }
  public GroupListBuilder(GroupListFluent<?> fluent,GroupList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GroupListBuilder(GroupList instance) {
    this(instance,false);
  }
  public GroupListBuilder(GroupList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GroupListFluent<?> fluent;
  Boolean validationEnabled;
  public GroupList build() {
    GroupList buildable = new GroupList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}