package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConfigSpecBuilder extends DeploymentConfigSpecFluentImpl<DeploymentConfigSpecBuilder> implements VisitableBuilder<DeploymentConfigSpec,DeploymentConfigSpecBuilder>{
  public DeploymentConfigSpecBuilder() {
    this(false);
  }
  public DeploymentConfigSpecBuilder(Boolean validationEnabled) {
    this(new DeploymentConfigSpec(), validationEnabled);
  }
  public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentConfigSpec(), validationEnabled);
  }
  public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent,DeploymentConfigSpec instance) {
    this(fluent, instance, false);
  }
  public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent,DeploymentConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMinReadySeconds(instance.getMinReadySeconds());
      fluent.withPaused(instance.getPaused());
      fluent.withReplicas(instance.getReplicas());
      fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      fluent.withSelector(instance.getSelector());
      fluent.withStrategy(instance.getStrategy());
      fluent.withTemplate(instance.getTemplate());
      fluent.withTest(instance.getTest());
      fluent.withTriggers(instance.getTriggers());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance) {
    this(instance,false);
  }
  public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withPaused(instance.getPaused());
      this.withReplicas(instance.getReplicas());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSelector(instance.getSelector());
      this.withStrategy(instance.getStrategy());
      this.withTemplate(instance.getTemplate());
      this.withTest(instance.getTest());
      this.withTriggers(instance.getTriggers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentConfigSpec build() {
    DeploymentConfigSpec buildable = new DeploymentConfigSpec(fluent.getMinReadySeconds(),fluent.getPaused(),fluent.getReplicas(),fluent.getRevisionHistoryLimit(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate(),fluent.getTest(),fluent.getTriggers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}