package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConfigBuilder extends DeploymentConfigFluentImpl<DeploymentConfigBuilder> implements VisitableBuilder<DeploymentConfig,DeploymentConfigBuilder>{
  public DeploymentConfigBuilder() {
    this(false);
  }
  public DeploymentConfigBuilder(Boolean validationEnabled) {
    this(new DeploymentConfig(), validationEnabled);
  }
  public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentConfig(), validationEnabled);
  }
  public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent,DeploymentConfig instance) {
    this(fluent, instance, false);
  }
  public DeploymentConfigBuilder(DeploymentConfigFluent<?> fluent,DeploymentConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConfigBuilder(DeploymentConfig instance) {
    this(instance,false);
  }
  public DeploymentConfigBuilder(DeploymentConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentConfigFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentConfig build() {
    DeploymentConfig buildable = new DeploymentConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}