package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildConfigStatusFluentImpl<A extends BuildConfigStatusFluent<A>> extends BaseFluent<A> implements BuildConfigStatusFluent<A>{
  public BuildConfigStatusFluentImpl() {
  }
  public BuildConfigStatusFluentImpl(BuildConfigStatus instance) {
    if (instance != null) {
      this.withImageChangeTriggers(instance.getImageChangeTriggers());
      this.withLastVersion(instance.getLastVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ImageChangeTriggerStatusBuilder> imageChangeTriggers = new ArrayList<ImageChangeTriggerStatusBuilder>();
  private Long lastVersion;
  private Map<String,Object> additionalProperties;
  public A addToImageChangeTriggers(int index,ImageChangeTriggerStatus item) {
    if (this.imageChangeTriggers == null) {this.imageChangeTriggers = new ArrayList<ImageChangeTriggerStatusBuilder>();}
    ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);
    if (index < 0 || index >= imageChangeTriggers.size()) { _visitables.get("imageChangeTriggers").add(builder); imageChangeTriggers.add(builder); } else { _visitables.get("imageChangeTriggers").add(index, builder); imageChangeTriggers.add(index, builder);}
    return (A)this;
  }
  public A setToImageChangeTriggers(int index,ImageChangeTriggerStatus item) {
    if (this.imageChangeTriggers == null) {this.imageChangeTriggers = new ArrayList<ImageChangeTriggerStatusBuilder>();}
    ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);
    if (index < 0 || index >= imageChangeTriggers.size()) { _visitables.get("imageChangeTriggers").add(builder); imageChangeTriggers.add(builder); } else { _visitables.get("imageChangeTriggers").set(index, builder); imageChangeTriggers.set(index, builder);}
    return (A)this;
  }
  public A addToImageChangeTriggers(io.fabric8.openshift.api.model.ImageChangeTriggerStatus... items) {
    if (this.imageChangeTriggers == null) {this.imageChangeTriggers = new ArrayList<ImageChangeTriggerStatusBuilder>();}
    for (ImageChangeTriggerStatus item : items) {ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);_visitables.get("imageChangeTriggers").add(builder);this.imageChangeTriggers.add(builder);} return (A)this;
  }
  public A addAllToImageChangeTriggers(Collection<ImageChangeTriggerStatus> items) {
    if (this.imageChangeTriggers == null) {this.imageChangeTriggers = new ArrayList<ImageChangeTriggerStatusBuilder>();}
    for (ImageChangeTriggerStatus item : items) {ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);_visitables.get("imageChangeTriggers").add(builder);this.imageChangeTriggers.add(builder);} return (A)this;
  }
  public A removeFromImageChangeTriggers(io.fabric8.openshift.api.model.ImageChangeTriggerStatus... items) {
    for (ImageChangeTriggerStatus item : items) {ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);_visitables.get("imageChangeTriggers").remove(builder);if (this.imageChangeTriggers != null) {this.imageChangeTriggers.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageChangeTriggers(Collection<ImageChangeTriggerStatus> items) {
    for (ImageChangeTriggerStatus item : items) {ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);_visitables.get("imageChangeTriggers").remove(builder);if (this.imageChangeTriggers != null) {this.imageChangeTriggers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageChangeTriggers(Predicate<ImageChangeTriggerStatusBuilder> predicate) {
    if (imageChangeTriggers == null) return (A) this;
    final Iterator<ImageChangeTriggerStatusBuilder> each = imageChangeTriggers.iterator();
    final List visitables = _visitables.get("imageChangeTriggers");
    while (each.hasNext()) {
      ImageChangeTriggerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImageChangeTriggers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageChangeTriggerStatus> getImageChangeTriggers() {
    return imageChangeTriggers != null ? build(imageChangeTriggers) : null;
  }
  public List<ImageChangeTriggerStatus> buildImageChangeTriggers() {
    return imageChangeTriggers != null ? build(imageChangeTriggers) : null;
  }
  public ImageChangeTriggerStatus buildImageChangeTrigger(int index) {
    return this.imageChangeTriggers.get(index).build();
  }
  public ImageChangeTriggerStatus buildFirstImageChangeTrigger() {
    return this.imageChangeTriggers.get(0).build();
  }
  public ImageChangeTriggerStatus buildLastImageChangeTrigger() {
    return this.imageChangeTriggers.get(imageChangeTriggers.size() - 1).build();
  }
  public ImageChangeTriggerStatus buildMatchingImageChangeTrigger(Predicate<ImageChangeTriggerStatusBuilder> predicate) {
    for (ImageChangeTriggerStatusBuilder item: imageChangeTriggers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImageChangeTrigger(Predicate<ImageChangeTriggerStatusBuilder> predicate) {
    for (ImageChangeTriggerStatusBuilder item: imageChangeTriggers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImageChangeTriggers(List<ImageChangeTriggerStatus> imageChangeTriggers) {
    if (this.imageChangeTriggers != null) { _visitables.get("imageChangeTriggers").clear();}
    if (imageChangeTriggers != null) {this.imageChangeTriggers = new ArrayList(); for (ImageChangeTriggerStatus item : imageChangeTriggers){this.addToImageChangeTriggers(item);}} else { this.imageChangeTriggers = null;} return (A) this;
  }
  public A withImageChangeTriggers(io.fabric8.openshift.api.model.ImageChangeTriggerStatus... imageChangeTriggers) {
    if (this.imageChangeTriggers != null) {this.imageChangeTriggers.clear(); _visitables.remove("imageChangeTriggers"); }
    if (imageChangeTriggers != null) {for (ImageChangeTriggerStatus item :imageChangeTriggers){ this.addToImageChangeTriggers(item);}} return (A) this;
  }
  public Boolean hasImageChangeTriggers() {
    return imageChangeTriggers != null && !imageChangeTriggers.isEmpty();
  }
  public BuildConfigStatusFluentImpl.ImageChangeTriggersNested<A> addNewImageChangeTrigger() {
    return new BuildConfigStatusFluentImpl.ImageChangeTriggersNestedImpl();
  }
  public BuildConfigStatusFluentImpl.ImageChangeTriggersNested<A> addNewImageChangeTriggerLike(ImageChangeTriggerStatus item) {
    return new BuildConfigStatusFluentImpl.ImageChangeTriggersNestedImpl(-1, item);
  }
  public BuildConfigStatusFluentImpl.ImageChangeTriggersNested<A> setNewImageChangeTriggerLike(int index,ImageChangeTriggerStatus item) {
    return new BuildConfigStatusFluentImpl.ImageChangeTriggersNestedImpl(index, item);
  }
  public BuildConfigStatusFluentImpl.ImageChangeTriggersNested<A> editImageChangeTrigger(int index) {
    if (imageChangeTriggers.size() <= index) throw new RuntimeException("Can't edit imageChangeTriggers. Index exceeds size.");
    return setNewImageChangeTriggerLike(index, buildImageChangeTrigger(index));
  }
  public BuildConfigStatusFluentImpl.ImageChangeTriggersNested<A> editFirstImageChangeTrigger() {
    if (imageChangeTriggers.size() == 0) throw new RuntimeException("Can't edit first imageChangeTriggers. The list is empty.");
    return setNewImageChangeTriggerLike(0, buildImageChangeTrigger(0));
  }
  public BuildConfigStatusFluentImpl.ImageChangeTriggersNested<A> editLastImageChangeTrigger() {
    int index = imageChangeTriggers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageChangeTriggers. The list is empty.");
    return setNewImageChangeTriggerLike(index, buildImageChangeTrigger(index));
  }
  public BuildConfigStatusFluentImpl.ImageChangeTriggersNested<A> editMatchingImageChangeTrigger(Predicate<ImageChangeTriggerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageChangeTriggers.size();i++) { 
    if (predicate.test(imageChangeTriggers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageChangeTriggers. No match found.");
    return setNewImageChangeTriggerLike(index, buildImageChangeTrigger(index));
  }
  public Long getLastVersion() {
    return this.lastVersion;
  }
  public A withLastVersion(Long lastVersion) {
    this.lastVersion=lastVersion; return (A) this;
  }
  public Boolean hasLastVersion() {
    return this.lastVersion != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildConfigStatusFluentImpl that = (BuildConfigStatusFluentImpl) o;
    if (!java.util.Objects.equals(imageChangeTriggers, that.imageChangeTriggers)) return false;

    if (!java.util.Objects.equals(lastVersion, that.lastVersion)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(imageChangeTriggers,  lastVersion,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (imageChangeTriggers != null && !imageChangeTriggers.isEmpty()) { sb.append("imageChangeTriggers:"); sb.append(imageChangeTriggers + ","); }
    if (lastVersion != null) { sb.append("lastVersion:"); sb.append(lastVersion + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageChangeTriggersNestedImpl<N> extends ImageChangeTriggerStatusFluentImpl<BuildConfigStatusFluentImpl.ImageChangeTriggersNested<N>> implements BuildConfigStatusFluentImpl.ImageChangeTriggersNested<N>,Nested<N>{
    ImageChangeTriggersNestedImpl(int index,ImageChangeTriggerStatus item) {
      this.index = index;
      this.builder = new ImageChangeTriggerStatusBuilder(this, item);
    }
    ImageChangeTriggersNestedImpl() {
      this.index = -1;
      this.builder = new ImageChangeTriggerStatusBuilder(this);
    }
    ImageChangeTriggerStatusBuilder builder;
    int index;
    public N and() {
      return (N) BuildConfigStatusFluentImpl.this.setToImageChangeTriggers(index,builder.build());
    }
    public N endImageChangeTrigger() {
      return and();
    }
    
  }
  
}