package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerTemplateInstanceBuilder extends BrokerTemplateInstanceFluentImpl<BrokerTemplateInstanceBuilder> implements VisitableBuilder<BrokerTemplateInstance,BrokerTemplateInstanceBuilder>{
  public BrokerTemplateInstanceBuilder() {
    this(false);
  }
  public BrokerTemplateInstanceBuilder(Boolean validationEnabled) {
    this(new BrokerTemplateInstance(), validationEnabled);
  }
  public BrokerTemplateInstanceBuilder(BrokerTemplateInstanceFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerTemplateInstanceBuilder(BrokerTemplateInstanceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BrokerTemplateInstance(), validationEnabled);
  }
  public BrokerTemplateInstanceBuilder(BrokerTemplateInstanceFluent<?> fluent,BrokerTemplateInstance instance) {
    this(fluent, instance, false);
  }
  public BrokerTemplateInstanceBuilder(BrokerTemplateInstanceFluent<?> fluent,BrokerTemplateInstance instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BrokerTemplateInstanceBuilder(BrokerTemplateInstance instance) {
    this(instance,false);
  }
  public BrokerTemplateInstanceBuilder(BrokerTemplateInstance instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BrokerTemplateInstanceFluent<?> fluent;
  Boolean validationEnabled;
  public BrokerTemplateInstance build() {
    BrokerTemplateInstance buildable = new BrokerTemplateInstance(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}