package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RepositoryImportSpecBuilder extends RepositoryImportSpecFluentImpl<RepositoryImportSpecBuilder> implements VisitableBuilder<RepositoryImportSpec,RepositoryImportSpecBuilder>{
  public RepositoryImportSpecBuilder() {
    this(false);
  }
  public RepositoryImportSpecBuilder(Boolean validationEnabled) {
    this(new RepositoryImportSpec(), validationEnabled);
  }
  public RepositoryImportSpecBuilder(RepositoryImportSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RepositoryImportSpecBuilder(RepositoryImportSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RepositoryImportSpec(), validationEnabled);
  }
  public RepositoryImportSpecBuilder(RepositoryImportSpecFluent<?> fluent,RepositoryImportSpec instance) {
    this(fluent, instance, false);
  }
  public RepositoryImportSpecBuilder(RepositoryImportSpecFluent<?> fluent,RepositoryImportSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFrom(instance.getFrom()); 
    fluent.withImportPolicy(instance.getImportPolicy()); 
    fluent.withIncludeManifest(instance.getIncludeManifest()); 
    fluent.withReferencePolicy(instance.getReferencePolicy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RepositoryImportSpecBuilder(RepositoryImportSpec instance) {
    this(instance,false);
  }
  public RepositoryImportSpecBuilder(RepositoryImportSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFrom(instance.getFrom()); 
    this.withImportPolicy(instance.getImportPolicy()); 
    this.withIncludeManifest(instance.getIncludeManifest()); 
    this.withReferencePolicy(instance.getReferencePolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RepositoryImportSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RepositoryImportSpec build() {
    RepositoryImportSpec buildable = new RepositoryImportSpec(fluent.getFrom(),fluent.getImportPolicy(),fluent.getIncludeManifest(),fluent.getReferencePolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}