package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalSubjectAccessReviewBuilder extends LocalSubjectAccessReviewFluentImpl<LocalSubjectAccessReviewBuilder> implements VisitableBuilder<LocalSubjectAccessReview,LocalSubjectAccessReviewBuilder>{
  public LocalSubjectAccessReviewBuilder() {
    this(false);
  }
  public LocalSubjectAccessReviewBuilder(Boolean validationEnabled) {
    this(new LocalSubjectAccessReview(), validationEnabled);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LocalSubjectAccessReview(), validationEnabled);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReviewFluent<?> fluent,LocalSubjectAccessReview instance) {
    this(fluent, instance, false);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReviewFluent<?> fluent,LocalSubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withContent(instance.getContent()); 
    fluent.withGroups(instance.getGroups()); 
    fluent.withIsNonResourceURL(instance.getIsNonResourceURL()); 
    fluent.withKind(instance.getKind()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPath(instance.getPath()); 
    fluent.withResource(instance.getResource()); 
    fluent.withResourceAPIGroup(instance.getResourceAPIGroup()); 
    fluent.withResourceAPIVersion(instance.getResourceAPIVersion()); 
    fluent.withResourceName(instance.getResourceName()); 
    fluent.withScopes(instance.getScopes()); 
    fluent.withUser(instance.getUser()); 
    fluent.withVerb(instance.getVerb()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReview instance) {
    this(instance,false);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withContent(instance.getContent()); 
    this.withGroups(instance.getGroups()); 
    this.withIsNonResourceURL(instance.getIsNonResourceURL()); 
    this.withKind(instance.getKind()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withResource(instance.getResource()); 
    this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
    this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
    this.withResourceName(instance.getResourceName()); 
    this.withScopes(instance.getScopes()); 
    this.withUser(instance.getUser()); 
    this.withVerb(instance.getVerb()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  LocalSubjectAccessReviewFluent<?> fluent;
  Boolean validationEnabled;
  public LocalSubjectAccessReview build() {
    LocalSubjectAccessReview buildable = new LocalSubjectAccessReview(fluent.getApiVersion(),fluent.getContent(),fluent.getGroups(),fluent.getIsNonResourceURL(),fluent.getKind(),fluent.getNamespace(),fluent.getPath(),fluent.getResource(),fluent.getResourceAPIGroup(),fluent.getResourceAPIVersion(),fluent.getResourceName(),fluent.getScopes(),fluent.getUser(),fluent.getVerb());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}