package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageChangeTriggerStatusFluentImpl<A extends ImageChangeTriggerStatusFluent<A>> extends BaseFluent<A> implements ImageChangeTriggerStatusFluent<A>{
  public ImageChangeTriggerStatusFluentImpl() {
  }
  public ImageChangeTriggerStatusFluentImpl(ImageChangeTriggerStatus instance) {
    this.withFrom(instance.getFrom()); 
    this.withLastTriggerTime(instance.getLastTriggerTime()); 
    this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ImageStreamTagReferenceBuilder from;
  private String lastTriggerTime;
  private String lastTriggeredImageID;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageStreamTagReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public ImageStreamTagReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(ImageStreamTagReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ImageStreamTagReferenceBuilder(from); _visitables.get("from").add(this.from);} else { this.from = null; _visitables.get("from").remove(this.from); } return (A) this;
  }
  public Boolean hasFrom() {
    return this.from != null;
  }
  public A withNewFrom(String name,String namespace) {
    return (A)withFrom(new ImageStreamTagReference(name, namespace));
  }
  public ImageChangeTriggerStatusFluent.FromNested<A> withNewFrom() {
    return new ImageChangeTriggerStatusFluentImpl.FromNestedImpl();
  }
  public ImageChangeTriggerStatusFluent.FromNested<A> withNewFromLike(ImageStreamTagReference item) {
    return new ImageChangeTriggerStatusFluentImpl.FromNestedImpl(item);
  }
  public ImageChangeTriggerStatusFluent.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public ImageChangeTriggerStatusFluent.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new ImageStreamTagReferenceBuilder().build());
  }
  public ImageChangeTriggerStatusFluent.FromNested<A> editOrNewFromLike(ImageStreamTagReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public String getLastTriggerTime() {
    return this.lastTriggerTime;
  }
  public A withLastTriggerTime(String lastTriggerTime) {
    this.lastTriggerTime=lastTriggerTime; return (A) this;
  }
  public Boolean hasLastTriggerTime() {
    return this.lastTriggerTime != null;
  }
  public String getLastTriggeredImageID() {
    return this.lastTriggeredImageID;
  }
  public A withLastTriggeredImageID(String lastTriggeredImageID) {
    this.lastTriggeredImageID=lastTriggeredImageID; return (A) this;
  }
  public Boolean hasLastTriggeredImageID() {
    return this.lastTriggeredImageID != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageChangeTriggerStatusFluentImpl that = (ImageChangeTriggerStatusFluentImpl) o;
    if (from != null ? !from.equals(that.from) :that.from != null) return false;
    if (lastTriggerTime != null ? !lastTriggerTime.equals(that.lastTriggerTime) :that.lastTriggerTime != null) return false;
    if (lastTriggeredImageID != null ? !lastTriggeredImageID.equals(that.lastTriggeredImageID) :that.lastTriggeredImageID != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(from,  lastTriggerTime,  lastTriggeredImageID,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (lastTriggerTime != null) { sb.append("lastTriggerTime:"); sb.append(lastTriggerTime + ","); }
    if (lastTriggeredImageID != null) { sb.append("lastTriggeredImageID:"); sb.append(lastTriggeredImageID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class FromNestedImpl<N> extends ImageStreamTagReferenceFluentImpl<ImageChangeTriggerStatusFluent.FromNested<N>> implements ImageChangeTriggerStatusFluent.FromNested<N>,Nested<N>{
    FromNestedImpl(ImageStreamTagReference item) {
      this.builder = new ImageStreamTagReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new ImageStreamTagReferenceBuilder(this);
    }
    ImageStreamTagReferenceBuilder builder;
    public N and() {
      return (N) ImageChangeTriggerStatusFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  
}