package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeploymentStrategyFluentImpl<A extends DeploymentStrategyFluent<A>> extends BaseFluent<A> implements DeploymentStrategyFluent<A>{
  public DeploymentStrategyFluentImpl() {
  }
  public DeploymentStrategyFluentImpl(DeploymentStrategy instance) {
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withCustomParams(instance.getCustomParams()); 
    this.withLabels(instance.getLabels()); 
    this.withRecreateParams(instance.getRecreateParams()); 
    this.withResources(instance.getResources()); 
    this.withRollingParams(instance.getRollingParams()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Long activeDeadlineSeconds;
  private Map<String,String> annotations;
  private CustomDeploymentStrategyParamsBuilder customParams;
  private Map<String,String> labels;
  private RecreateDeploymentStrategyParamsBuilder recreateParams;
  private ResourceRequirementsBuilder resources;
  private RollingDeploymentStrategyParamsBuilder rollingParams;
  private String type;
  private Map<String,Object> additionalProperties;
  public Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
  }
  public Boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCustomParams instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomDeploymentStrategyParams getCustomParams() {
    return this.customParams!=null ?this.customParams.build():null;
  }
  public CustomDeploymentStrategyParams buildCustomParams() {
    return this.customParams!=null ?this.customParams.build():null;
  }
  public A withCustomParams(CustomDeploymentStrategyParams customParams) {
    _visitables.get("customParams").remove(this.customParams);
    if (customParams!=null){ this.customParams= new CustomDeploymentStrategyParamsBuilder(customParams); _visitables.get("customParams").add(this.customParams);} else { this.customParams = null; _visitables.get("customParams").remove(this.customParams); } return (A) this;
  }
  public Boolean hasCustomParams() {
    return this.customParams != null;
  }
  public DeploymentStrategyFluent.CustomParamsNested<A> withNewCustomParams() {
    return new DeploymentStrategyFluentImpl.CustomParamsNestedImpl();
  }
  public DeploymentStrategyFluent.CustomParamsNested<A> withNewCustomParamsLike(CustomDeploymentStrategyParams item) {
    return new DeploymentStrategyFluentImpl.CustomParamsNestedImpl(item);
  }
  public DeploymentStrategyFluent.CustomParamsNested<A> editCustomParams() {
    return withNewCustomParamsLike(getCustomParams());
  }
  public DeploymentStrategyFluent.CustomParamsNested<A> editOrNewCustomParams() {
    return withNewCustomParamsLike(getCustomParams() != null ? getCustomParams(): new CustomDeploymentStrategyParamsBuilder().build());
  }
  public DeploymentStrategyFluent.CustomParamsNested<A> editOrNewCustomParamsLike(CustomDeploymentStrategyParams item) {
    return withNewCustomParamsLike(getCustomParams() != null ? getCustomParams(): item);
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public Boolean hasLabels() {
    return this.labels != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRecreateParams instead.
   * @return The buildable object.
   */
  @Deprecated
  public RecreateDeploymentStrategyParams getRecreateParams() {
    return this.recreateParams!=null ?this.recreateParams.build():null;
  }
  public RecreateDeploymentStrategyParams buildRecreateParams() {
    return this.recreateParams!=null ?this.recreateParams.build():null;
  }
  public A withRecreateParams(RecreateDeploymentStrategyParams recreateParams) {
    _visitables.get("recreateParams").remove(this.recreateParams);
    if (recreateParams!=null){ this.recreateParams= new RecreateDeploymentStrategyParamsBuilder(recreateParams); _visitables.get("recreateParams").add(this.recreateParams);} else { this.recreateParams = null; _visitables.get("recreateParams").remove(this.recreateParams); } return (A) this;
  }
  public Boolean hasRecreateParams() {
    return this.recreateParams != null;
  }
  public DeploymentStrategyFluent.RecreateParamsNested<A> withNewRecreateParams() {
    return new DeploymentStrategyFluentImpl.RecreateParamsNestedImpl();
  }
  public DeploymentStrategyFluent.RecreateParamsNested<A> withNewRecreateParamsLike(RecreateDeploymentStrategyParams item) {
    return new DeploymentStrategyFluentImpl.RecreateParamsNestedImpl(item);
  }
  public DeploymentStrategyFluent.RecreateParamsNested<A> editRecreateParams() {
    return withNewRecreateParamsLike(getRecreateParams());
  }
  public DeploymentStrategyFluent.RecreateParamsNested<A> editOrNewRecreateParams() {
    return withNewRecreateParamsLike(getRecreateParams() != null ? getRecreateParams(): new RecreateDeploymentStrategyParamsBuilder().build());
  }
  public DeploymentStrategyFluent.RecreateParamsNested<A> editOrNewRecreateParamsLike(RecreateDeploymentStrategyParams item) {
    return withNewRecreateParamsLike(getRecreateParams() != null ? getRecreateParams(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public DeploymentStrategyFluent.ResourcesNested<A> withNewResources() {
    return new DeploymentStrategyFluentImpl.ResourcesNestedImpl();
  }
  public DeploymentStrategyFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new DeploymentStrategyFluentImpl.ResourcesNestedImpl(item);
  }
  public DeploymentStrategyFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public DeploymentStrategyFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public DeploymentStrategyFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRollingParams instead.
   * @return The buildable object.
   */
  @Deprecated
  public RollingDeploymentStrategyParams getRollingParams() {
    return this.rollingParams!=null ?this.rollingParams.build():null;
  }
  public RollingDeploymentStrategyParams buildRollingParams() {
    return this.rollingParams!=null ?this.rollingParams.build():null;
  }
  public A withRollingParams(RollingDeploymentStrategyParams rollingParams) {
    _visitables.get("rollingParams").remove(this.rollingParams);
    if (rollingParams!=null){ this.rollingParams= new RollingDeploymentStrategyParamsBuilder(rollingParams); _visitables.get("rollingParams").add(this.rollingParams);} else { this.rollingParams = null; _visitables.get("rollingParams").remove(this.rollingParams); } return (A) this;
  }
  public Boolean hasRollingParams() {
    return this.rollingParams != null;
  }
  public DeploymentStrategyFluent.RollingParamsNested<A> withNewRollingParams() {
    return new DeploymentStrategyFluentImpl.RollingParamsNestedImpl();
  }
  public DeploymentStrategyFluent.RollingParamsNested<A> withNewRollingParamsLike(RollingDeploymentStrategyParams item) {
    return new DeploymentStrategyFluentImpl.RollingParamsNestedImpl(item);
  }
  public DeploymentStrategyFluent.RollingParamsNested<A> editRollingParams() {
    return withNewRollingParamsLike(getRollingParams());
  }
  public DeploymentStrategyFluent.RollingParamsNested<A> editOrNewRollingParams() {
    return withNewRollingParamsLike(getRollingParams() != null ? getRollingParams(): new RollingDeploymentStrategyParamsBuilder().build());
  }
  public DeploymentStrategyFluent.RollingParamsNested<A> editOrNewRollingParamsLike(RollingDeploymentStrategyParams item) {
    return withNewRollingParamsLike(getRollingParams() != null ? getRollingParams(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeploymentStrategyFluentImpl that = (DeploymentStrategyFluentImpl) o;
    if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (customParams != null ? !customParams.equals(that.customParams) :that.customParams != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (recreateParams != null ? !recreateParams.equals(that.recreateParams) :that.recreateParams != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (rollingParams != null ? !rollingParams.equals(that.rollingParams) :that.rollingParams != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(activeDeadlineSeconds,  annotations,  customParams,  labels,  recreateParams,  resources,  rollingParams,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeDeadlineSeconds != null) { sb.append("activeDeadlineSeconds:"); sb.append(activeDeadlineSeconds + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (customParams != null) { sb.append("customParams:"); sb.append(customParams + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (recreateParams != null) { sb.append("recreateParams:"); sb.append(recreateParams + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (rollingParams != null) { sb.append("rollingParams:"); sb.append(rollingParams + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CustomParamsNestedImpl<N> extends CustomDeploymentStrategyParamsFluentImpl<DeploymentStrategyFluent.CustomParamsNested<N>> implements DeploymentStrategyFluent.CustomParamsNested<N>,Nested<N>{
    CustomParamsNestedImpl(CustomDeploymentStrategyParams item) {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
    }
    CustomParamsNestedImpl() {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this);
    }
    CustomDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) DeploymentStrategyFluentImpl.this.withCustomParams(builder.build());
    }
    public N endCustomParams() {
      return and();
    }
    
  }
  class RecreateParamsNestedImpl<N> extends RecreateDeploymentStrategyParamsFluentImpl<DeploymentStrategyFluent.RecreateParamsNested<N>> implements DeploymentStrategyFluent.RecreateParamsNested<N>,Nested<N>{
    RecreateParamsNestedImpl(RecreateDeploymentStrategyParams item) {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
    }
    RecreateParamsNestedImpl() {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this);
    }
    RecreateDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) DeploymentStrategyFluentImpl.this.withRecreateParams(builder.build());
    }
    public N endRecreateParams() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<DeploymentStrategyFluent.ResourcesNested<N>> implements DeploymentStrategyFluent.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) DeploymentStrategyFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class RollingParamsNestedImpl<N> extends RollingDeploymentStrategyParamsFluentImpl<DeploymentStrategyFluent.RollingParamsNested<N>> implements DeploymentStrategyFluent.RollingParamsNested<N>,Nested<N>{
    RollingParamsNestedImpl(RollingDeploymentStrategyParams item) {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
    }
    RollingParamsNestedImpl() {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this);
    }
    RollingDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) DeploymentStrategyFluentImpl.this.withRollingParams(builder.build());
    }
    public N endRollingParams() {
      return and();
    }
    
  }
  
}