package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterRoleBindingFluentImpl<A extends ClusterRoleBindingFluent<A>> extends BaseFluent<A> implements ClusterRoleBindingFluent<A>{
  public ClusterRoleBindingFluentImpl() {
  }
  public ClusterRoleBindingFluentImpl(ClusterRoleBinding instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroupNames(instance.getGroupNames()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRoleRef(instance.getRoleRef()); 
    this.withSubjects(instance.getSubjects()); 
    this.withUserNames(instance.getUserNames()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private List<String> groupNames = new ArrayList<String>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private ObjectReferenceBuilder roleRef;
  private ArrayList<ObjectReferenceBuilder> subjects = new ArrayList<ObjectReferenceBuilder>();
  private List<String> userNames = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToGroupNames(Integer index,String item) {
    if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
    this.groupNames.add(index, item);
    return (A)this;
  }
  public A setToGroupNames(Integer index,String item) {
    if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
    this.groupNames.set(index, item); return (A)this;
  }
  public A addToGroupNames(java.lang.String... items) {
    if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
    for (String item : items) {this.groupNames.add(item);} return (A)this;
  }
  public A addAllToGroupNames(Collection<String> items) {
    if (this.groupNames == null) {this.groupNames = new ArrayList<String>();}
    for (String item : items) {this.groupNames.add(item);} return (A)this;
  }
  public A removeFromGroupNames(java.lang.String... items) {
    for (String item : items) {if (this.groupNames!= null){ this.groupNames.remove(item);}} return (A)this;
  }
  public A removeAllFromGroupNames(Collection<String> items) {
    for (String item : items) {if (this.groupNames!= null){ this.groupNames.remove(item);}} return (A)this;
  }
  public List<String> getGroupNames() {
    return this.groupNames;
  }
  public String getGroupName(Integer index) {
    return this.groupNames.get(index);
  }
  public String getFirstGroupName() {
    return this.groupNames.get(0);
  }
  public String getLastGroupName() {
    return this.groupNames.get(groupNames.size() - 1);
  }
  public String getMatchingGroupName(Predicate<String> predicate) {
    for (String item: groupNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroupName(Predicate<String> predicate) {
    for (String item: groupNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroupNames(List<String> groupNames) {
    if (groupNames != null) {this.groupNames = new ArrayList(); for (String item : groupNames){this.addToGroupNames(item);}} else { this.groupNames = null;} return (A) this;
  }
  public A withGroupNames(java.lang.String... groupNames) {
    if (this.groupNames != null) {this.groupNames.clear();}
    if (groupNames != null) {for (String item :groupNames){ this.addToGroupNames(item);}} return (A) this;
  }
  public Boolean hasGroupNames() {
    return groupNames != null && !groupNames.isEmpty();
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ClusterRoleBindingFluent.MetadataNested<A> withNewMetadata() {
    return new ClusterRoleBindingFluentImpl.MetadataNestedImpl();
  }
  public ClusterRoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ClusterRoleBindingFluentImpl.MetadataNestedImpl(item);
  }
  public ClusterRoleBindingFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRoleRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getRoleRef() {
    return this.roleRef!=null ?this.roleRef.build():null;
  }
  public ObjectReference buildRoleRef() {
    return this.roleRef!=null ?this.roleRef.build():null;
  }
  public A withRoleRef(ObjectReference roleRef) {
    _visitables.get("roleRef").remove(this.roleRef);
    if (roleRef!=null){ this.roleRef= new ObjectReferenceBuilder(roleRef); _visitables.get("roleRef").add(this.roleRef);} else { this.roleRef = null; _visitables.get("roleRef").remove(this.roleRef); } return (A) this;
  }
  public Boolean hasRoleRef() {
    return this.roleRef != null;
  }
  public ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
    return new ClusterRoleBindingFluentImpl.RoleRefNestedImpl();
  }
  public ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item) {
    return new ClusterRoleBindingFluentImpl.RoleRefNestedImpl(item);
  }
  public ClusterRoleBindingFluent.RoleRefNested<A> editRoleRef() {
    return withNewRoleRefLike(getRoleRef());
  }
  public ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
    return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): new ObjectReferenceBuilder().build());
  }
  public ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item) {
    return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): item);
  }
  public A addToSubjects(Integer index,ObjectReference item) {
    if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").add(index >= 0 ? index : _visitables.get("subjects").size(), builder);this.subjects.add(index >= 0 ? index : subjects.size(), builder); return (A)this;
  }
  public A setToSubjects(Integer index,ObjectReference item) {
    if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("subjects").size()) { _visitables.get("subjects").add(builder); } else { _visitables.get("subjects").set(index, builder);}
    if (index < 0 || index >= subjects.size()) { subjects.add(builder); } else { subjects.set(index, builder);}
     return (A)this;
  }
  public A addToSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A addAllToSubjects(Collection<ObjectReference> items) {
    if (this.subjects == null) {this.subjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubjects(Collection<ObjectReference> items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubjects(Predicate<ObjectReferenceBuilder> predicate) {
    if (subjects == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = subjects.iterator();
    final List visitables = _visitables.get("subjects");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ObjectReference> getSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  public List<ObjectReference> buildSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  public ObjectReference buildSubject(Integer index) {
    return this.subjects.get(index).build();
  }
  public ObjectReference buildFirstSubject() {
    return this.subjects.get(0).build();
  }
  public ObjectReference buildLastSubject() {
    return this.subjects.get(subjects.size() - 1).build();
  }
  public ObjectReference buildMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: subjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjects(List<ObjectReference> subjects) {
    if (this.subjects != null) { _visitables.get("subjects").removeAll(this.subjects);}
    if (subjects != null) {this.subjects = new ArrayList(); for (ObjectReference item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  public A withSubjects(io.fabric8.kubernetes.api.model.ObjectReference... subjects) {
    if (this.subjects != null) {this.subjects.clear();}
    if (subjects != null) {for (ObjectReference item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  public Boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  public ClusterRoleBindingFluent.SubjectsNested<A> addNewSubject() {
    return new ClusterRoleBindingFluentImpl.SubjectsNestedImpl();
  }
  public ClusterRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item) {
    return new ClusterRoleBindingFluentImpl.SubjectsNestedImpl(-1, item);
  }
  public ClusterRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(Integer index,ObjectReference item) {
    return new ClusterRoleBindingFluentImpl.SubjectsNestedImpl(index, item);
  }
  public ClusterRoleBindingFluent.SubjectsNested<A> editSubject(Integer index) {
    if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public ClusterRoleBindingFluent.SubjectsNested<A> editFirstSubject() {
    if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
    return setNewSubjectLike(0, buildSubject(0));
  }
  public ClusterRoleBindingFluent.SubjectsNested<A> editLastSubject() {
    int index = subjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public ClusterRoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subjects.size();i++) { 
    if (predicate.test(subjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public A addToUserNames(Integer index,String item) {
    if (this.userNames == null) {this.userNames = new ArrayList<String>();}
    this.userNames.add(index, item);
    return (A)this;
  }
  public A setToUserNames(Integer index,String item) {
    if (this.userNames == null) {this.userNames = new ArrayList<String>();}
    this.userNames.set(index, item); return (A)this;
  }
  public A addToUserNames(java.lang.String... items) {
    if (this.userNames == null) {this.userNames = new ArrayList<String>();}
    for (String item : items) {this.userNames.add(item);} return (A)this;
  }
  public A addAllToUserNames(Collection<String> items) {
    if (this.userNames == null) {this.userNames = new ArrayList<String>();}
    for (String item : items) {this.userNames.add(item);} return (A)this;
  }
  public A removeFromUserNames(java.lang.String... items) {
    for (String item : items) {if (this.userNames!= null){ this.userNames.remove(item);}} return (A)this;
  }
  public A removeAllFromUserNames(Collection<String> items) {
    for (String item : items) {if (this.userNames!= null){ this.userNames.remove(item);}} return (A)this;
  }
  public List<String> getUserNames() {
    return this.userNames;
  }
  public String getUserName(Integer index) {
    return this.userNames.get(index);
  }
  public String getFirstUserName() {
    return this.userNames.get(0);
  }
  public String getLastUserName() {
    return this.userNames.get(userNames.size() - 1);
  }
  public String getMatchingUserName(Predicate<String> predicate) {
    for (String item: userNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUserName(Predicate<String> predicate) {
    for (String item: userNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUserNames(List<String> userNames) {
    if (userNames != null) {this.userNames = new ArrayList(); for (String item : userNames){this.addToUserNames(item);}} else { this.userNames = null;} return (A) this;
  }
  public A withUserNames(java.lang.String... userNames) {
    if (this.userNames != null) {this.userNames.clear();}
    if (userNames != null) {for (String item :userNames){ this.addToUserNames(item);}} return (A) this;
  }
  public Boolean hasUserNames() {
    return userNames != null && !userNames.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterRoleBindingFluentImpl that = (ClusterRoleBindingFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (groupNames != null ? !groupNames.equals(that.groupNames) :that.groupNames != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
    if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
    if (userNames != null ? !userNames.equals(that.userNames) :that.userNames != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  groupNames,  kind,  metadata,  roleRef,  subjects,  userNames,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (groupNames != null && !groupNames.isEmpty()) { sb.append("groupNames:"); sb.append(groupNames + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (roleRef != null) { sb.append("roleRef:"); sb.append(roleRef + ","); }
    if (subjects != null && !subjects.isEmpty()) { sb.append("subjects:"); sb.append(subjects + ","); }
    if (userNames != null && !userNames.isEmpty()) { sb.append("userNames:"); sb.append(userNames + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ClusterRoleBindingFluent.MetadataNested<N>> implements ClusterRoleBindingFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ClusterRoleBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class RoleRefNestedImpl<N> extends ObjectReferenceFluentImpl<ClusterRoleBindingFluent.RoleRefNested<N>> implements ClusterRoleBindingFluent.RoleRefNested<N>,Nested<N>{
    RoleRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    RoleRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterRoleBindingFluentImpl.this.withRoleRef(builder.build());
    }
    public N endRoleRef() {
      return and();
    }
    
  }
  class SubjectsNestedImpl<N> extends ObjectReferenceFluentImpl<ClusterRoleBindingFluent.SubjectsNested<N>> implements ClusterRoleBindingFluent.SubjectsNested<N>,Nested<N>{
    SubjectsNestedImpl(Integer index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    SubjectsNestedImpl() {
      this.index = -1;
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterRoleBindingFluentImpl.this.setToSubjects(index,builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}