package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectAccessReviewResponseBuilder extends SubjectAccessReviewResponseFluentImpl<SubjectAccessReviewResponseBuilder> implements VisitableBuilder<SubjectAccessReviewResponse,SubjectAccessReviewResponseBuilder>{
  public SubjectAccessReviewResponseBuilder() {
    this(false);
  }
  public SubjectAccessReviewResponseBuilder(Boolean validationEnabled) {
    this(new SubjectAccessReviewResponse(), validationEnabled);
  }
  public SubjectAccessReviewResponseBuilder(SubjectAccessReviewResponseFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectAccessReviewResponseBuilder(SubjectAccessReviewResponseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectAccessReviewResponse(), validationEnabled);
  }
  public SubjectAccessReviewResponseBuilder(SubjectAccessReviewResponseFluent<?> fluent,SubjectAccessReviewResponse instance) {
    this(fluent, instance, false);
  }
  public SubjectAccessReviewResponseBuilder(SubjectAccessReviewResponseFluent<?> fluent,SubjectAccessReviewResponse instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowed(instance.getAllowed()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withEvaluationError(instance.getEvaluationError()); 
    fluent.withKind(instance.getKind()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withReason(instance.getReason()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SubjectAccessReviewResponseBuilder(SubjectAccessReviewResponse instance) {
    this(instance,false);
  }
  public SubjectAccessReviewResponseBuilder(SubjectAccessReviewResponse instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowed(instance.getAllowed()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withEvaluationError(instance.getEvaluationError()); 
    this.withKind(instance.getKind()); 
    this.withNamespace(instance.getNamespace()); 
    this.withReason(instance.getReason()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SubjectAccessReviewResponseFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectAccessReviewResponse build() {
    SubjectAccessReviewResponse buildable = new SubjectAccessReviewResponse(fluent.getAllowed(),fluent.getApiVersion(),fluent.getEvaluationError(),fluent.getKind(),fluent.getNamespace(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}