package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface SecurityContextConstraintsFluent<A extends SecurityContextConstraintsFluent<A>> extends Fluent<A>{
  public Boolean getAllowHostDirVolumePlugin();
  public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin);
  public Boolean hasAllowHostDirVolumePlugin();
  public Boolean getAllowHostIPC();
  public A withAllowHostIPC(Boolean allowHostIPC);
  public Boolean hasAllowHostIPC();
  public Boolean getAllowHostNetwork();
  public A withAllowHostNetwork(Boolean allowHostNetwork);
  public Boolean hasAllowHostNetwork();
  public Boolean getAllowHostPID();
  public A withAllowHostPID(Boolean allowHostPID);
  public Boolean hasAllowHostPID();
  public Boolean getAllowHostPorts();
  public A withAllowHostPorts(Boolean allowHostPorts);
  public Boolean hasAllowHostPorts();
  public Boolean getAllowPrivilegeEscalation();
  public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation);
  public Boolean hasAllowPrivilegeEscalation();
  public Boolean getAllowPrivilegedContainer();
  public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer);
  public Boolean hasAllowPrivilegedContainer();
  public A addToAllowedCapabilities(Integer index,String item);
  public A setToAllowedCapabilities(Integer index,String item);
  public A addToAllowedCapabilities(java.lang.String... items);
  public A addAllToAllowedCapabilities(Collection<String> items);
  public A removeFromAllowedCapabilities(java.lang.String... items);
  public A removeAllFromAllowedCapabilities(Collection<String> items);
  public List<String> getAllowedCapabilities();
  public String getAllowedCapability(Integer index);
  public String getFirstAllowedCapability();
  public String getLastAllowedCapability();
  public String getMatchingAllowedCapability(Predicate<String> predicate);
  public Boolean hasMatchingAllowedCapability(Predicate<String> predicate);
  public A withAllowedCapabilities(List<String> allowedCapabilities);
  public A withAllowedCapabilities(java.lang.String... allowedCapabilities);
  public Boolean hasAllowedCapabilities();
  public A addToAllowedFlexVolumes(Integer index,AllowedFlexVolume item);
  public A setToAllowedFlexVolumes(Integer index,AllowedFlexVolume item);
  public A addToAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... items);
  public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items);
  public A removeFromAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... items);
  public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items);
  public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AllowedFlexVolume> getAllowedFlexVolumes();
  public List<AllowedFlexVolume> buildAllowedFlexVolumes();
  public AllowedFlexVolume buildAllowedFlexVolume(Integer index);
  public AllowedFlexVolume buildFirstAllowedFlexVolume();
  public AllowedFlexVolume buildLastAllowedFlexVolume();
  public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
  public Boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
  public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes);
  public A withAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... allowedFlexVolumes);
  public Boolean hasAllowedFlexVolumes();
  public A addNewAllowedFlexVolume(String driver);
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume();
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item);
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(Integer index,AllowedFlexVolume item);
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(Integer index);
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume();
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume();
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
  public A addToAllowedUnsafeSysctls(Integer index,String item);
  public A setToAllowedUnsafeSysctls(Integer index,String item);
  public A addToAllowedUnsafeSysctls(java.lang.String... items);
  public A addAllToAllowedUnsafeSysctls(Collection<String> items);
  public A removeFromAllowedUnsafeSysctls(java.lang.String... items);
  public A removeAllFromAllowedUnsafeSysctls(Collection<String> items);
  public List<String> getAllowedUnsafeSysctls();
  public String getAllowedUnsafeSysctl(Integer index);
  public String getFirstAllowedUnsafeSysctl();
  public String getLastAllowedUnsafeSysctl();
  public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate);
  public Boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate);
  public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls);
  public A withAllowedUnsafeSysctls(java.lang.String... allowedUnsafeSysctls);
  public Boolean hasAllowedUnsafeSysctls();
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToDefaultAddCapabilities(Integer index,String item);
  public A setToDefaultAddCapabilities(Integer index,String item);
  public A addToDefaultAddCapabilities(java.lang.String... items);
  public A addAllToDefaultAddCapabilities(Collection<String> items);
  public A removeFromDefaultAddCapabilities(java.lang.String... items);
  public A removeAllFromDefaultAddCapabilities(Collection<String> items);
  public List<String> getDefaultAddCapabilities();
  public String getDefaultAddCapability(Integer index);
  public String getFirstDefaultAddCapability();
  public String getLastDefaultAddCapability();
  public String getMatchingDefaultAddCapability(Predicate<String> predicate);
  public Boolean hasMatchingDefaultAddCapability(Predicate<String> predicate);
  public A withDefaultAddCapabilities(List<String> defaultAddCapabilities);
  public A withDefaultAddCapabilities(java.lang.String... defaultAddCapabilities);
  public Boolean hasDefaultAddCapabilities();
  public Boolean getDefaultAllowPrivilegeEscalation();
  public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation);
  public Boolean hasDefaultAllowPrivilegeEscalation();
  public A addToForbiddenSysctls(Integer index,String item);
  public A setToForbiddenSysctls(Integer index,String item);
  public A addToForbiddenSysctls(java.lang.String... items);
  public A addAllToForbiddenSysctls(Collection<String> items);
  public A removeFromForbiddenSysctls(java.lang.String... items);
  public A removeAllFromForbiddenSysctls(Collection<String> items);
  public List<String> getForbiddenSysctls();
  public String getForbiddenSysctl(Integer index);
  public String getFirstForbiddenSysctl();
  public String getLastForbiddenSysctl();
  public String getMatchingForbiddenSysctl(Predicate<String> predicate);
  public Boolean hasMatchingForbiddenSysctl(Predicate<String> predicate);
  public A withForbiddenSysctls(List<String> forbiddenSysctls);
  public A withForbiddenSysctls(java.lang.String... forbiddenSysctls);
  public Boolean hasForbiddenSysctls();
  
  /**
   * This method has been deprecated, please use method buildFsGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public FSGroupStrategyOptions getFsGroup();
  public FSGroupStrategyOptions buildFsGroup();
  public A withFsGroup(FSGroupStrategyOptions fsGroup);
  public Boolean hasFsGroup();
  public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup();
  public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item);
  public SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup();
  public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroup();
  public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item);
  public A addToGroups(Integer index,String item);
  public A setToGroups(Integer index,String item);
  public A addToGroups(java.lang.String... items);
  public A addAllToGroups(Collection<String> items);
  public A removeFromGroups(java.lang.String... items);
  public A removeAllFromGroups(Collection<String> items);
  public List<String> getGroups();
  public String getGroup(Integer index);
  public String getFirstGroup();
  public String getLastGroup();
  public String getMatchingGroup(Predicate<String> predicate);
  public Boolean hasMatchingGroup(Predicate<String> predicate);
  public A withGroups(List<String> groups);
  public A withGroups(java.lang.String... groups);
  public Boolean hasGroups();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata();
  public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public SecurityContextConstraintsFluent.MetadataNested<A> editMetadata();
  public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadata();
  public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public Integer getPriority();
  public A withPriority(Integer priority);
  public Boolean hasPriority();
  public Boolean getReadOnlyRootFilesystem();
  public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
  public Boolean hasReadOnlyRootFilesystem();
  public A addToRequiredDropCapabilities(Integer index,String item);
  public A setToRequiredDropCapabilities(Integer index,String item);
  public A addToRequiredDropCapabilities(java.lang.String... items);
  public A addAllToRequiredDropCapabilities(Collection<String> items);
  public A removeFromRequiredDropCapabilities(java.lang.String... items);
  public A removeAllFromRequiredDropCapabilities(Collection<String> items);
  public List<String> getRequiredDropCapabilities();
  public String getRequiredDropCapability(Integer index);
  public String getFirstRequiredDropCapability();
  public String getLastRequiredDropCapability();
  public String getMatchingRequiredDropCapability(Predicate<String> predicate);
  public Boolean hasMatchingRequiredDropCapability(Predicate<String> predicate);
  public A withRequiredDropCapabilities(List<String> requiredDropCapabilities);
  public A withRequiredDropCapabilities(java.lang.String... requiredDropCapabilities);
  public Boolean hasRequiredDropCapabilities();
  
  /**
   * This method has been deprecated, please use method buildRunAsUser instead.
   * @return The buildable object.
   */
  @Deprecated
  public RunAsUserStrategyOptions getRunAsUser();
  public RunAsUserStrategyOptions buildRunAsUser();
  public A withRunAsUser(RunAsUserStrategyOptions runAsUser);
  public Boolean hasRunAsUser();
  public A withNewRunAsUser(String type,Long uid,Long uidRangeMax,Long uidRangeMin);
  public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser();
  public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item);
  public SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser();
  public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUser();
  public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item);
  
  /**
   * This method has been deprecated, please use method buildSeLinuxContext instead.
   * @return The buildable object.
   */
  @Deprecated
  public SELinuxContextStrategyOptions getSeLinuxContext();
  public SELinuxContextStrategyOptions buildSeLinuxContext();
  public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext);
  public Boolean hasSeLinuxContext();
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext();
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item);
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext();
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContext();
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContextLike(SELinuxContextStrategyOptions item);
  public A addToSeccompProfiles(Integer index,String item);
  public A setToSeccompProfiles(Integer index,String item);
  public A addToSeccompProfiles(java.lang.String... items);
  public A addAllToSeccompProfiles(Collection<String> items);
  public A removeFromSeccompProfiles(java.lang.String... items);
  public A removeAllFromSeccompProfiles(Collection<String> items);
  public List<String> getSeccompProfiles();
  public String getSeccompProfile(Integer index);
  public String getFirstSeccompProfile();
  public String getLastSeccompProfile();
  public String getMatchingSeccompProfile(Predicate<String> predicate);
  public Boolean hasMatchingSeccompProfile(Predicate<String> predicate);
  public A withSeccompProfiles(List<String> seccompProfiles);
  public A withSeccompProfiles(java.lang.String... seccompProfiles);
  public Boolean hasSeccompProfiles();
  
  /**
   * This method has been deprecated, please use method buildSupplementalGroups instead.
   * @return The buildable object.
   */
  @Deprecated
  public SupplementalGroupsStrategyOptions getSupplementalGroups();
  public SupplementalGroupsStrategyOptions buildSupplementalGroups();
  public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups);
  public Boolean hasSupplementalGroups();
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups();
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups();
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups();
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
  public A addToUsers(Integer index,String item);
  public A setToUsers(Integer index,String item);
  public A addToUsers(java.lang.String... items);
  public A addAllToUsers(Collection<String> items);
  public A removeFromUsers(java.lang.String... items);
  public A removeAllFromUsers(Collection<String> items);
  public List<String> getUsers();
  public String getUser(Integer index);
  public String getFirstUser();
  public String getLastUser();
  public String getMatchingUser(Predicate<String> predicate);
  public Boolean hasMatchingUser(Predicate<String> predicate);
  public A withUsers(List<String> users);
  public A withUsers(java.lang.String... users);
  public Boolean hasUsers();
  public A addToVolumes(Integer index,String item);
  public A setToVolumes(Integer index,String item);
  public A addToVolumes(java.lang.String... items);
  public A addAllToVolumes(Collection<String> items);
  public A removeFromVolumes(java.lang.String... items);
  public A removeAllFromVolumes(Collection<String> items);
  public List<String> getVolumes();
  public String getVolume(Integer index);
  public String getFirstVolume();
  public String getLastVolume();
  public String getMatchingVolume(Predicate<String> predicate);
  public Boolean hasMatchingVolume(Predicate<String> predicate);
  public A withVolumes(List<String> volumes);
  public A withVolumes(java.lang.String... volumes);
  public Boolean hasVolumes();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAllowHostDirVolumePlugin();
  public A withAllowHostIPC();
  public A withAllowHostNetwork();
  public A withAllowHostPID();
  public A withAllowHostPorts();
  public A withAllowPrivilegeEscalation();
  public A withAllowPrivilegedContainer();
  public A withDefaultAllowPrivilegeEscalation();
  public A withReadOnlyRootFilesystem();
  public interface AllowedFlexVolumesNested<N> extends Nested<N>,AllowedFlexVolumeFluent<SecurityContextConstraintsFluent.AllowedFlexVolumesNested<N>>{
    public N and();
    public N endAllowedFlexVolume();
    
  }
  public interface FsGroupNested<N> extends Nested<N>,FSGroupStrategyOptionsFluent<SecurityContextConstraintsFluent.FsGroupNested<N>>{
    public N and();
    public N endFsGroup();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<SecurityContextConstraintsFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface RunAsUserNested<N> extends Nested<N>,RunAsUserStrategyOptionsFluent<SecurityContextConstraintsFluent.RunAsUserNested<N>>{
    public N and();
    public N endRunAsUser();
    
  }
  public interface SeLinuxContextNested<N> extends Nested<N>,SELinuxContextStrategyOptionsFluent<SecurityContextConstraintsFluent.SeLinuxContextNested<N>>{
    public N and();
    public N endSeLinuxContext();
    
  }
  public interface SupplementalGroupsNested<N> extends Nested<N>,SupplementalGroupsStrategyOptionsFluent<SecurityContextConstraintsFluent.SupplementalGroupsNested<N>>{
    public N and();
    public N endSupplementalGroups();
    
  }
  
}