package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LifecycleHookBuilder extends LifecycleHookFluentImpl<LifecycleHookBuilder> implements VisitableBuilder<LifecycleHook,LifecycleHookBuilder>{
  public LifecycleHookBuilder() {
    this(false);
  }
  public LifecycleHookBuilder(Boolean validationEnabled) {
    this(new LifecycleHook(), validationEnabled);
  }
  public LifecycleHookBuilder(LifecycleHookFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LifecycleHook(), validationEnabled);
  }
  public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,LifecycleHook instance) {
    this(fluent, instance, false);
  }
  public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,LifecycleHook instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExecNewPod(instance.getExecNewPod()); 
    fluent.withFailurePolicy(instance.getFailurePolicy()); 
    fluent.withTagImages(instance.getTagImages()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LifecycleHookBuilder(LifecycleHook instance) {
    this(instance,false);
  }
  public LifecycleHookBuilder(LifecycleHook instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExecNewPod(instance.getExecNewPod()); 
    this.withFailurePolicy(instance.getFailurePolicy()); 
    this.withTagImages(instance.getTagImages()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  LifecycleHookFluent<?> fluent;
  Boolean validationEnabled;
  public LifecycleHook build() {
    LifecycleHook buildable = new LifecycleHook(fluent.getExecNewPod(),fluent.getFailurePolicy(),fluent.getTagImages());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}