package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageTagFluent<A extends ImageTagFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public Image getImage();
  public Image buildImage();
  public A withImage(Image image);
  public Boolean hasImage();
  public ImageTagFluent.ImageNested<A> withNewImage();
  public ImageTagFluent.ImageNested<A> withNewImageLike(Image item);
  public ImageTagFluent.ImageNested<A> editImage();
  public ImageTagFluent.ImageNested<A> editOrNewImage();
  public ImageTagFluent.ImageNested<A> editOrNewImageLike(Image item);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ImageTagFluent.MetadataNested<A> withNewMetadata();
  public ImageTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ImageTagFluent.MetadataNested<A> editMetadata();
  public ImageTagFluent.MetadataNested<A> editOrNewMetadata();
  public ImageTagFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public TagReference getSpec();
  public TagReference buildSpec();
  public A withSpec(TagReference spec);
  public Boolean hasSpec();
  public ImageTagFluent.SpecNested<A> withNewSpec();
  public ImageTagFluent.SpecNested<A> withNewSpecLike(TagReference item);
  public ImageTagFluent.SpecNested<A> editSpec();
  public ImageTagFluent.SpecNested<A> editOrNewSpec();
  public ImageTagFluent.SpecNested<A> editOrNewSpecLike(TagReference item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamedTagEventList getStatus();
  public NamedTagEventList buildStatus();
  public A withStatus(NamedTagEventList status);
  public Boolean hasStatus();
  public ImageTagFluent.StatusNested<A> withNewStatus();
  public ImageTagFluent.StatusNested<A> withNewStatusLike(NamedTagEventList item);
  public ImageTagFluent.StatusNested<A> editStatus();
  public ImageTagFluent.StatusNested<A> editOrNewStatus();
  public ImageTagFluent.StatusNested<A> editOrNewStatusLike(NamedTagEventList item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ImageNested<N> extends Nested<N>,ImageFluent<ImageTagFluent.ImageNested<N>>{
    public N and();
    public N endImage();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ImageTagFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,TagReferenceFluent<ImageTagFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,NamedTagEventListFluent<ImageTagFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}