/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.config.v1.OAuthSpec;
import io.fabric8.openshift.api.model.config.v1.OAuthSpecFluent;
import io.fabric8.openshift.api.model.config.v1.OAuthSpecFluentImpl;

public class OAuthSpecBuilder
extends OAuthSpecFluentImpl<OAuthSpecBuilder>
implements VisitableBuilder<OAuthSpec, OAuthSpecBuilder> {
    OAuthSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthSpecBuilder() {
        this(false);
    }

    public OAuthSpecBuilder(Boolean validationEnabled) {
        this(new OAuthSpec(), validationEnabled);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OAuthSpec(), validationEnabled);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent, OAuthSpec instance) {
        this(fluent, instance, false);
    }

    public OAuthSpecBuilder(OAuthSpecFluent<?> fluent, OAuthSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIdentityProviders(instance.getIdentityProviders());
        fluent.withTemplates(instance.getTemplates());
        fluent.withTokenConfig(instance.getTokenConfig());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public OAuthSpecBuilder(OAuthSpec instance) {
        this(instance, (Boolean)false);
    }

    public OAuthSpecBuilder(OAuthSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIdentityProviders(instance.getIdentityProviders());
        this.withTemplates(instance.getTemplates());
        this.withTokenConfig(instance.getTokenConfig());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public OAuthSpec build() {
        OAuthSpec buildable = new OAuthSpec(this.fluent.getIdentityProviders(), this.fluent.getTemplates(), this.fluent.getTokenConfig());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

