package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectRulesReviewStatusBuilder extends SubjectRulesReviewStatusFluentImpl<SubjectRulesReviewStatusBuilder> implements VisitableBuilder<SubjectRulesReviewStatus,SubjectRulesReviewStatusBuilder>{
  public SubjectRulesReviewStatusBuilder() {
    this(false);
  }
  public SubjectRulesReviewStatusBuilder(Boolean validationEnabled) {
    this(new SubjectRulesReviewStatus(), validationEnabled);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectRulesReviewStatus(), validationEnabled);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,SubjectRulesReviewStatus instance) {
    this(fluent, instance, false);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,SubjectRulesReviewStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEvaluationError(instance.getEvaluationError()); 
    fluent.withRules(instance.getRules()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatus instance) {
    this(instance,false);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEvaluationError(instance.getEvaluationError()); 
    this.withRules(instance.getRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SubjectRulesReviewStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectRulesReviewStatus build() {
    SubjectRulesReviewStatus buildable = new SubjectRulesReviewStatus(fluent.getEvaluationError(),fluent.getRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}