package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageSignatureFluentImpl<A extends ImageSignatureFluent<A>> extends BaseFluent<A> implements ImageSignatureFluent<A>{
  public ImageSignatureFluentImpl() {
  }
  public ImageSignatureFluentImpl(ImageSignature instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withContent(instance.getContent()); 
    this.withCreated(instance.getCreated()); 
    this.withImageIdentity(instance.getImageIdentity()); 
    this.withIssuedBy(instance.getIssuedBy()); 
    this.withIssuedTo(instance.getIssuedTo()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSignedClaims(instance.getSignedClaims()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<SignatureConditionBuilder> conditions = new ArrayList<SignatureConditionBuilder>();
  private String content;
  private String created;
  private String imageIdentity;
  private SignatureIssuerBuilder issuedBy;
  private SignatureSubjectBuilder issuedTo;
  private String kind;
  private ObjectMetaBuilder metadata;
  private Map<String,String> signedClaims;
  private String type;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToConditions(Integer index,SignatureCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<SignatureConditionBuilder>();}
    SignatureConditionBuilder builder = new SignatureConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,SignatureCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<SignatureConditionBuilder>();}
    SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.SignatureCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<SignatureConditionBuilder>();}
    for (SignatureCondition item : items) {SignatureConditionBuilder builder = new SignatureConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<SignatureCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<SignatureConditionBuilder>();}
    for (SignatureCondition item : items) {SignatureConditionBuilder builder = new SignatureConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.SignatureCondition... items) {
    for (SignatureCondition item : items) {SignatureConditionBuilder builder = new SignatureConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<SignatureCondition> items) {
    for (SignatureCondition item : items) {SignatureConditionBuilder builder = new SignatureConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<SignatureConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<SignatureConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      SignatureConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SignatureCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<SignatureCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public SignatureCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public SignatureCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public SignatureCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public SignatureCondition buildMatchingCondition(Predicate<SignatureConditionBuilder> predicate) {
    for (SignatureConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<SignatureConditionBuilder> predicate) {
    for (SignatureConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<SignatureCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (SignatureCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.SignatureCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (SignatureCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ImageSignatureFluent.ConditionsNested<A> addNewCondition() {
    return new ImageSignatureFluentImpl.ConditionsNestedImpl();
  }
  public ImageSignatureFluent.ConditionsNested<A> addNewConditionLike(SignatureCondition item) {
    return new ImageSignatureFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ImageSignatureFluent.ConditionsNested<A> setNewConditionLike(Integer index,SignatureCondition item) {
    return new ImageSignatureFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ImageSignatureFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ImageSignatureFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ImageSignatureFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ImageSignatureFluent.ConditionsNested<A> editMatchingCondition(Predicate<SignatureConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getContent() {
    return this.content;
  }
  public A withContent(String content) {
    this.content=content; return (A) this;
  }
  public Boolean hasContent() {
    return this.content != null;
  }
  public String getCreated() {
    return this.created;
  }
  public A withCreated(String created) {
    this.created=created; return (A) this;
  }
  public Boolean hasCreated() {
    return this.created != null;
  }
  public String getImageIdentity() {
    return this.imageIdentity;
  }
  public A withImageIdentity(String imageIdentity) {
    this.imageIdentity=imageIdentity; return (A) this;
  }
  public Boolean hasImageIdentity() {
    return this.imageIdentity != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIssuedBy instead.
   * @return The buildable object.
   */
  @Deprecated
  public SignatureIssuer getIssuedBy() {
    return this.issuedBy!=null ?this.issuedBy.build():null;
  }
  public SignatureIssuer buildIssuedBy() {
    return this.issuedBy!=null ?this.issuedBy.build():null;
  }
  public A withIssuedBy(SignatureIssuer issuedBy) {
    _visitables.get("issuedBy").remove(this.issuedBy);
    if (issuedBy!=null){ this.issuedBy= new SignatureIssuerBuilder(issuedBy); _visitables.get("issuedBy").add(this.issuedBy);} else { this.issuedBy = null; _visitables.get("issuedBy").remove(this.issuedBy); } return (A) this;
  }
  public Boolean hasIssuedBy() {
    return this.issuedBy != null;
  }
  public A withNewIssuedBy(String commonName,String organization) {
    return (A)withIssuedBy(new SignatureIssuer(commonName, organization));
  }
  public ImageSignatureFluent.IssuedByNested<A> withNewIssuedBy() {
    return new ImageSignatureFluentImpl.IssuedByNestedImpl();
  }
  public ImageSignatureFluent.IssuedByNested<A> withNewIssuedByLike(SignatureIssuer item) {
    return new ImageSignatureFluentImpl.IssuedByNestedImpl(item);
  }
  public ImageSignatureFluent.IssuedByNested<A> editIssuedBy() {
    return withNewIssuedByLike(getIssuedBy());
  }
  public ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedBy() {
    return withNewIssuedByLike(getIssuedBy() != null ? getIssuedBy(): new SignatureIssuerBuilder().build());
  }
  public ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedByLike(SignatureIssuer item) {
    return withNewIssuedByLike(getIssuedBy() != null ? getIssuedBy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIssuedTo instead.
   * @return The buildable object.
   */
  @Deprecated
  public SignatureSubject getIssuedTo() {
    return this.issuedTo!=null ?this.issuedTo.build():null;
  }
  public SignatureSubject buildIssuedTo() {
    return this.issuedTo!=null ?this.issuedTo.build():null;
  }
  public A withIssuedTo(SignatureSubject issuedTo) {
    _visitables.get("issuedTo").remove(this.issuedTo);
    if (issuedTo!=null){ this.issuedTo= new SignatureSubjectBuilder(issuedTo); _visitables.get("issuedTo").add(this.issuedTo);} else { this.issuedTo = null; _visitables.get("issuedTo").remove(this.issuedTo); } return (A) this;
  }
  public Boolean hasIssuedTo() {
    return this.issuedTo != null;
  }
  public A withNewIssuedTo(String commonName,String organization,String publicKeyID) {
    return (A)withIssuedTo(new SignatureSubject(commonName, organization, publicKeyID));
  }
  public ImageSignatureFluent.IssuedToNested<A> withNewIssuedTo() {
    return new ImageSignatureFluentImpl.IssuedToNestedImpl();
  }
  public ImageSignatureFluent.IssuedToNested<A> withNewIssuedToLike(SignatureSubject item) {
    return new ImageSignatureFluentImpl.IssuedToNestedImpl(item);
  }
  public ImageSignatureFluent.IssuedToNested<A> editIssuedTo() {
    return withNewIssuedToLike(getIssuedTo());
  }
  public ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedTo() {
    return withNewIssuedToLike(getIssuedTo() != null ? getIssuedTo(): new SignatureSubjectBuilder().build());
  }
  public ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedToLike(SignatureSubject item) {
    return withNewIssuedToLike(getIssuedTo() != null ? getIssuedTo(): item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ImageSignatureFluent.MetadataNested<A> withNewMetadata() {
    return new ImageSignatureFluentImpl.MetadataNestedImpl();
  }
  public ImageSignatureFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ImageSignatureFluentImpl.MetadataNestedImpl(item);
  }
  public ImageSignatureFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ImageSignatureFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ImageSignatureFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToSignedClaims(String key,String value) {
    if(this.signedClaims == null && key != null && value != null) { this.signedClaims = new LinkedHashMap(); }
    if(key != null && value != null) {this.signedClaims.put(key, value);} return (A)this;
  }
  public A addToSignedClaims(Map<String,String> map) {
    if(this.signedClaims == null && map != null) { this.signedClaims = new LinkedHashMap(); }
    if(map != null) { this.signedClaims.putAll(map);} return (A)this;
  }
  public A removeFromSignedClaims(String key) {
    if(this.signedClaims == null) { return (A) this; }
    if(key != null && this.signedClaims != null) {this.signedClaims.remove(key);} return (A)this;
  }
  public A removeFromSignedClaims(Map<String,String> map) {
    if(this.signedClaims == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.signedClaims != null){this.signedClaims.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSignedClaims() {
    return this.signedClaims;
  }
  public <K,V>A withSignedClaims(Map<String,String> signedClaims) {
    if (signedClaims == null) { this.signedClaims =  null;} else {this.signedClaims = new LinkedHashMap(signedClaims);} return (A) this;
  }
  public Boolean hasSignedClaims() {
    return this.signedClaims != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageSignatureFluentImpl that = (ImageSignatureFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (content != null ? !content.equals(that.content) :that.content != null) return false;
    if (created != null ? !created.equals(that.created) :that.created != null) return false;
    if (imageIdentity != null ? !imageIdentity.equals(that.imageIdentity) :that.imageIdentity != null) return false;
    if (issuedBy != null ? !issuedBy.equals(that.issuedBy) :that.issuedBy != null) return false;
    if (issuedTo != null ? !issuedTo.equals(that.issuedTo) :that.issuedTo != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (signedClaims != null ? !signedClaims.equals(that.signedClaims) :that.signedClaims != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  conditions,  content,  created,  imageIdentity,  issuedBy,  issuedTo,  kind,  metadata,  signedClaims,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (content != null) { sb.append("content:"); sb.append(content + ","); }
    if (created != null) { sb.append("created:"); sb.append(created + ","); }
    if (imageIdentity != null) { sb.append("imageIdentity:"); sb.append(imageIdentity + ","); }
    if (issuedBy != null) { sb.append("issuedBy:"); sb.append(issuedBy + ","); }
    if (issuedTo != null) { sb.append("issuedTo:"); sb.append(issuedTo + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (signedClaims != null && !signedClaims.isEmpty()) { sb.append("signedClaims:"); sb.append(signedClaims + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends SignatureConditionFluentImpl<ImageSignatureFluent.ConditionsNested<N>> implements ImageSignatureFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,SignatureCondition item) {
      this.index = index;
      this.builder = new SignatureConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new SignatureConditionBuilder(this);
    }
    SignatureConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ImageSignatureFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class IssuedByNestedImpl<N> extends SignatureIssuerFluentImpl<ImageSignatureFluent.IssuedByNested<N>> implements ImageSignatureFluent.IssuedByNested<N>,Nested<N>{
    IssuedByNestedImpl(SignatureIssuer item) {
      this.builder = new SignatureIssuerBuilder(this, item);
    }
    IssuedByNestedImpl() {
      this.builder = new SignatureIssuerBuilder(this);
    }
    SignatureIssuerBuilder builder;
    public N and() {
      return (N) ImageSignatureFluentImpl.this.withIssuedBy(builder.build());
    }
    public N endIssuedBy() {
      return and();
    }
    
  }
  class IssuedToNestedImpl<N> extends SignatureSubjectFluentImpl<ImageSignatureFluent.IssuedToNested<N>> implements ImageSignatureFluent.IssuedToNested<N>,Nested<N>{
    IssuedToNestedImpl(SignatureSubject item) {
      this.builder = new SignatureSubjectBuilder(this, item);
    }
    IssuedToNestedImpl() {
      this.builder = new SignatureSubjectBuilder(this);
    }
    SignatureSubjectBuilder builder;
    public N and() {
      return (N) ImageSignatureFluentImpl.this.withIssuedTo(builder.build());
    }
    public N endIssuedTo() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageSignatureFluent.MetadataNested<N>> implements ImageSignatureFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageSignatureFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}