package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface GroupListFluent<A extends GroupListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,Group item);
  public A setToItems(Integer index,Group item);
  public A addToItems(io.fabric8.openshift.api.model.Group... items);
  public A addAllToItems(Collection<Group> items);
  public A removeFromItems(io.fabric8.openshift.api.model.Group... items);
  public A removeAllFromItems(Collection<Group> items);
  public A removeMatchingFromItems(Predicate<GroupBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Group> getItems();
  public List<Group> buildItems();
  public Group buildItem(Integer index);
  public Group buildFirstItem();
  public Group buildLastItem();
  public Group buildMatchingItem(Predicate<GroupBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<GroupBuilder> predicate);
  public A withItems(List<Group> items);
  public A withItems(io.fabric8.openshift.api.model.Group... items);
  public Boolean hasItems();
  public GroupListFluent.ItemsNested<A> addNewItem();
  public GroupListFluent.ItemsNested<A> addNewItemLike(Group item);
  public GroupListFluent.ItemsNested<A> setNewItemLike(Integer index,Group item);
  public GroupListFluent.ItemsNested<A> editItem(Integer index);
  public GroupListFluent.ItemsNested<A> editFirstItem();
  public GroupListFluent.ItemsNested<A> editLastItem();
  public GroupListFluent.ItemsNested<A> editMatchingItem(Predicate<GroupBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,GroupFluent<GroupListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}