package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapBuildSourceBuilder extends ConfigMapBuildSourceFluentImpl<ConfigMapBuildSourceBuilder> implements VisitableBuilder<ConfigMapBuildSource,ConfigMapBuildSourceBuilder>{
  public ConfigMapBuildSourceBuilder() {
    this(false);
  }
  public ConfigMapBuildSourceBuilder(Boolean validationEnabled) {
    this(new ConfigMapBuildSource(), validationEnabled);
  }
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapBuildSource(), validationEnabled);
  }
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSourceFluent<?> fluent,ConfigMapBuildSource instance) {
    this(fluent, instance, false);
  }
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSourceFluent<?> fluent,ConfigMapBuildSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMap(instance.getConfigMap()); 
    fluent.withDestinationDir(instance.getDestinationDir()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSource instance) {
    this(instance,false);
  }
  public ConfigMapBuildSourceBuilder(ConfigMapBuildSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMap(instance.getConfigMap()); 
    this.withDestinationDir(instance.getDestinationDir()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConfigMapBuildSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapBuildSource build() {
    ConfigMapBuildSource buildable = new ConfigMapBuildSource(fluent.getConfigMap(),fluent.getDestinationDir());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}