package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StepInfoBuilder extends StepInfoFluentImpl<StepInfoBuilder> implements VisitableBuilder<StepInfo,StepInfoBuilder>{
  public StepInfoBuilder() {
    this(false);
  }
  public StepInfoBuilder(Boolean validationEnabled) {
    this(new StepInfo(), validationEnabled);
  }
  public StepInfoBuilder(StepInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public StepInfoBuilder(StepInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StepInfo(), validationEnabled);
  }
  public StepInfoBuilder(StepInfoFluent<?> fluent,StepInfo instance) {
    this(fluent, instance, false);
  }
  public StepInfoBuilder(StepInfoFluent<?> fluent,StepInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDurationMilliseconds(instance.getDurationMilliseconds()); 
    fluent.withName(instance.getName()); 
    fluent.withStartTime(instance.getStartTime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StepInfoBuilder(StepInfo instance) {
    this(instance,false);
  }
  public StepInfoBuilder(StepInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDurationMilliseconds(instance.getDurationMilliseconds()); 
    this.withName(instance.getName()); 
    this.withStartTime(instance.getStartTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StepInfoFluent<?> fluent;
  Boolean validationEnabled;
  public StepInfo build() {
    StepInfo buildable = new StepInfo(fluent.getDurationMilliseconds(),fluent.getName(),fluent.getStartTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}