package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountPodSecurityPolicyReviewStatusBuilder extends ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<ServiceAccountPodSecurityPolicyReviewStatusBuilder> implements VisitableBuilder<ServiceAccountPodSecurityPolicyReviewStatus,ServiceAccountPodSecurityPolicyReviewStatusBuilder>{
  public ServiceAccountPodSecurityPolicyReviewStatusBuilder() {
    this(false);
  }
  public ServiceAccountPodSecurityPolicyReviewStatusBuilder(Boolean validationEnabled) {
    this(new ServiceAccountPodSecurityPolicyReviewStatus(), validationEnabled);
  }
  public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceAccountPodSecurityPolicyReviewStatus(), validationEnabled);
  }
  public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent,ServiceAccountPodSecurityPolicyReviewStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent,ServiceAccountPodSecurityPolicyReviewStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowedBy(instance.getAllowedBy()); 
    fluent.withName(instance.getName()); 
    fluent.withReason(instance.getReason()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatus instance) {
    this(instance,false);
  }
  public ServiceAccountPodSecurityPolicyReviewStatusBuilder(ServiceAccountPodSecurityPolicyReviewStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowedBy(instance.getAllowedBy()); 
    this.withName(instance.getName()); 
    this.withReason(instance.getReason()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceAccountPodSecurityPolicyReviewStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceAccountPodSecurityPolicyReviewStatus build() {
    ServiceAccountPodSecurityPolicyReviewStatus buildable = new ServiceAccountPodSecurityPolicyReviewStatus(fluent.getAllowedBy(),fluent.getName(),fluent.getReason(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}