package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelfSubjectRulesReviewSpecBuilder extends SelfSubjectRulesReviewSpecFluentImpl<SelfSubjectRulesReviewSpecBuilder> implements VisitableBuilder<SelfSubjectRulesReviewSpec,SelfSubjectRulesReviewSpecBuilder>{
  public SelfSubjectRulesReviewSpecBuilder() {
    this(false);
  }
  public SelfSubjectRulesReviewSpecBuilder(Boolean validationEnabled) {
    this(new SelfSubjectRulesReviewSpec(), validationEnabled);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelfSubjectRulesReviewSpec(), validationEnabled);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance) {
    this(fluent, instance, false);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withScopes(instance.getScopes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance) {
    this(instance,false);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withScopes(instance.getScopes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SelfSubjectRulesReviewSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SelfSubjectRulesReviewSpec build() {
    SelfSubjectRulesReviewSpec buildable = new SelfSubjectRulesReviewSpec(fluent.getScopes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}