package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.NamespaceCondition;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProjectStatusFluentImpl<A extends ProjectStatusFluent<A>> extends BaseFluent<A> implements ProjectStatusFluent<A>{
  public ProjectStatusFluentImpl() {
  }
  public ProjectStatusFluentImpl(ProjectStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<NamespaceCondition> conditions = new ArrayList<NamespaceCondition>();
  private String phase;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,NamespaceCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<NamespaceCondition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(Integer index,NamespaceCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<NamespaceCondition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<NamespaceCondition>();}
    for (NamespaceCondition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<NamespaceCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<NamespaceCondition>();}
    for (NamespaceCondition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... items) {
    for (NamespaceCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<NamespaceCondition> items) {
    for (NamespaceCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<NamespaceCondition> getConditions() {
    return this.conditions;
  }
  public NamespaceCondition getCondition(Integer index) {
    return this.conditions.get(index);
  }
  public NamespaceCondition getFirstCondition() {
    return this.conditions.get(0);
  }
  public NamespaceCondition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public NamespaceCondition getMatchingCondition(Predicate<NamespaceCondition> predicate) {
    for (NamespaceCondition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<NamespaceCondition> predicate) {
    for (NamespaceCondition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<NamespaceCondition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (NamespaceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (NamespaceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
  }
  public String getPhase() {
    return this.phase;
  }
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  public Boolean hasPhase() {
    return this.phase != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProjectStatusFluentImpl that = (ProjectStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  phase,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}