package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>> extends BaseFluent<A> implements RouteStatusFluent<A>{
  public RouteStatusFluentImpl() {
  }
  public RouteStatusFluentImpl(RouteStatus instance) {
    this.withIngress(instance.getIngress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<RouteIngressBuilder> ingress = new ArrayList<RouteIngressBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToIngress(Integer index,RouteIngress item) {
    if (this.ingress == null) {this.ingress = new ArrayList<RouteIngressBuilder>();}
    RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
  }
  public A setToIngress(Integer index,RouteIngress item) {
    if (this.ingress == null) {this.ingress = new ArrayList<RouteIngressBuilder>();}
    RouteIngressBuilder builder = new RouteIngressBuilder(item);
    if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
    if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
     return (A)this;
  }
  public A addToIngress(io.fabric8.openshift.api.model.RouteIngress... items) {
    if (this.ingress == null) {this.ingress = new ArrayList<RouteIngressBuilder>();}
    for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A addAllToIngress(Collection<RouteIngress> items) {
    if (this.ingress == null) {this.ingress = new ArrayList<RouteIngressBuilder>();}
    for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A removeFromIngress(io.fabric8.openshift.api.model.RouteIngress... items) {
    for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeAllFromIngress(Collection<RouteIngress> items) {
    for (RouteIngress item : items) {RouteIngressBuilder builder = new RouteIngressBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIngress(Predicate<RouteIngressBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<RouteIngressBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      RouteIngressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RouteIngress> getIngress() {
    return ingress != null ? build(ingress) : null;
  }
  public List<RouteIngress> buildIngress() {
    return ingress != null ? build(ingress) : null;
  }
  public RouteIngress buildIngress(Integer index) {
    return this.ingress.get(index).build();
  }
  public RouteIngress buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  public RouteIngress buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  public RouteIngress buildMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
    for (RouteIngressBuilder item: ingress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
    for (RouteIngressBuilder item: ingress) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIngress(List<RouteIngress> ingress) {
    if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
    if (ingress != null) {this.ingress = new ArrayList(); for (RouteIngress item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
  }
  public A withIngress(io.fabric8.openshift.api.model.RouteIngress... ingress) {
    if (this.ingress != null) {this.ingress.clear();}
    if (ingress != null) {for (RouteIngress item :ingress){ this.addToIngress(item);}} return (A) this;
  }
  public Boolean hasIngress() {
    return ingress != null && !ingress.isEmpty();
  }
  public RouteStatusFluent.IngressNested<A> addNewIngress() {
    return new RouteStatusFluentImpl.IngressNestedImpl();
  }
  public RouteStatusFluent.IngressNested<A> addNewIngressLike(RouteIngress item) {
    return new RouteStatusFluentImpl.IngressNestedImpl(-1, item);
  }
  public RouteStatusFluent.IngressNested<A> setNewIngressLike(Integer index,RouteIngress item) {
    return new RouteStatusFluentImpl.IngressNestedImpl(index, item);
  }
  public RouteStatusFluent.IngressNested<A> editIngress(Integer index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public RouteStatusFluent.IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  public RouteStatusFluent.IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public RouteStatusFluent.IngressNested<A> editMatchingIngress(Predicate<RouteIngressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RouteStatusFluentImpl that = (RouteStatusFluentImpl) o;
    if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ingress,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ingress != null && !ingress.isEmpty()) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class IngressNestedImpl<N> extends RouteIngressFluentImpl<RouteStatusFluent.IngressNested<N>> implements RouteStatusFluent.IngressNested<N>,Nested<N>{
    IngressNestedImpl(Integer index,RouteIngress item) {
      this.index = index;
      this.builder = new RouteIngressBuilder(this, item);
    }
    IngressNestedImpl() {
      this.index = -1;
      this.builder = new RouteIngressBuilder(this);
    }
    RouteIngressBuilder builder;
    Integer index;
    public N and() {
      return (N) RouteStatusFluentImpl.this.setToIngress(index,builder.build());
    }
    public N endIngress() {
      return and();
    }
    
  }
  
}