package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageChangeTriggerStatusBuilder extends ImageChangeTriggerStatusFluentImpl<ImageChangeTriggerStatusBuilder> implements VisitableBuilder<ImageChangeTriggerStatus,ImageChangeTriggerStatusBuilder>{
  public ImageChangeTriggerStatusBuilder() {
    this(false);
  }
  public ImageChangeTriggerStatusBuilder(Boolean validationEnabled) {
    this(new ImageChangeTriggerStatus(), validationEnabled);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageChangeTriggerStatus(), validationEnabled);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatusFluent<?> fluent,ImageChangeTriggerStatus instance) {
    this(fluent, instance, false);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatusFluent<?> fluent,ImageChangeTriggerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFrom(instance.getFrom()); 
    fluent.withLastTriggerTime(instance.getLastTriggerTime()); 
    fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatus instance) {
    this(instance,false);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFrom(instance.getFrom()); 
    this.withLastTriggerTime(instance.getLastTriggerTime()); 
    this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageChangeTriggerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImageChangeTriggerStatus build() {
    ImageChangeTriggerStatus buildable = new ImageChangeTriggerStatus(fluent.getFrom(),fluent.getLastTriggerTime(),fluent.getLastTriggeredImageID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}